/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.spark.db;

import org.apache.iotdb.spark.db.IoTDBPartition;
import org.apache.iotdb.spark.db.IoTDBPartitioningInfo;
import org.apache.iotdb.spark.db.IoTDBRelation;
import org.apache.iotdb.spark.db.SQLConstant$;
import org.apache.spark.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class IoTDBRelation$ {
    public static final IoTDBRelation$ MODULE$;
    private final Logger logger;

    static {
        new IoTDBRelation$();
    }

    private final Logger logger() {
        return this.logger;
    }

    public Partition[] getPartitions(IoTDBPartitioningInfo partitionInfo) {
        long l;
        long end;
        if (partitionInfo == null || partitionInfo.numPartitions() <= 1 || partitionInfo.start() == partitionInfo.end()) {
            return (Partition[])((Object[])new Partition[]{new IoTDBPartition(null, 0, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L))});
        }
        long start = partitionInfo.start();
        Predef$.MODULE$.require(start <= (end = partitionInfo.end()), (Function0)new Serializable(start, end){
            public static final long serialVersionUID = 0L;
            private final long start$1;
            private final long end$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Operation not allowed: the start time is larger than end time ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time start: ", "; end: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.end$1)}))).toString();
            }
            {
                this.start$1 = start$1;
                this.end$1 = end$1;
            }
        });
        if (end - start >= (long)partitionInfo.numPartitions()) {
            l = partitionInfo.numPartitions();
        } else {
            this.logger().warn(new StringBuilder().append((Object)"The number of partitions is reduced because the specified number of partitions is less than the difference between upper bound and lower bound. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated number of partitions: ", "; Input number of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(end - start))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitions: ", "; Lower bound: ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionInfo.numPartitions()), BoxesRunTime.boxToLong((long)start)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Upper bound: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)end)}))).toString());
            l = end - start;
        }
        long numPartitions = l;
        ArrayBuffer partitions = new ArrayBuffer();
        long length = (end - start) / numPartitions + 1L;
        int i = 0;
        long currentValue = start;
        while ((long)i < numPartitions) {
            ArrayBuffer arrayBuffer;
            String where = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})).s((Seq)Nil$.MODULE$);
            if (i == 0) {
                where = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ", " and ", " <= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConstant$.MODULE$.RESERVED_TIME(), BoxesRunTime.boxToLong((long)currentValue), SQLConstant$.MODULE$.RESERVED_TIME(), BoxesRunTime.boxToLong((long)(currentValue + length))}));
                arrayBuffer = partitions.$plus$eq((Object)new IoTDBPartition(where, i, Predef$.MODULE$.long2Long(currentValue), Predef$.MODULE$.long2Long(currentValue + length)));
            } else {
                where = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " > ", " and ", " <= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConstant$.MODULE$.RESERVED_TIME(), BoxesRunTime.boxToLong((long)currentValue), SQLConstant$.MODULE$.RESERVED_TIME(), BoxesRunTime.boxToLong((long)(currentValue + length))}));
                arrayBuffer = partitions.$plus$eq((Object)new IoTDBPartition(where, i, Predef$.MODULE$.long2Long(currentValue + 1L), Predef$.MODULE$.long2Long(currentValue + length)));
            }
            ++i;
            currentValue += length;
        }
        return (Partition[])partitions.toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    private IoTDBRelation$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(IoTDBRelation.class);
    }
}

