/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.service;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.udf.service.SnapshotUtils;

public class UDFExecutableManager
extends ExecutableManager
implements IService,
SnapshotProcessor {
    private static UDFExecutableManager INSTANCE = null;

    private UDFExecutableManager(String temporaryLibRoot, String udfLibRoot) {
        super(temporaryLibRoot, udfLibRoot);
    }

    public void removeUDFJarFromExtLibDir(String functionName) {
        FileUtils.deleteQuietly((File)this.getDirUnderLibRootByName(functionName));
    }

    @Override
    public void start() throws StartupException {
        try {
            SystemFileFactory.INSTANCE.makeDirIfNecessary(this.temporaryLibRoot);
            SystemFileFactory.INSTANCE.makeDirIfNecessary(this.libRoot);
        }
        catch (Exception e) {
            throw new StartupException(e);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ServiceType getID() {
        return ServiceType.UDF_EXECUTABLE_MANAGER_SERVICE;
    }

    public static synchronized UDFExecutableManager setupAndGetInstance(String temporaryLibRoot, String udfLibRoot) {
        if (INSTANCE == null) {
            INSTANCE = new UDFExecutableManager(temporaryLibRoot, udfLibRoot);
        }
        return INSTANCE;
    }

    public static UDFExecutableManager getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        return SnapshotUtils.takeSnapshotForDir(this.temporaryLibRoot, snapshotDir.getAbsolutePath() + File.separator + "ext" + File.separator + "temporary") && SnapshotUtils.takeSnapshotForDir(this.libRoot, snapshotDir.getAbsolutePath() + File.separator + "ext" + File.separator + "udf");
    }

    @Override
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        SnapshotUtils.loadSnapshotForDir(snapshotDir.getAbsolutePath() + File.separator + "ext" + File.separator + "temporary", this.temporaryLibRoot);
        SnapshotUtils.loadSnapshotForDir(snapshotDir.getAbsolutePath() + File.separator + "ext" + File.separator + "udf", this.libRoot);
    }
}

