/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.sync.pipesink;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.sync.PipeSinkException;
import org.apache.iotdb.commons.sync.pipesink.IoTDBPipeSink;
import org.apache.iotdb.confignode.rpc.thrift.TPipeSinkInfo;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public interface PipeSink {
    public void setAttribute(List<Pair<String, String>> var1) throws PipeSinkException;

    public void setAttribute(Map<String, String> var1) throws PipeSinkException;

    public String getPipeSinkName();

    public PipeSinkType getType();

    public String showAllAttributes();

    public TPipeSinkInfo getTPipeSinkInfo();

    public void serialize(OutputStream var1) throws IOException;

    public void deserialize(InputStream var1) throws IOException;

    public void deserialize(ByteBuffer var1);

    public static PipeSink deserializePipeSink(InputStream inputStream) throws IOException {
        IoTDBPipeSink pipeSink;
        PipeSinkType pipeSinkType = PipeSinkType.values()[ReadWriteIOUtils.readByte((InputStream)inputStream)];
        switch (pipeSinkType) {
            case IoTDB: {
                pipeSink = new IoTDBPipeSink();
                pipeSink.deserialize(inputStream);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Can not recognize PipeSinkType %s.", pipeSinkType.name()));
            }
        }
        return pipeSink;
    }

    public static PipeSink deserializePipeSink(ByteBuffer buffer) {
        IoTDBPipeSink pipeSink;
        PipeSinkType pipeSinkType = PipeSinkType.values()[ReadWriteIOUtils.readByte((ByteBuffer)buffer)];
        switch (pipeSinkType) {
            case IoTDB: {
                pipeSink = new IoTDBPipeSink();
                pipeSink.deserialize(buffer);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Can not recognize PipeSinkType %s.", pipeSinkType.name()));
            }
        }
        return pipeSink;
    }

    public static enum PipeSinkType {
        IoTDB,
        ExternalPipe;

    }
}

