/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.role;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.role.IRoleAccessor;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.IOUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileRoleAccessor
implements IRoleAccessor {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileRoleAccessor.class);
    private static final String TEMP_SUFFIX = ".temp";
    private static final String STRING_ENCODING = "utf-8";
    private static final String roleSnapshotFileName = "system" + File.separator + "roles";
    private String roleDirPath;
    private ThreadLocal<ByteBuffer> encodingBufferLocal = new ThreadLocal();
    private ThreadLocal<byte[]> strBufferLocal = new ThreadLocal();

    public LocalFileRoleAccessor(String roleDirPath) {
        this.roleDirPath = roleDirPath;
    }

    @Override
    public Role loadRole(String rolename) throws IOException {
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + rolename + ".profile");
        if (!roleProfile.exists() || !roleProfile.isFile()) {
            File backProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + rolename + ".profile" + TEMP_SUFFIX);
            if (backProfile.exists() && backProfile.isFile()) {
                roleProfile = backProfile;
            } else {
                return null;
            }
        }
        FileInputStream inputStream = new FileInputStream(roleProfile);
        try {
            Role role;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            try {
                Role role2 = new Role();
                role2.setName(IOUtils.readString(dataInputStream, STRING_ENCODING, this.strBufferLocal));
                int privilegeNum = dataInputStream.readInt();
                ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
                for (int i = 0; i < privilegeNum; ++i) {
                    pathPrivilegeList.add(IOUtils.readPathPrivilege(dataInputStream, STRING_ENCODING, this.strBufferLocal));
                }
                role2.setPrivilegeList(pathPrivilegeList);
                role = role2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dataInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            dataInputStream.close();
            return role;
        }
        finally {
            this.strBufferLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveRole(Role role) throws IOException {
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + role.getName() + ".profile" + TEMP_SUFFIX);
        File roleDir = new File(this.roleDirPath);
        if (!roleDir.exists()) {
            roleDir.mkdirs();
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(roleProfile));){
            try {
                IOUtils.writeString(outputStream, role.getName(), STRING_ENCODING, this.encodingBufferLocal);
                role.getPrivilegeList().sort(PathPrivilege.REFERENCE_DESCENT_SORTER);
                int privilegeNum = role.getPrivilegeList().size();
                IOUtils.writeInt(outputStream, privilegeNum, this.encodingBufferLocal);
                for (int i = 0; i < privilegeNum; ++i) {
                    PathPrivilege pathPrivilege = role.getPrivilegeList().get(i);
                    IOUtils.writePathPrivilege(outputStream, pathPrivilege, STRING_ENCODING, this.encodingBufferLocal);
                }
                outputStream.flush();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            this.encodingBufferLocal.remove();
        }
        File oldFile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + role.getName() + ".profile");
        IOUtils.replaceFile(roleProfile, oldFile);
    }

    @Override
    public boolean deleteRole(String rolename) throws IOException {
        File roleProfile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + rolename + ".profile");
        File backFile = SystemFileFactory.INSTANCE.getFile(this.roleDirPath + File.separator + rolename + ".profile" + TEMP_SUFFIX);
        if (!roleProfile.exists() && !backFile.exists()) {
            return false;
        }
        if (roleProfile.exists() && !roleProfile.delete() || backFile.exists() && !backFile.delete()) {
            throw new IOException(String.format("Cannot delete role file of %s", rolename));
        }
        return true;
    }

    @Override
    public List<String> listAllRoles() {
        File roleDir = SystemFileFactory.INSTANCE.getFile(this.roleDirPath);
        String[] names = roleDir.list((dir, name) -> name.endsWith(".profile") || name.endsWith(TEMP_SUFFIX));
        ArrayList<String> retList = new ArrayList<String>();
        if (names != null) {
            HashSet<String> set = new HashSet<String>();
            for (String fileName : names) {
                set.add(fileName.replace(".profile", "").replace(TEMP_SUFFIX, ""));
            }
            retList.addAll(set);
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File roleFolder = systemFileFactory.getFile(this.roleDirPath);
        File roleSnapshotDir = systemFileFactory.getFile(snapshotDir, roleSnapshotFileName);
        File roleTmpSnapshotDir = systemFileFactory.getFile(roleSnapshotDir.getAbsolutePath() + "-" + UUID.randomUUID());
        boolean result = true;
        try {
            result = org.apache.iotdb.commons.utils.FileUtils.copyDir(roleFolder, roleTmpSnapshotDir);
        }
        finally {
            if (roleTmpSnapshotDir.exists() && !roleTmpSnapshotDir.delete()) {
                org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(roleTmpSnapshotDir);
            }
        }
        return result &= roleTmpSnapshotDir.renameTo(roleSnapshotDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File roleFolder = systemFileFactory.getFile(this.roleDirPath);
        File roleTmpFolder = systemFileFactory.getFile(roleFolder.getAbsolutePath() + "-" + UUID.randomUUID());
        File roleSnapshotDir = systemFileFactory.getFile(snapshotDir, roleSnapshotFileName);
        try {
            FileUtils.moveDirectory((File)roleFolder, (File)roleTmpFolder);
            if (!org.apache.iotdb.commons.utils.FileUtils.copyDir(roleSnapshotDir, roleFolder)) {
                logger.error("Failed to load role folder snapshot and rollback.");
                org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(roleFolder);
                FileUtils.moveDirectory((File)roleTmpFolder, (File)roleFolder);
            }
        }
        finally {
            org.apache.iotdb.commons.utils.FileUtils.deleteDirectory(roleTmpFolder);
        }
    }

    @Override
    public void reset() {
        if (SystemFileFactory.INSTANCE.getFile(this.roleDirPath).mkdirs()) {
            logger.info("role info dir {} is created", (Object)this.roleDirPath);
        } else if (!SystemFileFactory.INSTANCE.getFile(this.roleDirPath).exists()) {
            logger.error("role info dir {} can not be created", (Object)this.roleDirPath);
        }
    }
}

