/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.mybatis.plugin.generator.resolver;

import java.util.HashMap;
import java.util.Map;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.internal.types.JavaTypeResolverDefaultImpl;

public class IoTDBJavaTypeResolver
extends JavaTypeResolverDefaultImpl {
    protected Map<String, Integer> typeExtMap = new HashMap<String, Integer>();

    public IoTDBJavaTypeResolver() {
        this.typeMap.put(93, new JavaTypeResolverDefaultImpl.JdbcTypeInformation("TIMESTAMP", new FullyQualifiedJavaType(Long.class.getName())));
        this.initTypeSet();
    }

    public FullyQualifiedJavaType calculateJavaType(IntrospectedColumn introspectedColumn) {
        for (String jdbcType : this.typeExtMap.keySet()) {
            String value = this.properties.getProperty(jdbcType);
            if (!IoTDBJavaTypeResolver.hasText(value)) continue;
            this.typeMap.put(this.typeExtMap.get(jdbcType), new JavaTypeResolverDefaultImpl.JdbcTypeInformation(jdbcType.substring(jdbcType.indexOf(".") + 1), new FullyQualifiedJavaType(value)));
        }
        return super.calculateJavaType(introspectedColumn);
    }

    private void initTypeSet() {
        this.typeExtMap.put("jdbcType.ARRAY", 2003);
        this.typeExtMap.put("jdbcType.BIGINT", -5);
        this.typeExtMap.put("jdbcType.BINARY", -2);
        this.typeExtMap.put("jdbcType.BIT", -7);
        this.typeExtMap.put("jdbcType.BLOB", 2004);
        this.typeExtMap.put("jdbcType.BOOLEAN", 16);
        this.typeExtMap.put("jdbcType.CHAR", 1);
        this.typeExtMap.put("jdbcType.CLOB", 2005);
        this.typeExtMap.put("jdbcType.DATALINK", 70);
        this.typeExtMap.put("jdbcType.DATE", 91);
        this.typeExtMap.put("jdbcType.DECIMAL", 3);
        this.typeExtMap.put("jdbcType.DISTINCT", 2001);
        this.typeExtMap.put("jdbcType.DOUBLE", 8);
        this.typeExtMap.put("jdbcType.FLOAT", 6);
        this.typeExtMap.put("jdbcType.INTEGER", 4);
        this.typeExtMap.put("jdbcType.JAVA_OBJECT", 2000);
        this.typeExtMap.put("jdbcType.LONGNVARCHAR", -16);
        this.typeExtMap.put("jdbcType.LONGVARBINARY", -4);
        this.typeExtMap.put("jdbcType.LONGVARCHAR", -1);
        this.typeExtMap.put("jdbcType.NCHAR", -15);
        this.typeExtMap.put("jdbcType.NCLOB", 2011);
        this.typeExtMap.put("jdbcType.NVARCHAR", -9);
        this.typeExtMap.put("jdbcType.NULL", 0);
        this.typeExtMap.put("jdbcType.NUMERIC", 2);
        this.typeExtMap.put("jdbcType.OTHER", 1111);
        this.typeExtMap.put("jdbcType.REAL", 7);
        this.typeExtMap.put("jdbcType.REF", 2006);
        this.typeExtMap.put("jdbcType.SMALLINT", 5);
        this.typeExtMap.put("jdbcType.STRUCT", 2002);
        this.typeExtMap.put("jdbcType.TIME", 92);
        this.typeExtMap.put("jdbcType.TIMESTAMP", 93);
        this.typeExtMap.put("jdbcType.TINYINT", -6);
        this.typeExtMap.put("jdbcType.VARBINARY", -3);
        this.typeExtMap.put("jdbcType.VARCHAR", 12);
    }

    public static boolean hasText(String text) {
        return text != null && text.trim().length() > 0;
    }
}

