/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.page;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.iotdb.tsfile.compress.ICompressor;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.statistics.TimeStatistics;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimePageWriter {
    private static final Logger logger = LoggerFactory.getLogger(TimePageWriter.class);
    private final ICompressor compressor;
    private Encoder timeEncoder;
    private final PublicBAOS timeOut = new PublicBAOS();
    private TimeStatistics statistics;

    public TimePageWriter(Encoder timeEncoder, ICompressor compressor) {
        this.timeEncoder = timeEncoder;
        this.statistics = new TimeStatistics();
        this.compressor = compressor;
    }

    public void write(long time) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.statistics.update(time);
    }

    public void write(long[] timestamps, int batchSize, int arrayOffset) {
        for (int i = arrayOffset; i < batchSize + arrayOffset; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
        }
        this.statistics.update(timestamps, batchSize, arrayOffset);
    }

    private void prepareEndWriteOnePage() throws IOException {
        this.timeEncoder.flush(this.timeOut);
    }

    public ByteBuffer getUncompressedBytes() throws IOException {
        this.prepareEndWriteOnePage();
        ByteBuffer buffer = ByteBuffer.allocate(this.timeOut.size());
        buffer.put(this.timeOut.getBuf(), 0, this.timeOut.size());
        buffer.flip();
        return buffer;
    }

    public int writePageHeaderAndDataIntoBuff(PublicBAOS pageBuffer, boolean first) throws IOException {
        int compressedSize;
        if (this.statistics.getCount() == 0L) {
            return 0;
        }
        ByteBuffer pageData = this.getUncompressedBytes();
        int uncompressedSize = pageData.remaining();
        byte[] compressedBytes = null;
        if (this.compressor.getType().equals((Object)CompressionType.UNCOMPRESSED)) {
            compressedSize = uncompressedSize;
        } else if (this.compressor.getType().equals((Object)CompressionType.GZIP)) {
            compressedBytes = this.compressor.compress(pageData.array(), pageData.position(), uncompressedSize);
            compressedSize = compressedBytes.length;
        } else {
            compressedBytes = new byte[this.compressor.getMaxBytesForCompression(uncompressedSize)];
            compressedSize = this.compressor.compress(pageData.array(), pageData.position(), uncompressedSize, compressedBytes);
        }
        int sizeWithoutStatistic = 0;
        if (first) {
            sizeWithoutStatistic += ReadWriteForEncodingUtils.writeUnsignedVarInt(uncompressedSize, pageBuffer);
            sizeWithoutStatistic += ReadWriteForEncodingUtils.writeUnsignedVarInt(compressedSize, pageBuffer);
        } else {
            ReadWriteForEncodingUtils.writeUnsignedVarInt(uncompressedSize, pageBuffer);
            ReadWriteForEncodingUtils.writeUnsignedVarInt(compressedSize, pageBuffer);
            this.statistics.serialize(pageBuffer);
        }
        logger.trace("start to flush a time page data into buffer, buffer position {} ", (Object)pageBuffer.size());
        if (this.compressor.getType().equals((Object)CompressionType.UNCOMPRESSED)) {
            try (WritableByteChannel channel = Channels.newChannel(pageBuffer);){
                channel.write(pageData);
            }
        } else {
            pageBuffer.write(compressedBytes, 0, compressedSize);
        }
        logger.trace("finish flushing a time page data into buffer, buffer position {} ", (Object)pageBuffer.size());
        return sizeWithoutStatistic;
    }

    public long estimateMaxMemSize() {
        return (long)this.timeOut.size() + this.timeEncoder.getMaxByteSize();
    }

    public void reset() {
        this.timeOut.reset();
        this.statistics = new TimeStatistics();
    }

    public void setTimeEncoder(Encoder encoder) {
        this.timeEncoder = encoder;
    }

    public void initStatistics() {
        this.statistics = new TimeStatistics();
    }

    public long getPointNumber() {
        return this.statistics.getCount();
    }

    public TimeStatistics getStatistics() {
        return this.statistics;
    }
}

