/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.tsfile.encoding.encoder.DictionaryEncoder;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongZigzagEncoder
extends Encoder {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryEncoder.class);
    private List<Long> values;
    byte[] buf = new byte[10];

    public LongZigzagEncoder() {
        super(TSEncoding.ZIGZAG);
        this.values = new ArrayList<Long>();
        logger.debug("tsfile-encoding LongZigzagEncoder: long zigzag encoder");
    }

    private byte[] encodeLong(long n) {
        n = n << 1 ^ n >> 63;
        int idx = 0;
        if ((n & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.buf[idx++] = (byte)((n | 0x80L) & 0xFFL);
            n >>>= 7;
            while (n > 127L) {
                this.buf[idx++] = (byte)((n | 0x80L) & 0xFFL);
                n >>>= 7;
            }
        }
        this.buf[idx++] = (byte)n;
        return Arrays.copyOfRange(this.buf, 0, idx);
    }

    public static String print(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (byte b : bytes) {
            sb.append(String.format("0x%02X ", b));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void encode(long value, ByteArrayOutputStream out) {
        this.values.add(value);
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        ByteArrayOutputStream byteCache = new ByteArrayOutputStream();
        int len = this.values.size();
        if (this.values.size() == 0) {
            return;
        }
        for (long value : this.values) {
            byte[] bytes = this.encodeLong(value);
            byteCache.write(bytes, 0, bytes.length);
        }
        ReadWriteForEncodingUtils.writeUnsignedVarInt(byteCache.size(), out);
        ReadWriteForEncodingUtils.writeUnsignedVarInt(len, out);
        out.write(byteCache.toByteArray());
        this.reset();
    }

    private void reset() {
        this.values.clear();
    }

    @Override
    public long getMaxByteSize() {
        if (this.values == null) {
            return 0L;
        }
        return 8L + (long)(this.values.size() * 4);
    }
}

