/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.util.HashMap;
import java.util.Map;

public enum TSStatusCode {
    SUCCESS_STATUS(200),
    STILL_EXECUTING_STATUS(201),
    INVALID_HANDLE_STATUS(202),
    INCOMPATIBLE_VERSION(203),
    NODE_DELETE_FAILED_ERROR(298),
    ALIAS_ALREADY_EXIST_ERROR(299),
    PATH_ALREADY_EXIST_ERROR(300),
    PATH_NOT_EXIST_ERROR(301),
    UNSUPPORTED_FETCH_METADATA_OPERATION_ERROR(302),
    METADATA_ERROR(303),
    TIMESERIES_NOT_EXIST(304),
    OUT_OF_TTL_ERROR(305),
    CONFIG_ADJUSTER(306),
    MERGE_ERROR(307),
    SYSTEM_CHECK_ERROR(308),
    SYNC_CONNECTION_EXCEPTION(310),
    DATA_REGION_ERROR(311),
    STORAGE_GROUP_ERROR(312),
    STORAGE_ENGINE_ERROR(313),
    TSFILE_PROCESSOR_ERROR(314),
    PATH_ILLEGAL(315),
    LOAD_FILE_ERROR(316),
    STORAGE_GROUP_NOT_READY(317),
    ILLEGAL_PARAMETER(318),
    ALIGNED_TIMESERIES_ERROR(319),
    DUPLICATED_TEMPLATE(320),
    UNDEFINED_TEMPLATE(321),
    STORAGE_GROUP_NOT_EXIST(322),
    CONTINUOUS_QUERY_ERROR(323),
    NO_TEMPLATE_ON_MNODE(324),
    DIFFERENT_TEMPLATE(325),
    TEMPLATE_IS_IN_USE(326),
    TEMPLATE_IMCOMPATIBLE(327),
    SEGMENT_NOT_FOUND(328),
    PAGE_OUT_OF_SPACE(329),
    RECORD_DUPLICATED(330),
    SEGMENT_OUT_OF_SPACE(331),
    SCHEMA_FILE_NOT_EXISTS(332),
    WRITE_AHEAD_LOG_ERROR(333),
    PIPESINK_ERROR(334),
    PIPE_ERROR(335),
    PIPESERVER_ERROR(336),
    SERIES_OVERFLOW(337),
    MEASUREMENT_ALREADY_EXIST(338),
    TEMPLATE_NOT_EXIST(339),
    CREATE_TEMPLATE_ERROR(340),
    SYNC_FILE_REBASE(341),
    SYNC_FILE_ERROR(342),
    VERIFY_METADATA_ERROR(343),
    MEASUREMENT_IN_BLACK_LIST(344),
    COLOSSAL_RECORD(349),
    TRIGGER_LOAD_CLASS(360),
    TRIGGER_DOWNLOAD_ERROR(361),
    CREATE_TRIGGER_INSTANCE_ERROR(362),
    ACTIVE_TRIGGER_INSTANCE_ERROR(363),
    DROP_TRIGGER_INSTANCE_ERROR(364),
    EXECUTE_STATEMENT_ERROR(400),
    SQL_PARSE_ERROR(401),
    GENERATE_TIME_ZONE_ERROR(402),
    SET_TIME_ZONE_ERROR(403),
    NOT_STORAGE_GROUP_ERROR(404),
    QUERY_NOT_ALLOWED(405),
    AST_FORMAT_ERROR(406),
    LOGICAL_OPERATOR_ERROR(407),
    LOGICAL_OPTIMIZE_ERROR(408),
    UNSUPPORTED_FILL_TYPE_ERROR(409),
    PATH_ERROR(410),
    QUERY_PROCESS_ERROR(411),
    WRITE_PROCESS_ERROR(412),
    WRITE_PROCESS_REJECT(413),
    QUERY_ID_NOT_EXIST(414),
    SNAPSHOT_DIR_NOT_LEGAL(415),
    SEMANTIC_ERROR(416),
    TSFILE_RUNTIME_ERROR(417),
    UNSUPPORTED_INDEX_FUNC_ERROR(421),
    UNSUPPORTED_INDEX_TYPE_ERROR(422),
    MEMORY_NOT_ENOUGH(423),
    INTERNAL_SERVER_ERROR(500),
    CLOSE_OPERATION_ERROR(501),
    READ_ONLY_SYSTEM_ERROR(502),
    DISK_SPACE_INSUFFICIENT_ERROR(503),
    START_UP_ERROR(504),
    SHUT_DOWN_ERROR(505),
    MULTIPLE_ERROR(506),
    SESSION_EXPIRED(507),
    WRONG_LOGIN_PASSWORD_ERROR(600),
    NOT_LOGIN_ERROR(601),
    NO_PERMISSION_ERROR(602),
    UNINITIALIZED_AUTH_ERROR(603),
    EXECUTE_PERMISSION_EXCEPTION_ERROR(604),
    USER_NOT_EXIST_ERROR(605),
    ROLE_NOT_EXIST_ERROR(606),
    AUTHENTICATION_ERROR(607),
    INVALIDATE_PERMISSION_CACHE_ERROR(608),
    PARTITION_NOT_READY(700),
    TIME_OUT(701),
    NO_LEADER(702),
    UNSUPPORTED_OPERATION(703),
    NODE_READ_ONLY(704),
    CONSISTENCY_FAILURE(705),
    NO_CONNECTION(706),
    NEED_REDIRECTION(707),
    PARSE_LOG_ERROR(708),
    ALL_RETRY_FAILED(709),
    MIGRATE_REGION_ERROR(710),
    CREATE_REGION_ERROR(711),
    DELETE_REGION_ERROR(712),
    CACHE_UPDATE_FAIL(713),
    NODE_DESERIALIZE_ERROR(714),
    CONFIG_ERROR(800),
    DATANODE_ALREADY_REGISTERED(901),
    SET_STORAGE_GROUP_FAILED(902),
    STORAGE_GROUP_ALREADY_EXISTS(903),
    NOT_ENOUGH_DATA_NODE(904),
    ERROR_GLOBAL_CONFIG(905),
    APPLY_CONFIGNODE_FAILED(906),
    REGISTER_CONFIGNODE_FAILED(907),
    REMOVE_CONFIGNODE_FAILED(908),
    REMOVE_CONFIGNODE_DUPLICATION(909),
    STOP_CONOFIGNODE_FAILED(910),
    PERSISTENCE_FAILURE(911),
    DATANODE_NOT_EXIST(912),
    DUPLICATE_REMOVE(913),
    REQUEST_SIZE_EXCEED(914),
    REGION_MIGRATE_FAILED(915),
    LACK_REPLICATION(916),
    DATANODE_STOP_ERROR(917),
    REGION_LEADER_CHANGE_FAILED(918),
    REMOVE_DATANODE_FAILED(919),
    OVERLAP_WITH_EXISTING_DELETE_TIMESERIES_TASK(920),
    NOT_AVAILABLE_REGION_GROUP(921),
    CREATE_TRIGGER_ERROR(922),
    DROP_TRIGGER_ERROR(923);

    private int statusCode;
    private static final Map<Integer, TSStatusCode> CODE_MAP;

    private TSStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static TSStatusCode representOf(int statusCode) {
        return CODE_MAP.get(statusCode);
    }

    public String toString() {
        return String.format("%s(%d)", this.name(), this.getStatusCode());
    }

    static {
        CODE_MAP = new HashMap<Integer, TSStatusCode>();
        for (TSStatusCode value : TSStatusCode.values()) {
            CODE_MAP.put(value.getStatusCode(), value);
        }
    }
}

