/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.reporter;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeReporter.class);
    private List<Reporter> reporters = new ArrayList<Reporter>();

    public boolean startAll() {
        boolean result = true;
        for (Reporter reporter : this.reporters) {
            if (reporter.start()) continue;
            LOGGER.warn("Failed to init {} reporter.", (Object)reporter.getReporterType());
            result = false;
        }
        return result;
    }

    public boolean start(ReporterType reporterType) {
        for (Reporter reporter : this.reporters) {
            if (reporter.getReporterType() != reporterType) continue;
            return reporter.start();
        }
        LOGGER.error("Failed to find {} reporter.", (Object)reporterType);
        return false;
    }

    public boolean stopAll() {
        boolean result = true;
        for (Reporter reporter : this.reporters) {
            if (reporter.stop()) continue;
            LOGGER.error("Failed to stop {} reporter.", (Object)reporter.getReporterType());
            result = false;
        }
        return result;
    }

    public boolean stop(ReporterType reporterType) {
        for (Reporter reporter : this.reporters) {
            if (reporter.getReporterType() != reporterType) continue;
            return reporter.stop();
        }
        LOGGER.error("Failed to stop reporter: {}", (Object)reporterType.name());
        return true;
    }

    public boolean restartAll() {
        LOGGER.info("Restart all reporter.");
        return this.stopAll() & this.startAll();
    }

    public void addReporter(Reporter reporter) {
        this.reporters.add(reporter);
    }
}

