/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.kafka;

import java.util.Properties;
import org.apache.iotdb.kafka.Constant;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Producer {
    private final KafkaProducer<String, String> producer;
    private static final Logger logger = LoggerFactory.getLogger(Producer.class);

    public Producer() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "127.0.0.1:9092");
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        this.producer = new KafkaProducer(props);
    }

    public static void main(String[] args) {
        Producer producer = new Producer();
        producer.produce();
        producer.close();
    }

    private void produce() {
        for (int i = 0; i < Constant.ALL_DATA.length; ++i) {
            String key = Integer.toString(i);
            this.producer.send(new ProducerRecord("Kafka-Test", (Object)key, (Object)Constant.ALL_DATA[i]));
            logger.info(Constant.ALL_DATA[i]);
        }
    }

    public void close() {
        this.producer.close();
    }
}

