/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.kafka;

import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.iotdb.kafka.Constant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducer {
    private final Producer<String, String> producer;
    private static final Logger logger = LoggerFactory.getLogger(KafkaProducer.class);

    public KafkaProducer() {
        Properties props = new Properties();
        props.put("metadata.broker.list", "127.0.0.1:9092");
        props.put("zk.connect", "127.0.0.1:2181");
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("key.serializer.class", "kafka.serializer.StringEncoder");
        props.put("request.required.acks", "-1");
        this.producer = new Producer(new ProducerConfig(props));
    }

    public static void main(String[] args) {
        KafkaProducer kafkaProducer = new KafkaProducer();
        kafkaProducer.produce();
        kafkaProducer.close();
    }

    private void produce() {
        for (int i = 0; i < Constant.ALL_DATA.length; ++i) {
            String key = Integer.toString(i);
            this.producer.send(new KeyedMessage("Kafka-Test", (Object)key, (Object)Constant.ALL_DATA[i]));
            logger.info(Constant.ALL_DATA[i]);
        }
    }

    public void close() {
        this.producer.close();
    }
}

