// Autogenerated by Thrift Compiler (0.13.0)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"rpc"
	"cluster"
)

var _ = rpc.GoUnusedProtection__
var _ = cluster.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  AddNodeResponse addNode(Node node, StartUpStatus startUpStatus)")
  fmt.Fprintln(os.Stderr, "  CheckStatusResponse checkStatus(StartUpStatus startUpStatus)")
  fmt.Fprintln(os.Stderr, "  long removeNode(Node node)")
  fmt.Fprintln(os.Stderr, "  void exile()")
  fmt.Fprintln(os.Stderr, "  TNodeStatus queryNodeStatus()")
  fmt.Fprintln(os.Stderr, "  Node checkAlive()")
  fmt.Fprintln(os.Stderr, "  void handshake(Node sender)")
  fmt.Fprintln(os.Stderr, "  HeartBeatResponse sendHeartbeat(HeartBeatRequest request)")
  fmt.Fprintln(os.Stderr, "  long startElection(ElectionRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntries(AppendEntriesRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntry(AppendEntryRequest request)")
  fmt.Fprintln(os.Stderr, "  void sendSnapshot(SendSnapshotRequest request)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeNonQueryPlan(ExecutNonQueryReq request)")
  fmt.Fprintln(os.Stderr, "  long requestCommitIndex(Node header)")
  fmt.Fprintln(os.Stderr, "  string readFile(string filePath, long offset, int length)")
  fmt.Fprintln(os.Stderr, "  bool matchTerm(long index, long term, Node header)")
  fmt.Fprintln(os.Stderr, "  void removeHardLink(string hardLinkPath)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := cluster.NewTSMetaServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "addNode":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "AddNode requires 2 args")
      flag.Usage()
    }
    arg460 := flag.Arg(1)
    mbTrans461 := thrift.NewTMemoryBufferLen(len(arg460))
    defer mbTrans461.Close()
    _, err462 := mbTrans461.WriteString(arg460)
    if err462 != nil {
      Usage()
      return
    }
    factory463 := thrift.NewTJSONProtocolFactory()
    jsProt464 := factory463.GetProtocol(mbTrans461)
    argvalue0 := cluster.NewNode()
    err465 := argvalue0.Read(jsProt464)
    if err465 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg466 := flag.Arg(2)
    mbTrans467 := thrift.NewTMemoryBufferLen(len(arg466))
    defer mbTrans467.Close()
    _, err468 := mbTrans467.WriteString(arg466)
    if err468 != nil {
      Usage()
      return
    }
    factory469 := thrift.NewTJSONProtocolFactory()
    jsProt470 := factory469.GetProtocol(mbTrans467)
    argvalue1 := cluster.NewStartUpStatus()
    err471 := argvalue1.Read(jsProt470)
    if err471 != nil {
      Usage()
      return
    }
    value1 := argvalue1
    fmt.Print(client.AddNode(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "checkStatus":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CheckStatus requires 1 args")
      flag.Usage()
    }
    arg472 := flag.Arg(1)
    mbTrans473 := thrift.NewTMemoryBufferLen(len(arg472))
    defer mbTrans473.Close()
    _, err474 := mbTrans473.WriteString(arg472)
    if err474 != nil {
      Usage()
      return
    }
    factory475 := thrift.NewTJSONProtocolFactory()
    jsProt476 := factory475.GetProtocol(mbTrans473)
    argvalue0 := cluster.NewStartUpStatus()
    err477 := argvalue0.Read(jsProt476)
    if err477 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CheckStatus(context.Background(), value0))
    fmt.Print("\n")
    break
  case "removeNode":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RemoveNode requires 1 args")
      flag.Usage()
    }
    arg478 := flag.Arg(1)
    mbTrans479 := thrift.NewTMemoryBufferLen(len(arg478))
    defer mbTrans479.Close()
    _, err480 := mbTrans479.WriteString(arg478)
    if err480 != nil {
      Usage()
      return
    }
    factory481 := thrift.NewTJSONProtocolFactory()
    jsProt482 := factory481.GetProtocol(mbTrans479)
    argvalue0 := cluster.NewNode()
    err483 := argvalue0.Read(jsProt482)
    if err483 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RemoveNode(context.Background(), value0))
    fmt.Print("\n")
    break
  case "exile":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "Exile requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.Exile(context.Background()))
    fmt.Print("\n")
    break
  case "queryNodeStatus":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "QueryNodeStatus requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.QueryNodeStatus(context.Background()))
    fmt.Print("\n")
    break
  case "checkAlive":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "CheckAlive requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.CheckAlive(context.Background()))
    fmt.Print("\n")
    break
  case "handshake":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Handshake requires 1 args")
      flag.Usage()
    }
    arg484 := flag.Arg(1)
    mbTrans485 := thrift.NewTMemoryBufferLen(len(arg484))
    defer mbTrans485.Close()
    _, err486 := mbTrans485.WriteString(arg484)
    if err486 != nil {
      Usage()
      return
    }
    factory487 := thrift.NewTJSONProtocolFactory()
    jsProt488 := factory487.GetProtocol(mbTrans485)
    argvalue0 := cluster.NewNode()
    err489 := argvalue0.Read(jsProt488)
    if err489 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.Handshake(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendHeartbeat":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendHeartbeat requires 1 args")
      flag.Usage()
    }
    arg490 := flag.Arg(1)
    mbTrans491 := thrift.NewTMemoryBufferLen(len(arg490))
    defer mbTrans491.Close()
    _, err492 := mbTrans491.WriteString(arg490)
    if err492 != nil {
      Usage()
      return
    }
    factory493 := thrift.NewTJSONProtocolFactory()
    jsProt494 := factory493.GetProtocol(mbTrans491)
    argvalue0 := cluster.NewHeartBeatRequest()
    err495 := argvalue0.Read(jsProt494)
    if err495 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendHeartbeat(context.Background(), value0))
    fmt.Print("\n")
    break
  case "startElection":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "StartElection requires 1 args")
      flag.Usage()
    }
    arg496 := flag.Arg(1)
    mbTrans497 := thrift.NewTMemoryBufferLen(len(arg496))
    defer mbTrans497.Close()
    _, err498 := mbTrans497.WriteString(arg496)
    if err498 != nil {
      Usage()
      return
    }
    factory499 := thrift.NewTJSONProtocolFactory()
    jsProt500 := factory499.GetProtocol(mbTrans497)
    argvalue0 := cluster.NewElectionRequest()
    err501 := argvalue0.Read(jsProt500)
    if err501 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.StartElection(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntries requires 1 args")
      flag.Usage()
    }
    arg502 := flag.Arg(1)
    mbTrans503 := thrift.NewTMemoryBufferLen(len(arg502))
    defer mbTrans503.Close()
    _, err504 := mbTrans503.WriteString(arg502)
    if err504 != nil {
      Usage()
      return
    }
    factory505 := thrift.NewTJSONProtocolFactory()
    jsProt506 := factory505.GetProtocol(mbTrans503)
    argvalue0 := cluster.NewAppendEntriesRequest()
    err507 := argvalue0.Read(jsProt506)
    if err507 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntry":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntry requires 1 args")
      flag.Usage()
    }
    arg508 := flag.Arg(1)
    mbTrans509 := thrift.NewTMemoryBufferLen(len(arg508))
    defer mbTrans509.Close()
    _, err510 := mbTrans509.WriteString(arg508)
    if err510 != nil {
      Usage()
      return
    }
    factory511 := thrift.NewTJSONProtocolFactory()
    jsProt512 := factory511.GetProtocol(mbTrans509)
    argvalue0 := cluster.NewAppendEntryRequest()
    err513 := argvalue0.Read(jsProt512)
    if err513 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntry(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendSnapshot":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendSnapshot requires 1 args")
      flag.Usage()
    }
    arg514 := flag.Arg(1)
    mbTrans515 := thrift.NewTMemoryBufferLen(len(arg514))
    defer mbTrans515.Close()
    _, err516 := mbTrans515.WriteString(arg514)
    if err516 != nil {
      Usage()
      return
    }
    factory517 := thrift.NewTJSONProtocolFactory()
    jsProt518 := factory517.GetProtocol(mbTrans515)
    argvalue0 := cluster.NewSendSnapshotRequest()
    err519 := argvalue0.Read(jsProt518)
    if err519 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendSnapshot(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeNonQueryPlan":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteNonQueryPlan requires 1 args")
      flag.Usage()
    }
    arg520 := flag.Arg(1)
    mbTrans521 := thrift.NewTMemoryBufferLen(len(arg520))
    defer mbTrans521.Close()
    _, err522 := mbTrans521.WriteString(arg520)
    if err522 != nil {
      Usage()
      return
    }
    factory523 := thrift.NewTJSONProtocolFactory()
    jsProt524 := factory523.GetProtocol(mbTrans521)
    argvalue0 := cluster.NewExecutNonQueryReq()
    err525 := argvalue0.Read(jsProt524)
    if err525 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteNonQueryPlan(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestCommitIndex":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestCommitIndex requires 1 args")
      flag.Usage()
    }
    arg526 := flag.Arg(1)
    mbTrans527 := thrift.NewTMemoryBufferLen(len(arg526))
    defer mbTrans527.Close()
    _, err528 := mbTrans527.WriteString(arg526)
    if err528 != nil {
      Usage()
      return
    }
    factory529 := thrift.NewTJSONProtocolFactory()
    jsProt530 := factory529.GetProtocol(mbTrans527)
    argvalue0 := cluster.NewNode()
    err531 := argvalue0.Read(jsProt530)
    if err531 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestCommitIndex(context.Background(), value0))
    fmt.Print("\n")
    break
  case "readFile":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "ReadFile requires 3 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    argvalue1, err533 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err533 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    tmp2, err534 := (strconv.Atoi(flag.Arg(3)))
    if err534 != nil {
      Usage()
      return
    }
    argvalue2 := int32(tmp2)
    value2 := cluster.Int(argvalue2)
    fmt.Print(client.ReadFile(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "matchTerm":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "MatchTerm requires 3 args")
      flag.Usage()
    }
    argvalue0, err535 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err535 != nil {
      Usage()
      return
    }
    value0 := cluster.Long(argvalue0)
    argvalue1, err536 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err536 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    arg537 := flag.Arg(3)
    mbTrans538 := thrift.NewTMemoryBufferLen(len(arg537))
    defer mbTrans538.Close()
    _, err539 := mbTrans538.WriteString(arg537)
    if err539 != nil {
      Usage()
      return
    }
    factory540 := thrift.NewTJSONProtocolFactory()
    jsProt541 := factory540.GetProtocol(mbTrans538)
    argvalue2 := cluster.NewNode()
    err542 := argvalue2.Read(jsProt541)
    if err542 != nil {
      Usage()
      return
    }
    value2 := argvalue2
    fmt.Print(client.MatchTerm(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "removeHardLink":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RemoveHardLink requires 1 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    fmt.Print(client.RemoveHardLink(context.Background(), value0))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
