// Autogenerated by Thrift Compiler (0.13.0)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"rpc"
	"cluster"
)

var _ = rpc.GoUnusedProtection__
var _ = cluster.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  long querySingleSeries(SingleSeriesQueryRequest request)")
  fmt.Fprintln(os.Stderr, "  long queryMultSeries(MultSeriesQueryRequest request)")
  fmt.Fprintln(os.Stderr, "  string fetchSingleSeries(Node header, long readerId)")
  fmt.Fprintln(os.Stderr, "   fetchMultSeries(Node header, long readerId,  paths)")
  fmt.Fprintln(os.Stderr, "  long querySingleSeriesByTimestamp(SingleSeriesQueryRequest request)")
  fmt.Fprintln(os.Stderr, "  string fetchSingleSeriesByTimestamps(Node header, long readerId,  timestamps)")
  fmt.Fprintln(os.Stderr, "  void endQuery(Node header, Node thisNode, long queryId)")
  fmt.Fprintln(os.Stderr, "  GetAllPathsResult getAllPaths(Node header,  path, bool withAlias)")
  fmt.Fprintln(os.Stderr, "   getAllDevices(Node header,  path)")
  fmt.Fprintln(os.Stderr, "  string getDevices(Node header, string planBinary)")
  fmt.Fprintln(os.Stderr, "   getNodeList(Node header, string path, int nodeLevel)")
  fmt.Fprintln(os.Stderr, "   getChildNodeInNextLevel(Node header, string path)")
  fmt.Fprintln(os.Stderr, "   getChildNodePathInNextLevel(Node header, string path)")
  fmt.Fprintln(os.Stderr, "  string getAllMeasurementSchema(Node header, string planBinary)")
  fmt.Fprintln(os.Stderr, "   getAggrResult(GetAggrResultRequest request)")
  fmt.Fprintln(os.Stderr, "   getUnregisteredTimeseries(Node header,  timeseriesList)")
  fmt.Fprintln(os.Stderr, "  PullSnapshotResp pullSnapshot(PullSnapshotRequest request)")
  fmt.Fprintln(os.Stderr, "  long getGroupByExecutor(GroupByRequest request)")
  fmt.Fprintln(os.Stderr, "   getGroupByResult(Node header, long executorId, long startTime, long endTime)")
  fmt.Fprintln(os.Stderr, "  PullSchemaResp pullTimeSeriesSchema(PullSchemaRequest request)")
  fmt.Fprintln(os.Stderr, "  PullSchemaResp pullMeasurementSchema(PullSchemaRequest request)")
  fmt.Fprintln(os.Stderr, "  string previousFill(PreviousFillRequest request)")
  fmt.Fprintln(os.Stderr, "  string last(LastQueryRequest request)")
  fmt.Fprintln(os.Stderr, "  int getPathCount(Node header,  pathsToQuery, int level)")
  fmt.Fprintln(os.Stderr, "  bool onSnapshotApplied(Node header,  slots)")
  fmt.Fprintln(os.Stderr, "  string peekNextNotNullValue(Node header, long executorId, long startTime, long endTime)")
  fmt.Fprintln(os.Stderr, "  HeartBeatResponse sendHeartbeat(HeartBeatRequest request)")
  fmt.Fprintln(os.Stderr, "  long startElection(ElectionRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntries(AppendEntriesRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntry(AppendEntryRequest request)")
  fmt.Fprintln(os.Stderr, "  void sendSnapshot(SendSnapshotRequest request)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeNonQueryPlan(ExecutNonQueryReq request)")
  fmt.Fprintln(os.Stderr, "  long requestCommitIndex(Node header)")
  fmt.Fprintln(os.Stderr, "  string readFile(string filePath, long offset, int length)")
  fmt.Fprintln(os.Stderr, "  bool matchTerm(long index, long term, Node header)")
  fmt.Fprintln(os.Stderr, "  void removeHardLink(string hardLinkPath)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := cluster.NewTSDataServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "querySingleSeries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QuerySingleSeries requires 1 args")
      flag.Usage()
    }
    arg169 := flag.Arg(1)
    mbTrans170 := thrift.NewTMemoryBufferLen(len(arg169))
    defer mbTrans170.Close()
    _, err171 := mbTrans170.WriteString(arg169)
    if err171 != nil {
      Usage()
      return
    }
    factory172 := thrift.NewTJSONProtocolFactory()
    jsProt173 := factory172.GetProtocol(mbTrans170)
    argvalue0 := cluster.NewSingleSeriesQueryRequest()
    err174 := argvalue0.Read(jsProt173)
    if err174 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QuerySingleSeries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "queryMultSeries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QueryMultSeries requires 1 args")
      flag.Usage()
    }
    arg175 := flag.Arg(1)
    mbTrans176 := thrift.NewTMemoryBufferLen(len(arg175))
    defer mbTrans176.Close()
    _, err177 := mbTrans176.WriteString(arg175)
    if err177 != nil {
      Usage()
      return
    }
    factory178 := thrift.NewTJSONProtocolFactory()
    jsProt179 := factory178.GetProtocol(mbTrans176)
    argvalue0 := cluster.NewMultSeriesQueryRequest()
    err180 := argvalue0.Read(jsProt179)
    if err180 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QueryMultSeries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchSingleSeries":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "FetchSingleSeries requires 2 args")
      flag.Usage()
    }
    arg181 := flag.Arg(1)
    mbTrans182 := thrift.NewTMemoryBufferLen(len(arg181))
    defer mbTrans182.Close()
    _, err183 := mbTrans182.WriteString(arg181)
    if err183 != nil {
      Usage()
      return
    }
    factory184 := thrift.NewTJSONProtocolFactory()
    jsProt185 := factory184.GetProtocol(mbTrans182)
    argvalue0 := cluster.NewNode()
    err186 := argvalue0.Read(jsProt185)
    if err186 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err187 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err187 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    fmt.Print(client.FetchSingleSeries(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "fetchMultSeries":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "FetchMultSeries requires 3 args")
      flag.Usage()
    }
    arg188 := flag.Arg(1)
    mbTrans189 := thrift.NewTMemoryBufferLen(len(arg188))
    defer mbTrans189.Close()
    _, err190 := mbTrans189.WriteString(arg188)
    if err190 != nil {
      Usage()
      return
    }
    factory191 := thrift.NewTJSONProtocolFactory()
    jsProt192 := factory191.GetProtocol(mbTrans189)
    argvalue0 := cluster.NewNode()
    err193 := argvalue0.Read(jsProt192)
    if err193 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err194 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err194 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    arg195 := flag.Arg(3)
    mbTrans196 := thrift.NewTMemoryBufferLen(len(arg195))
    defer mbTrans196.Close()
    _, err197 := mbTrans196.WriteString(arg195)
    if err197 != nil { 
      Usage()
      return
    }
    factory198 := thrift.NewTJSONProtocolFactory()
    jsProt199 := factory198.GetProtocol(mbTrans196)
    containerStruct2 := cluster.NewTSDataServiceFetchMultSeriesArgs()
    err200 := containerStruct2.ReadField3(jsProt199)
    if err200 != nil {
      Usage()
      return
    }
    argvalue2 := containerStruct2.Paths
    value2 := argvalue2
    fmt.Print(client.FetchMultSeries(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "querySingleSeriesByTimestamp":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QuerySingleSeriesByTimestamp requires 1 args")
      flag.Usage()
    }
    arg201 := flag.Arg(1)
    mbTrans202 := thrift.NewTMemoryBufferLen(len(arg201))
    defer mbTrans202.Close()
    _, err203 := mbTrans202.WriteString(arg201)
    if err203 != nil {
      Usage()
      return
    }
    factory204 := thrift.NewTJSONProtocolFactory()
    jsProt205 := factory204.GetProtocol(mbTrans202)
    argvalue0 := cluster.NewSingleSeriesQueryRequest()
    err206 := argvalue0.Read(jsProt205)
    if err206 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QuerySingleSeriesByTimestamp(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchSingleSeriesByTimestamps":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "FetchSingleSeriesByTimestamps requires 3 args")
      flag.Usage()
    }
    arg207 := flag.Arg(1)
    mbTrans208 := thrift.NewTMemoryBufferLen(len(arg207))
    defer mbTrans208.Close()
    _, err209 := mbTrans208.WriteString(arg207)
    if err209 != nil {
      Usage()
      return
    }
    factory210 := thrift.NewTJSONProtocolFactory()
    jsProt211 := factory210.GetProtocol(mbTrans208)
    argvalue0 := cluster.NewNode()
    err212 := argvalue0.Read(jsProt211)
    if err212 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err213 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err213 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    arg214 := flag.Arg(3)
    mbTrans215 := thrift.NewTMemoryBufferLen(len(arg214))
    defer mbTrans215.Close()
    _, err216 := mbTrans215.WriteString(arg214)
    if err216 != nil { 
      Usage()
      return
    }
    factory217 := thrift.NewTJSONProtocolFactory()
    jsProt218 := factory217.GetProtocol(mbTrans215)
    containerStruct2 := cluster.NewTSDataServiceFetchSingleSeriesByTimestampsArgs()
    err219 := containerStruct2.ReadField3(jsProt218)
    if err219 != nil {
      Usage()
      return
    }
    argvalue2 := containerStruct2.Timestamps
    value2 := argvalue2
    fmt.Print(client.FetchSingleSeriesByTimestamps(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "endQuery":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "EndQuery requires 3 args")
      flag.Usage()
    }
    arg220 := flag.Arg(1)
    mbTrans221 := thrift.NewTMemoryBufferLen(len(arg220))
    defer mbTrans221.Close()
    _, err222 := mbTrans221.WriteString(arg220)
    if err222 != nil {
      Usage()
      return
    }
    factory223 := thrift.NewTJSONProtocolFactory()
    jsProt224 := factory223.GetProtocol(mbTrans221)
    argvalue0 := cluster.NewNode()
    err225 := argvalue0.Read(jsProt224)
    if err225 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg226 := flag.Arg(2)
    mbTrans227 := thrift.NewTMemoryBufferLen(len(arg226))
    defer mbTrans227.Close()
    _, err228 := mbTrans227.WriteString(arg226)
    if err228 != nil {
      Usage()
      return
    }
    factory229 := thrift.NewTJSONProtocolFactory()
    jsProt230 := factory229.GetProtocol(mbTrans227)
    argvalue1 := cluster.NewNode()
    err231 := argvalue1.Read(jsProt230)
    if err231 != nil {
      Usage()
      return
    }
    value1 := argvalue1
    argvalue2, err232 := (strconv.ParseInt(flag.Arg(3), 10, 64))
    if err232 != nil {
      Usage()
      return
    }
    value2 := cluster.Long(argvalue2)
    fmt.Print(client.EndQuery(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "getAllPaths":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "GetAllPaths requires 3 args")
      flag.Usage()
    }
    arg233 := flag.Arg(1)
    mbTrans234 := thrift.NewTMemoryBufferLen(len(arg233))
    defer mbTrans234.Close()
    _, err235 := mbTrans234.WriteString(arg233)
    if err235 != nil {
      Usage()
      return
    }
    factory236 := thrift.NewTJSONProtocolFactory()
    jsProt237 := factory236.GetProtocol(mbTrans234)
    argvalue0 := cluster.NewNode()
    err238 := argvalue0.Read(jsProt237)
    if err238 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg239 := flag.Arg(2)
    mbTrans240 := thrift.NewTMemoryBufferLen(len(arg239))
    defer mbTrans240.Close()
    _, err241 := mbTrans240.WriteString(arg239)
    if err241 != nil { 
      Usage()
      return
    }
    factory242 := thrift.NewTJSONProtocolFactory()
    jsProt243 := factory242.GetProtocol(mbTrans240)
    containerStruct1 := cluster.NewTSDataServiceGetAllPathsArgs()
    err244 := containerStruct1.ReadField2(jsProt243)
    if err244 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Path
    value1 := argvalue1
    argvalue2 := flag.Arg(3) == "true"
    value2 := argvalue2
    fmt.Print(client.GetAllPaths(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "getAllDevices":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetAllDevices requires 2 args")
      flag.Usage()
    }
    arg246 := flag.Arg(1)
    mbTrans247 := thrift.NewTMemoryBufferLen(len(arg246))
    defer mbTrans247.Close()
    _, err248 := mbTrans247.WriteString(arg246)
    if err248 != nil {
      Usage()
      return
    }
    factory249 := thrift.NewTJSONProtocolFactory()
    jsProt250 := factory249.GetProtocol(mbTrans247)
    argvalue0 := cluster.NewNode()
    err251 := argvalue0.Read(jsProt250)
    if err251 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg252 := flag.Arg(2)
    mbTrans253 := thrift.NewTMemoryBufferLen(len(arg252))
    defer mbTrans253.Close()
    _, err254 := mbTrans253.WriteString(arg252)
    if err254 != nil { 
      Usage()
      return
    }
    factory255 := thrift.NewTJSONProtocolFactory()
    jsProt256 := factory255.GetProtocol(mbTrans253)
    containerStruct1 := cluster.NewTSDataServiceGetAllDevicesArgs()
    err257 := containerStruct1.ReadField2(jsProt256)
    if err257 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Path
    value1 := argvalue1
    fmt.Print(client.GetAllDevices(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "getDevices":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetDevices requires 2 args")
      flag.Usage()
    }
    arg258 := flag.Arg(1)
    mbTrans259 := thrift.NewTMemoryBufferLen(len(arg258))
    defer mbTrans259.Close()
    _, err260 := mbTrans259.WriteString(arg258)
    if err260 != nil {
      Usage()
      return
    }
    factory261 := thrift.NewTJSONProtocolFactory()
    jsProt262 := factory261.GetProtocol(mbTrans259)
    argvalue0 := cluster.NewNode()
    err263 := argvalue0.Read(jsProt262)
    if err263 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := []byte(flag.Arg(2))
    value1 := argvalue1
    fmt.Print(client.GetDevices(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "getNodeList":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "GetNodeList requires 3 args")
      flag.Usage()
    }
    arg265 := flag.Arg(1)
    mbTrans266 := thrift.NewTMemoryBufferLen(len(arg265))
    defer mbTrans266.Close()
    _, err267 := mbTrans266.WriteString(arg265)
    if err267 != nil {
      Usage()
      return
    }
    factory268 := thrift.NewTJSONProtocolFactory()
    jsProt269 := factory268.GetProtocol(mbTrans266)
    argvalue0 := cluster.NewNode()
    err270 := argvalue0.Read(jsProt269)
    if err270 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    tmp2, err272 := (strconv.Atoi(flag.Arg(3)))
    if err272 != nil {
      Usage()
      return
    }
    argvalue2 := int32(tmp2)
    value2 := cluster.Int(argvalue2)
    fmt.Print(client.GetNodeList(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "getChildNodeInNextLevel":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetChildNodeInNextLevel requires 2 args")
      flag.Usage()
    }
    arg273 := flag.Arg(1)
    mbTrans274 := thrift.NewTMemoryBufferLen(len(arg273))
    defer mbTrans274.Close()
    _, err275 := mbTrans274.WriteString(arg273)
    if err275 != nil {
      Usage()
      return
    }
    factory276 := thrift.NewTJSONProtocolFactory()
    jsProt277 := factory276.GetProtocol(mbTrans274)
    argvalue0 := cluster.NewNode()
    err278 := argvalue0.Read(jsProt277)
    if err278 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    fmt.Print(client.GetChildNodeInNextLevel(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "getChildNodePathInNextLevel":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetChildNodePathInNextLevel requires 2 args")
      flag.Usage()
    }
    arg280 := flag.Arg(1)
    mbTrans281 := thrift.NewTMemoryBufferLen(len(arg280))
    defer mbTrans281.Close()
    _, err282 := mbTrans281.WriteString(arg280)
    if err282 != nil {
      Usage()
      return
    }
    factory283 := thrift.NewTJSONProtocolFactory()
    jsProt284 := factory283.GetProtocol(mbTrans281)
    argvalue0 := cluster.NewNode()
    err285 := argvalue0.Read(jsProt284)
    if err285 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    fmt.Print(client.GetChildNodePathInNextLevel(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "getAllMeasurementSchema":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetAllMeasurementSchema requires 2 args")
      flag.Usage()
    }
    arg287 := flag.Arg(1)
    mbTrans288 := thrift.NewTMemoryBufferLen(len(arg287))
    defer mbTrans288.Close()
    _, err289 := mbTrans288.WriteString(arg287)
    if err289 != nil {
      Usage()
      return
    }
    factory290 := thrift.NewTJSONProtocolFactory()
    jsProt291 := factory290.GetProtocol(mbTrans288)
    argvalue0 := cluster.NewNode()
    err292 := argvalue0.Read(jsProt291)
    if err292 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := []byte(flag.Arg(2))
    value1 := argvalue1
    fmt.Print(client.GetAllMeasurementSchema(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "getAggrResult":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetAggrResult_ requires 1 args")
      flag.Usage()
    }
    arg294 := flag.Arg(1)
    mbTrans295 := thrift.NewTMemoryBufferLen(len(arg294))
    defer mbTrans295.Close()
    _, err296 := mbTrans295.WriteString(arg294)
    if err296 != nil {
      Usage()
      return
    }
    factory297 := thrift.NewTJSONProtocolFactory()
    jsProt298 := factory297.GetProtocol(mbTrans295)
    argvalue0 := cluster.NewGetAggrResultRequest()
    err299 := argvalue0.Read(jsProt298)
    if err299 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetAggrResult_(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getUnregisteredTimeseries":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "GetUnregisteredTimeseries requires 2 args")
      flag.Usage()
    }
    arg300 := flag.Arg(1)
    mbTrans301 := thrift.NewTMemoryBufferLen(len(arg300))
    defer mbTrans301.Close()
    _, err302 := mbTrans301.WriteString(arg300)
    if err302 != nil {
      Usage()
      return
    }
    factory303 := thrift.NewTJSONProtocolFactory()
    jsProt304 := factory303.GetProtocol(mbTrans301)
    argvalue0 := cluster.NewNode()
    err305 := argvalue0.Read(jsProt304)
    if err305 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg306 := flag.Arg(2)
    mbTrans307 := thrift.NewTMemoryBufferLen(len(arg306))
    defer mbTrans307.Close()
    _, err308 := mbTrans307.WriteString(arg306)
    if err308 != nil { 
      Usage()
      return
    }
    factory309 := thrift.NewTJSONProtocolFactory()
    jsProt310 := factory309.GetProtocol(mbTrans307)
    containerStruct1 := cluster.NewTSDataServiceGetUnregisteredTimeseriesArgs()
    err311 := containerStruct1.ReadField2(jsProt310)
    if err311 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.TimeseriesList
    value1 := argvalue1
    fmt.Print(client.GetUnregisteredTimeseries(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "pullSnapshot":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PullSnapshot requires 1 args")
      flag.Usage()
    }
    arg312 := flag.Arg(1)
    mbTrans313 := thrift.NewTMemoryBufferLen(len(arg312))
    defer mbTrans313.Close()
    _, err314 := mbTrans313.WriteString(arg312)
    if err314 != nil {
      Usage()
      return
    }
    factory315 := thrift.NewTJSONProtocolFactory()
    jsProt316 := factory315.GetProtocol(mbTrans313)
    argvalue0 := cluster.NewPullSnapshotRequest()
    err317 := argvalue0.Read(jsProt316)
    if err317 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PullSnapshot(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getGroupByExecutor":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetGroupByExecutor requires 1 args")
      flag.Usage()
    }
    arg318 := flag.Arg(1)
    mbTrans319 := thrift.NewTMemoryBufferLen(len(arg318))
    defer mbTrans319.Close()
    _, err320 := mbTrans319.WriteString(arg318)
    if err320 != nil {
      Usage()
      return
    }
    factory321 := thrift.NewTJSONProtocolFactory()
    jsProt322 := factory321.GetProtocol(mbTrans319)
    argvalue0 := cluster.NewGroupByRequest()
    err323 := argvalue0.Read(jsProt322)
    if err323 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetGroupByExecutor(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getGroupByResult":
    if flag.NArg() - 1 != 4 {
      fmt.Fprintln(os.Stderr, "GetGroupByResult_ requires 4 args")
      flag.Usage()
    }
    arg324 := flag.Arg(1)
    mbTrans325 := thrift.NewTMemoryBufferLen(len(arg324))
    defer mbTrans325.Close()
    _, err326 := mbTrans325.WriteString(arg324)
    if err326 != nil {
      Usage()
      return
    }
    factory327 := thrift.NewTJSONProtocolFactory()
    jsProt328 := factory327.GetProtocol(mbTrans325)
    argvalue0 := cluster.NewNode()
    err329 := argvalue0.Read(jsProt328)
    if err329 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err330 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err330 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    argvalue2, err331 := (strconv.ParseInt(flag.Arg(3), 10, 64))
    if err331 != nil {
      Usage()
      return
    }
    value2 := cluster.Long(argvalue2)
    argvalue3, err332 := (strconv.ParseInt(flag.Arg(4), 10, 64))
    if err332 != nil {
      Usage()
      return
    }
    value3 := cluster.Long(argvalue3)
    fmt.Print(client.GetGroupByResult_(context.Background(), value0, value1, value2, value3))
    fmt.Print("\n")
    break
  case "pullTimeSeriesSchema":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PullTimeSeriesSchema requires 1 args")
      flag.Usage()
    }
    arg333 := flag.Arg(1)
    mbTrans334 := thrift.NewTMemoryBufferLen(len(arg333))
    defer mbTrans334.Close()
    _, err335 := mbTrans334.WriteString(arg333)
    if err335 != nil {
      Usage()
      return
    }
    factory336 := thrift.NewTJSONProtocolFactory()
    jsProt337 := factory336.GetProtocol(mbTrans334)
    argvalue0 := cluster.NewPullSchemaRequest()
    err338 := argvalue0.Read(jsProt337)
    if err338 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PullTimeSeriesSchema(context.Background(), value0))
    fmt.Print("\n")
    break
  case "pullMeasurementSchema":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PullMeasurementSchema requires 1 args")
      flag.Usage()
    }
    arg339 := flag.Arg(1)
    mbTrans340 := thrift.NewTMemoryBufferLen(len(arg339))
    defer mbTrans340.Close()
    _, err341 := mbTrans340.WriteString(arg339)
    if err341 != nil {
      Usage()
      return
    }
    factory342 := thrift.NewTJSONProtocolFactory()
    jsProt343 := factory342.GetProtocol(mbTrans340)
    argvalue0 := cluster.NewPullSchemaRequest()
    err344 := argvalue0.Read(jsProt343)
    if err344 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PullMeasurementSchema(context.Background(), value0))
    fmt.Print("\n")
    break
  case "previousFill":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PreviousFill requires 1 args")
      flag.Usage()
    }
    arg345 := flag.Arg(1)
    mbTrans346 := thrift.NewTMemoryBufferLen(len(arg345))
    defer mbTrans346.Close()
    _, err347 := mbTrans346.WriteString(arg345)
    if err347 != nil {
      Usage()
      return
    }
    factory348 := thrift.NewTJSONProtocolFactory()
    jsProt349 := factory348.GetProtocol(mbTrans346)
    argvalue0 := cluster.NewPreviousFillRequest()
    err350 := argvalue0.Read(jsProt349)
    if err350 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PreviousFill(context.Background(), value0))
    fmt.Print("\n")
    break
  case "last":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Last requires 1 args")
      flag.Usage()
    }
    arg351 := flag.Arg(1)
    mbTrans352 := thrift.NewTMemoryBufferLen(len(arg351))
    defer mbTrans352.Close()
    _, err353 := mbTrans352.WriteString(arg351)
    if err353 != nil {
      Usage()
      return
    }
    factory354 := thrift.NewTJSONProtocolFactory()
    jsProt355 := factory354.GetProtocol(mbTrans352)
    argvalue0 := cluster.NewLastQueryRequest()
    err356 := argvalue0.Read(jsProt355)
    if err356 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.Last(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getPathCount":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "GetPathCount requires 3 args")
      flag.Usage()
    }
    arg357 := flag.Arg(1)
    mbTrans358 := thrift.NewTMemoryBufferLen(len(arg357))
    defer mbTrans358.Close()
    _, err359 := mbTrans358.WriteString(arg357)
    if err359 != nil {
      Usage()
      return
    }
    factory360 := thrift.NewTJSONProtocolFactory()
    jsProt361 := factory360.GetProtocol(mbTrans358)
    argvalue0 := cluster.NewNode()
    err362 := argvalue0.Read(jsProt361)
    if err362 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg363 := flag.Arg(2)
    mbTrans364 := thrift.NewTMemoryBufferLen(len(arg363))
    defer mbTrans364.Close()
    _, err365 := mbTrans364.WriteString(arg363)
    if err365 != nil { 
      Usage()
      return
    }
    factory366 := thrift.NewTJSONProtocolFactory()
    jsProt367 := factory366.GetProtocol(mbTrans364)
    containerStruct1 := cluster.NewTSDataServiceGetPathCountArgs()
    err368 := containerStruct1.ReadField2(jsProt367)
    if err368 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.PathsToQuery
    value1 := argvalue1
    tmp2, err369 := (strconv.Atoi(flag.Arg(3)))
    if err369 != nil {
      Usage()
      return
    }
    argvalue2 := int32(tmp2)
    value2 := cluster.Int(argvalue2)
    fmt.Print(client.GetPathCount(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "onSnapshotApplied":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "OnSnapshotApplied requires 2 args")
      flag.Usage()
    }
    arg370 := flag.Arg(1)
    mbTrans371 := thrift.NewTMemoryBufferLen(len(arg370))
    defer mbTrans371.Close()
    _, err372 := mbTrans371.WriteString(arg370)
    if err372 != nil {
      Usage()
      return
    }
    factory373 := thrift.NewTJSONProtocolFactory()
    jsProt374 := factory373.GetProtocol(mbTrans371)
    argvalue0 := cluster.NewNode()
    err375 := argvalue0.Read(jsProt374)
    if err375 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg376 := flag.Arg(2)
    mbTrans377 := thrift.NewTMemoryBufferLen(len(arg376))
    defer mbTrans377.Close()
    _, err378 := mbTrans377.WriteString(arg376)
    if err378 != nil { 
      Usage()
      return
    }
    factory379 := thrift.NewTJSONProtocolFactory()
    jsProt380 := factory379.GetProtocol(mbTrans377)
    containerStruct1 := cluster.NewTSDataServiceOnSnapshotAppliedArgs()
    err381 := containerStruct1.ReadField2(jsProt380)
    if err381 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Slots
    value1 := argvalue1
    fmt.Print(client.OnSnapshotApplied(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "peekNextNotNullValue":
    if flag.NArg() - 1 != 4 {
      fmt.Fprintln(os.Stderr, "PeekNextNotNullValue requires 4 args")
      flag.Usage()
    }
    arg382 := flag.Arg(1)
    mbTrans383 := thrift.NewTMemoryBufferLen(len(arg382))
    defer mbTrans383.Close()
    _, err384 := mbTrans383.WriteString(arg382)
    if err384 != nil {
      Usage()
      return
    }
    factory385 := thrift.NewTJSONProtocolFactory()
    jsProt386 := factory385.GetProtocol(mbTrans383)
    argvalue0 := cluster.NewNode()
    err387 := argvalue0.Read(jsProt386)
    if err387 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err388 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err388 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    argvalue2, err389 := (strconv.ParseInt(flag.Arg(3), 10, 64))
    if err389 != nil {
      Usage()
      return
    }
    value2 := cluster.Long(argvalue2)
    argvalue3, err390 := (strconv.ParseInt(flag.Arg(4), 10, 64))
    if err390 != nil {
      Usage()
      return
    }
    value3 := cluster.Long(argvalue3)
    fmt.Print(client.PeekNextNotNullValue(context.Background(), value0, value1, value2, value3))
    fmt.Print("\n")
    break
  case "sendHeartbeat":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendHeartbeat requires 1 args")
      flag.Usage()
    }
    arg391 := flag.Arg(1)
    mbTrans392 := thrift.NewTMemoryBufferLen(len(arg391))
    defer mbTrans392.Close()
    _, err393 := mbTrans392.WriteString(arg391)
    if err393 != nil {
      Usage()
      return
    }
    factory394 := thrift.NewTJSONProtocolFactory()
    jsProt395 := factory394.GetProtocol(mbTrans392)
    argvalue0 := cluster.NewHeartBeatRequest()
    err396 := argvalue0.Read(jsProt395)
    if err396 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendHeartbeat(context.Background(), value0))
    fmt.Print("\n")
    break
  case "startElection":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "StartElection requires 1 args")
      flag.Usage()
    }
    arg397 := flag.Arg(1)
    mbTrans398 := thrift.NewTMemoryBufferLen(len(arg397))
    defer mbTrans398.Close()
    _, err399 := mbTrans398.WriteString(arg397)
    if err399 != nil {
      Usage()
      return
    }
    factory400 := thrift.NewTJSONProtocolFactory()
    jsProt401 := factory400.GetProtocol(mbTrans398)
    argvalue0 := cluster.NewElectionRequest()
    err402 := argvalue0.Read(jsProt401)
    if err402 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.StartElection(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntries requires 1 args")
      flag.Usage()
    }
    arg403 := flag.Arg(1)
    mbTrans404 := thrift.NewTMemoryBufferLen(len(arg403))
    defer mbTrans404.Close()
    _, err405 := mbTrans404.WriteString(arg403)
    if err405 != nil {
      Usage()
      return
    }
    factory406 := thrift.NewTJSONProtocolFactory()
    jsProt407 := factory406.GetProtocol(mbTrans404)
    argvalue0 := cluster.NewAppendEntriesRequest()
    err408 := argvalue0.Read(jsProt407)
    if err408 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntry":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntry requires 1 args")
      flag.Usage()
    }
    arg409 := flag.Arg(1)
    mbTrans410 := thrift.NewTMemoryBufferLen(len(arg409))
    defer mbTrans410.Close()
    _, err411 := mbTrans410.WriteString(arg409)
    if err411 != nil {
      Usage()
      return
    }
    factory412 := thrift.NewTJSONProtocolFactory()
    jsProt413 := factory412.GetProtocol(mbTrans410)
    argvalue0 := cluster.NewAppendEntryRequest()
    err414 := argvalue0.Read(jsProt413)
    if err414 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntry(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendSnapshot":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendSnapshot requires 1 args")
      flag.Usage()
    }
    arg415 := flag.Arg(1)
    mbTrans416 := thrift.NewTMemoryBufferLen(len(arg415))
    defer mbTrans416.Close()
    _, err417 := mbTrans416.WriteString(arg415)
    if err417 != nil {
      Usage()
      return
    }
    factory418 := thrift.NewTJSONProtocolFactory()
    jsProt419 := factory418.GetProtocol(mbTrans416)
    argvalue0 := cluster.NewSendSnapshotRequest()
    err420 := argvalue0.Read(jsProt419)
    if err420 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendSnapshot(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeNonQueryPlan":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteNonQueryPlan requires 1 args")
      flag.Usage()
    }
    arg421 := flag.Arg(1)
    mbTrans422 := thrift.NewTMemoryBufferLen(len(arg421))
    defer mbTrans422.Close()
    _, err423 := mbTrans422.WriteString(arg421)
    if err423 != nil {
      Usage()
      return
    }
    factory424 := thrift.NewTJSONProtocolFactory()
    jsProt425 := factory424.GetProtocol(mbTrans422)
    argvalue0 := cluster.NewExecutNonQueryReq()
    err426 := argvalue0.Read(jsProt425)
    if err426 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteNonQueryPlan(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestCommitIndex":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestCommitIndex requires 1 args")
      flag.Usage()
    }
    arg427 := flag.Arg(1)
    mbTrans428 := thrift.NewTMemoryBufferLen(len(arg427))
    defer mbTrans428.Close()
    _, err429 := mbTrans428.WriteString(arg427)
    if err429 != nil {
      Usage()
      return
    }
    factory430 := thrift.NewTJSONProtocolFactory()
    jsProt431 := factory430.GetProtocol(mbTrans428)
    argvalue0 := cluster.NewNode()
    err432 := argvalue0.Read(jsProt431)
    if err432 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestCommitIndex(context.Background(), value0))
    fmt.Print("\n")
    break
  case "readFile":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "ReadFile requires 3 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    argvalue1, err434 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err434 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    tmp2, err435 := (strconv.Atoi(flag.Arg(3)))
    if err435 != nil {
      Usage()
      return
    }
    argvalue2 := int32(tmp2)
    value2 := cluster.Int(argvalue2)
    fmt.Print(client.ReadFile(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "matchTerm":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "MatchTerm requires 3 args")
      flag.Usage()
    }
    argvalue0, err436 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err436 != nil {
      Usage()
      return
    }
    value0 := cluster.Long(argvalue0)
    argvalue1, err437 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err437 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    arg438 := flag.Arg(3)
    mbTrans439 := thrift.NewTMemoryBufferLen(len(arg438))
    defer mbTrans439.Close()
    _, err440 := mbTrans439.WriteString(arg438)
    if err440 != nil {
      Usage()
      return
    }
    factory441 := thrift.NewTJSONProtocolFactory()
    jsProt442 := factory441.GetProtocol(mbTrans439)
    argvalue2 := cluster.NewNode()
    err443 := argvalue2.Read(jsProt442)
    if err443 != nil {
      Usage()
      return
    }
    value2 := argvalue2
    fmt.Print(client.MatchTerm(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "removeHardLink":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RemoveHardLink requires 1 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    fmt.Print(client.RemoveHardLink(context.Background(), value0))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
