// Autogenerated by Thrift Compiler (0.13.0)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"rpc"
	"cluster"
)

var _ = rpc.GoUnusedProtection__
var _ = cluster.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  HeartBeatResponse sendHeartbeat(HeartBeatRequest request)")
  fmt.Fprintln(os.Stderr, "  long startElection(ElectionRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntries(AppendEntriesRequest request)")
  fmt.Fprintln(os.Stderr, "  long appendEntry(AppendEntryRequest request)")
  fmt.Fprintln(os.Stderr, "  void sendSnapshot(SendSnapshotRequest request)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeNonQueryPlan(ExecutNonQueryReq request)")
  fmt.Fprintln(os.Stderr, "  long requestCommitIndex(Node header)")
  fmt.Fprintln(os.Stderr, "  string readFile(string filePath, long offset, int length)")
  fmt.Fprintln(os.Stderr, "  bool matchTerm(long index, long term, Node header)")
  fmt.Fprintln(os.Stderr, "  void removeHardLink(string hardLinkPath)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := cluster.NewRaftServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "sendHeartbeat":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendHeartbeat requires 1 args")
      flag.Usage()
    }
    arg46 := flag.Arg(1)
    mbTrans47 := thrift.NewTMemoryBufferLen(len(arg46))
    defer mbTrans47.Close()
    _, err48 := mbTrans47.WriteString(arg46)
    if err48 != nil {
      Usage()
      return
    }
    factory49 := thrift.NewTJSONProtocolFactory()
    jsProt50 := factory49.GetProtocol(mbTrans47)
    argvalue0 := cluster.NewHeartBeatRequest()
    err51 := argvalue0.Read(jsProt50)
    if err51 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendHeartbeat(context.Background(), value0))
    fmt.Print("\n")
    break
  case "startElection":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "StartElection requires 1 args")
      flag.Usage()
    }
    arg52 := flag.Arg(1)
    mbTrans53 := thrift.NewTMemoryBufferLen(len(arg52))
    defer mbTrans53.Close()
    _, err54 := mbTrans53.WriteString(arg52)
    if err54 != nil {
      Usage()
      return
    }
    factory55 := thrift.NewTJSONProtocolFactory()
    jsProt56 := factory55.GetProtocol(mbTrans53)
    argvalue0 := cluster.NewElectionRequest()
    err57 := argvalue0.Read(jsProt56)
    if err57 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.StartElection(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntries requires 1 args")
      flag.Usage()
    }
    arg58 := flag.Arg(1)
    mbTrans59 := thrift.NewTMemoryBufferLen(len(arg58))
    defer mbTrans59.Close()
    _, err60 := mbTrans59.WriteString(arg58)
    if err60 != nil {
      Usage()
      return
    }
    factory61 := thrift.NewTJSONProtocolFactory()
    jsProt62 := factory61.GetProtocol(mbTrans59)
    argvalue0 := cluster.NewAppendEntriesRequest()
    err63 := argvalue0.Read(jsProt62)
    if err63 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendEntry":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendEntry requires 1 args")
      flag.Usage()
    }
    arg64 := flag.Arg(1)
    mbTrans65 := thrift.NewTMemoryBufferLen(len(arg64))
    defer mbTrans65.Close()
    _, err66 := mbTrans65.WriteString(arg64)
    if err66 != nil {
      Usage()
      return
    }
    factory67 := thrift.NewTJSONProtocolFactory()
    jsProt68 := factory67.GetProtocol(mbTrans65)
    argvalue0 := cluster.NewAppendEntryRequest()
    err69 := argvalue0.Read(jsProt68)
    if err69 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendEntry(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendSnapshot":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendSnapshot requires 1 args")
      flag.Usage()
    }
    arg70 := flag.Arg(1)
    mbTrans71 := thrift.NewTMemoryBufferLen(len(arg70))
    defer mbTrans71.Close()
    _, err72 := mbTrans71.WriteString(arg70)
    if err72 != nil {
      Usage()
      return
    }
    factory73 := thrift.NewTJSONProtocolFactory()
    jsProt74 := factory73.GetProtocol(mbTrans71)
    argvalue0 := cluster.NewSendSnapshotRequest()
    err75 := argvalue0.Read(jsProt74)
    if err75 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SendSnapshot(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeNonQueryPlan":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteNonQueryPlan requires 1 args")
      flag.Usage()
    }
    arg76 := flag.Arg(1)
    mbTrans77 := thrift.NewTMemoryBufferLen(len(arg76))
    defer mbTrans77.Close()
    _, err78 := mbTrans77.WriteString(arg76)
    if err78 != nil {
      Usage()
      return
    }
    factory79 := thrift.NewTJSONProtocolFactory()
    jsProt80 := factory79.GetProtocol(mbTrans77)
    argvalue0 := cluster.NewExecutNonQueryReq()
    err81 := argvalue0.Read(jsProt80)
    if err81 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteNonQueryPlan(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestCommitIndex":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestCommitIndex requires 1 args")
      flag.Usage()
    }
    arg82 := flag.Arg(1)
    mbTrans83 := thrift.NewTMemoryBufferLen(len(arg82))
    defer mbTrans83.Close()
    _, err84 := mbTrans83.WriteString(arg82)
    if err84 != nil {
      Usage()
      return
    }
    factory85 := thrift.NewTJSONProtocolFactory()
    jsProt86 := factory85.GetProtocol(mbTrans83)
    argvalue0 := cluster.NewNode()
    err87 := argvalue0.Read(jsProt86)
    if err87 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestCommitIndex(context.Background(), value0))
    fmt.Print("\n")
    break
  case "readFile":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "ReadFile requires 3 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    argvalue1, err89 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err89 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    tmp2, err90 := (strconv.Atoi(flag.Arg(3)))
    if err90 != nil {
      Usage()
      return
    }
    argvalue2 := int32(tmp2)
    value2 := cluster.Int(argvalue2)
    fmt.Print(client.ReadFile(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "matchTerm":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "MatchTerm requires 3 args")
      flag.Usage()
    }
    argvalue0, err91 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err91 != nil {
      Usage()
      return
    }
    value0 := cluster.Long(argvalue0)
    argvalue1, err92 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err92 != nil {
      Usage()
      return
    }
    value1 := cluster.Long(argvalue1)
    arg93 := flag.Arg(3)
    mbTrans94 := thrift.NewTMemoryBufferLen(len(arg93))
    defer mbTrans94.Close()
    _, err95 := mbTrans94.WriteString(arg93)
    if err95 != nil {
      Usage()
      return
    }
    factory96 := thrift.NewTJSONProtocolFactory()
    jsProt97 := factory96.GetProtocol(mbTrans94)
    argvalue2 := cluster.NewNode()
    err98 := argvalue2.Read(jsProt97)
    if err98 != nil {
      Usage()
      return
    }
    value2 := argvalue2
    fmt.Print(client.MatchTerm(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "removeHardLink":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RemoveHardLink requires 1 args")
      flag.Usage()
    }
    argvalue0 := flag.Arg(1)
    value0 := argvalue0
    fmt.Print(client.RemoveHardLink(context.Background(), value0))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
