/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;

public class GroupByFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = -1211805021419281440L;
    protected long interval;
    protected long slidingStep;
    protected long startTime;
    protected long endTime;

    public GroupByFilter(long interval, long slidingStep, long startTime, long endTime) {
        this.interval = interval;
        this.slidingStep = slidingStep;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public GroupByFilter() {
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        return this.satisfyStartEndTime(statistics.getStartTime(), statistics.getEndTime());
    }

    @Override
    public boolean satisfy(long time, Object value) {
        if (time < this.startTime || time >= this.endTime) {
            return false;
        }
        return (time - this.startTime) % this.slidingStep < this.interval;
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        if (endTime < this.startTime || startTime >= this.endTime) {
            return false;
        }
        if (startTime <= this.startTime) {
            return true;
        }
        long minTime = startTime - this.startTime;
        long count = minTime / this.slidingStep;
        if (minTime <= this.interval + count * this.slidingStep) {
            return true;
        }
        if (this.endTime <= (count + 1L) * this.slidingStep + this.startTime) {
            return false;
        }
        return endTime >= (count + 1L) * this.slidingStep + this.startTime;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        if (startTime >= this.startTime && endTime <= this.endTime) {
            long minTime = startTime - this.startTime;
            long maxTime = endTime - this.startTime;
            long count = minTime / this.slidingStep;
            return minTime <= this.interval + count * this.slidingStep && maxTime <= this.interval + count * this.slidingStep;
        }
        return false;
    }

    @Override
    public Filter copy() {
        return new GroupByFilter(this.interval, this.slidingStep, this.startTime, this.endTime);
    }

    public String toString() {
        return "GroupByFilter{}";
    }

    @Override
    public void serialize(DataOutputStream outputStream) {
        try {
            outputStream.write(this.getSerializeId().ordinal());
            outputStream.writeLong(this.interval);
            outputStream.writeLong(this.slidingStep);
            outputStream.writeLong(this.startTime);
            outputStream.writeLong(this.endTime);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.interval = buffer.getLong();
        this.slidingStep = buffer.getLong();
        this.startTime = buffer.getLong();
        this.endTime = buffer.getLong();
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.GROUP_BY;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupByFilter)) {
            return false;
        }
        GroupByFilter other = (GroupByFilter)obj;
        return this.interval == other.interval && this.slidingStep == other.slidingStep && this.startTime == other.startTime && this.endTime == other.endTime;
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.slidingStep, this.startTime, this.endTime);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }
}

