/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.fileSystem.fileOutputFactory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.tsfile.fileSystem.fileOutputFactory.FileOutputFactory;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSOutputFactory
implements FileOutputFactory {
    private static final Logger logger = LoggerFactory.getLogger(HDFSOutputFactory.class);
    private static Constructor constructor;

    @Override
    public TsFileOutput getTsFileOutput(String filePath, boolean append) {
        try {
            return (TsFileOutput)constructor.newInstance(filePath, !append);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get TsFile output of file: {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.apache.iotdb.hadoop.fileSystem.HDFSOutput");
            constructor = clazz.getConstructor(String.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            logger.error("Failed to get HDFSInput in Hadoop file system. Please check your dependency of Hadoop module.", e);
        }
    }
}

