/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.pool;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.rpc.BatchExecutionException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.session.pool.SessionDataSetWrapper;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool {
    private static final Logger logger = LoggerFactory.getLogger(SessionPool.class);
    private static int RETRY = 3;
    private ConcurrentLinkedDeque<Session> queue = new ConcurrentLinkedDeque();
    private ConcurrentMap<Session, Session> occupied = new ConcurrentHashMap<Session, Session>();
    private int size = 0;
    private int maxSize = 0;
    private String ip;
    private int port;
    private String user;
    private String password;
    private int fetchSize;
    private long timeout;
    private static int FINAL_RETRY = RETRY - 1;
    private boolean enableCompression = false;

    public SessionPool(String ip, int port, String user, String password, int maxSize) {
        this(ip, port, user, password, maxSize, 10000, 60000L, false);
    }

    public SessionPool(String ip, int port, String user, String password, int maxSize, boolean enableCompression) {
        this(ip, port, user, password, maxSize, 10000, 60000L, enableCompression);
    }

    public SessionPool(String ip, int port, String user, String password, int maxSize, int fetchSize, long timeout, boolean enableCompression) {
        this.maxSize = maxSize;
        this.ip = ip;
        this.port = port;
        this.user = user;
        this.password = password;
        this.fetchSize = fetchSize;
        this.timeout = timeout;
        this.enableCompression = enableCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession() throws IoTDBConnectionException {
        Session session = this.queue.poll();
        if (session != null) {
            return session;
        }
        SessionPool sessionPool = this;
        synchronized (sessionPool) {
            long start = System.currentTimeMillis();
            while (session == null) {
                if (this.size < this.maxSize) {
                    ++this.size;
                    break;
                }
                try {
                    this.wait(1000L);
                    if (System.currentTimeMillis() - start > 60000L) {
                        logger.warn("the SessionPool has wait for {} seconds to get a new connection: {}:{} with {}, {}", new Object[]{(System.currentTimeMillis() - start) / 1000L, this.ip, this.port, this.user, this.password});
                        if (System.currentTimeMillis() - start > this.timeout) {
                            throw new IoTDBConnectionException(String.format("timeout to get a connection from %s:%s", this.ip, this.port));
                        }
                    }
                }
                catch (InterruptedException e) {
                    logger.error("the SessionPool is damaged", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                session = this.queue.poll();
            }
            if (session != null) {
                return session;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Create a new Session {}, {}, {}, {}", new Object[]{this.ip, this.port, this.user, this.password});
        }
        session = new Session(this.ip, this.port, this.user, this.password, this.fetchSize);
        session.open(this.enableCompression);
        return session;
    }

    public int currentAvailableSize() {
        return this.queue.size();
    }

    public int currentOccupiedSize() {
        return this.occupied.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBack(Session session) {
        this.queue.push(session);
        SessionPool sessionPool = this;
        synchronized (sessionPool) {
            this.notifyAll();
        }
    }

    private void occupy(Session session) {
        this.occupied.put(session, session);
    }

    public synchronized void close() {
        for (Session session : this.queue) {
            try {
                session.close();
            }
            catch (IoTDBConnectionException ioTDBConnectionException) {}
        }
        for (Session session : this.occupied.keySet()) {
            try {
                session.close();
            }
            catch (IoTDBConnectionException ioTDBConnectionException) {}
        }
        this.queue.clear();
        this.occupied.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeResultSet(SessionDataSetWrapper wrapper) {
        boolean putback = true;
        try {
            wrapper.sessionDataSet.closeOperationHandle();
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            this.removeSession();
            putback = false;
        }
        finally {
            Session session = (Session)this.occupied.remove(wrapper.session);
            if (putback && session != null) {
                this.putBack(wrapper.session);
            }
        }
    }

    private synchronized void removeSession() {
        if (logger.isDebugEnabled()) {
            logger.debug("Remove a broken Session {}, {}, {}, {}", new Object[]{this.ip, this.port, this.user, this.password});
        }
        --this.size;
    }

    private void closeSession(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cleanSessionAndMayThrowConnectionException(Session session, int times, IoTDBConnectionException e) throws IoTDBConnectionException {
        this.closeSession(session);
        this.removeSession();
        if (times == FINAL_RETRY) {
            throw new IoTDBConnectionException(String.format("retry to execute statement on %s:%s failed %d times: %s", this.ip, this.port, RETRY, e.getMessage()), (Throwable)e);
        }
    }

    public void insertTablet(Tablet tablet) throws IoTDBConnectionException, BatchExecutionException {
        this.insertTablet(tablet, false);
    }

    public void insertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, BatchExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.insertTablet(tablet, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (BatchExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, BatchExecutionException {
        this.insertTablets(tablets, false);
    }

    public void insertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, BatchExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.insertTablets(tablets, sorted);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (BatchExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, BatchExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (BatchExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, BatchExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecords(deviceIds, times, measurementsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (BatchExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecord(deviceId, time, measurements, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.insertRecord(deviceId, time, measurements, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertTablet(Tablet tablet) throws IoTDBConnectionException, BatchExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertTablet(tablet);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (BatchExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, BatchExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertTablets(tablets);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (BatchExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, BatchExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecords(deviceIds, times, measurementsList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (BatchExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, BatchExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (BatchExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecord(deviceId, time, measurements, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.testInsertRecord(deviceId, time, measurements, types, values);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteTimeseries(String path) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.deleteTimeseries(path);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.deleteTimeseries(paths);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteData(String path, long time) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.deleteData(path, time);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteData(List<String> paths, long time) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.deleteData(paths, time);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void setStorageGroup(String storageGroupId) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.setStorageGroup(storageGroupId);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.deleteStorageGroup(storageGroup);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void deleteStorageGroups(List<String> storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.deleteStorageGroups(storageGroup);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.createTimeseries(path, dataType, encoding, compressor);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.createTimeseries(path, dataType, encoding, compressor, props, tags, attributes, measurementAlias);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public void createMultiTimeseries(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) throws IoTDBConnectionException, BatchExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.createMultiTimeseries(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (BatchExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }

    public boolean checkTimeseriesExists(String path) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                boolean resp = session.checkTimeseriesExists(path);
                this.putBack(session);
                return resp;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return false;
    }

    public SessionDataSetWrapper executeQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                SessionDataSet resp = session.executeQueryStatement(sql);
                SessionDataSetWrapper wrapper = new SessionDataSetWrapper(resp, session, this);
                this.occupy(session);
                return wrapper;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
        return null;
    }

    public void executeNonQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        for (int i = 0; i < RETRY; ++i) {
            Session session = this.getSession();
            try {
                session.executeNonQueryStatement(sql);
                this.putBack(session);
                return;
            }
            catch (IoTDBConnectionException e) {
                this.cleanSessionAndMayThrowConnectionException(session, i, e);
                continue;
            }
            catch (StatementExecutionException e) {
                this.putBack(session);
                throw e;
            }
        }
    }
}

