/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.rpc.BatchExecutionException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.session.SessionUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private final TSProtocolVersion protocolVersion = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V2;
    private String host;
    private int port;
    private String username;
    private String password;
    private TSIService.Iface client = null;
    private long sessionId;
    private TSocket transport;
    private boolean isClosed = true;
    private ZoneId zoneId;
    private long statementId;
    private int fetchSize;

    public Session(String host, int port) {
        this(host, port, "user", "password");
    }

    public Session(String host, String port, String username, String password) {
        this(host, Integer.parseInt(port), username, password);
    }

    public Session(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.fetchSize = 10000;
    }

    public Session(String host, int port, String username, String password, int fetchSize) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.fetchSize = fetchSize;
    }

    public synchronized void open() throws IoTDBConnectionException {
        this.open(false, 0);
    }

    public synchronized void open(boolean enableRPCCompression) throws IoTDBConnectionException {
        this.open(enableRPCCompression, 0);
    }

    private synchronized void open(boolean enableRPCCompression, int connectionTimeoutInMs) throws IoTDBConnectionException {
        if (!this.isClosed) {
            return;
        }
        this.transport = new TSocket(this.host, this.port, connectionTimeoutInMs);
        if (!this.transport.isOpen()) {
            try {
                this.transport.open();
            }
            catch (TTransportException e) {
                throw new IoTDBConnectionException((Throwable)e);
            }
        }
        this.client = enableRPCCompression ? new TSIService.Client((TProtocol)new TCompactProtocol((TTransport)this.transport)) : new TSIService.Client((TProtocol)new TBinaryProtocol((TTransport)this.transport));
        TSOpenSessionReq openReq = new TSOpenSessionReq();
        openReq.setUsername(this.username);
        openReq.setPassword(this.password);
        try {
            TSOpenSessionResp openResp = this.client.openSession(openReq);
            RpcUtils.verifySuccess((TSStatus)openResp.getStatus());
            if (this.protocolVersion.getValue() != openResp.getServerProtocolVersion().getValue()) {
                logger.warn("Protocol differ, Client version is {}}, but Server version is {}", (Object)this.protocolVersion.getValue(), (Object)openResp.getServerProtocolVersion().getValue());
                if (openResp.getServerProtocolVersion().getValue() == 0) {
                    throw new TException(String.format("Protocol not supported, Client version is %s, but Server version is %s", this.protocolVersion.getValue(), openResp.getServerProtocolVersion().getValue()));
                }
            }
            this.sessionId = openResp.getSessionId();
            this.statementId = this.client.requestStatementId(this.sessionId);
            if (this.zoneId != null) {
                this.setTimeZone(this.zoneId.toString());
            } else {
                this.zoneId = ZoneId.of(this.getTimeZone());
            }
        }
        catch (Exception e) {
            this.transport.close();
            throw new IoTDBConnectionException((Throwable)e);
        }
        this.isClosed = false;
        this.client = RpcUtils.newSynchronizedClient((TSIService.Iface)this.client);
    }

    public synchronized void close() throws IoTDBConnectionException {
        if (this.isClosed) {
            return;
        }
        TSCloseSessionReq req = new TSCloseSessionReq(this.sessionId);
        try {
            this.client.closeSession(req);
        }
        catch (TException e) {
            throw new IoTDBConnectionException("Error occurs when closing session at server. Maybe server is down.", (Throwable)e);
        }
        finally {
            this.isClosed = true;
            if (this.transport != null) {
                this.transport.close();
            }
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, Object ... values) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<Object> valuesList = new ArrayList<Object>(Arrays.asList(values));
        this.insertRecord(deviceId, time, measurements, types, valuesList);
    }

    public void insertTablet(Tablet tablet) throws BatchExecutionException, IoTDBConnectionException {
        this.insertTablet(tablet, false);
    }

    public void insertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, BatchExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted);
        try {
            RpcUtils.verifySuccess((List)this.client.insertTablet((TSInsertTabletReq)request).statusList);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    private TSInsertTabletReq genTSInsertTabletReq(Tablet tablet, boolean sorted) throws BatchExecutionException {
        if (sorted) {
            if (!this.checkSorted(tablet)) {
                throw new BatchExecutionException("Times in Tablet are not in ascending order");
            }
        } else {
            this.sortTablet(tablet);
        }
        TSInsertTabletReq request = new TSInsertTabletReq();
        request.setSessionId(this.sessionId);
        request.deviceId = tablet.deviceId;
        for (MeasurementSchema measurementSchema : tablet.getSchemas()) {
            request.addToMeasurements(measurementSchema.getMeasurementId());
            request.addToTypes(measurementSchema.getType().ordinal());
        }
        request.setTimestamps(SessionUtils.getTimeBuffer(tablet));
        request.setValues(SessionUtils.getValueBuffer(tablet));
        request.setSize(tablet.rowSize);
        return request;
    }

    public void insertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, BatchExecutionException {
        this.insertTablets(tablets, false);
    }

    public void insertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, BatchExecutionException {
        TSInsertTabletsReq request = this.genTSInsertTabletsReq(tablets, sorted);
        try {
            RpcUtils.verifySuccess((List)this.client.insertTablets((TSInsertTabletsReq)request).statusList);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    private TSInsertTabletsReq genTSInsertTabletsReq(Map<String, Tablet> tablets, boolean sorted) throws BatchExecutionException {
        TSInsertTabletsReq request = new TSInsertTabletsReq();
        request.setSessionId(this.sessionId);
        for (Tablet tablet : tablets.values()) {
            if (sorted) {
                if (!this.checkSorted(tablet)) {
                    throw new BatchExecutionException("Times in Tablet are not in ascending order");
                }
            } else {
                this.sortTablet(tablet);
            }
            request.addToDeviceIds(tablet.deviceId);
            ArrayList<String> measurements = new ArrayList<String>();
            ArrayList<Integer> dataTypes = new ArrayList<Integer>();
            for (MeasurementSchema measurementSchema : tablet.getSchemas()) {
                measurements.add(measurementSchema.getMeasurementId());
                dataTypes.add(measurementSchema.getType().ordinal());
            }
            request.addToMeasurementsList(measurements);
            request.addToTypesList(dataTypes);
            request.addToTimestampsList(SessionUtils.getTimeBuffer(tablet));
            request.addToValuesList(SessionUtils.getValueBuffer(tablet));
            request.addToSizeList(tablet.rowSize);
        }
        return request;
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, BatchExecutionException {
        TSInsertRecordsReq request = this.genTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList);
        try {
            RpcUtils.verifySuccess((List)this.client.insertRecords((TSInsertRecordsReq)request).statusList);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    private TSInsertRecordsReq genTSInsertRecordsReq(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        TSInsertRecordsReq request = new TSInsertRecordsReq();
        request.setSessionId(this.sessionId);
        request.setDeviceIds(deviceIds);
        request.setTimestamps(times);
        request.setMeasurementsList(measurementsList);
        ArrayList<ByteBuffer> buffersList = new ArrayList<ByteBuffer>();
        for (int i = 0; i < measurementsList.size(); ++i) {
            ByteBuffer buffer = ByteBuffer.allocate(this.calculateLength(typesList.get(i), valuesList.get(i)));
            this.putValues(typesList.get(i), valuesList.get(i), buffer);
            buffer.flip();
            buffersList.add(buffer);
        }
        request.setValuesList(buffersList);
        return request;
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, BatchExecutionException {
        TSInsertRecordsReq request = this.genTSInsertRecordsReq(deviceIds, times, measurementsList, valuesList);
        try {
            RpcUtils.verifySuccess((List)this.client.insertRecords((TSInsertRecordsReq)request).statusList);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    private TSInsertRecordsReq genTSInsertRecordsReq(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        TSInsertRecordsReq request = new TSInsertRecordsReq();
        request.setSessionId(this.sessionId);
        request.setDeviceIds(deviceIds);
        request.setTimestamps(times);
        request.setMeasurementsList(measurementsList);
        request.setInferType(true);
        ArrayList<ByteBuffer> buffersList = new ArrayList<ByteBuffer>();
        for (int i = 0; i < measurementsList.size(); ++i) {
            ByteBuffer buffer = ByteBuffer.allocate(this.calculateStrLength(valuesList.get(i)));
            this.putStrValues(valuesList.get(i), buffer);
            buffer.flip();
            buffersList.add(buffer);
        }
        request.setValuesList(buffersList);
        return request;
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, types, values);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.insertRecord(request));
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    private TSInsertRecordReq genTSInsertRecordReq(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        TSInsertRecordReq request = new TSInsertRecordReq();
        request.setSessionId(this.sessionId);
        request.setDeviceId(deviceId);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateLength(types, values));
        this.putValues(types, values, buffer);
        buffer.flip();
        request.setValues(buffer);
        return request;
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, values);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.insertRecord(request));
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    private TSInsertRecordReq genTSInsertRecordReq(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException {
        TSInsertRecordReq request = new TSInsertRecordReq();
        request.setSessionId(this.sessionId);
        request.setDeviceId(deviceId);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        request.setInferType(true);
        ByteBuffer buffer = ByteBuffer.allocate(this.calculateStrLength(values));
        this.putStrValues(values, buffer);
        buffer.flip();
        request.setValues(buffer);
        return request;
    }

    private void putStrValues(List<String> values, ByteBuffer buffer) throws IoTDBConnectionException {
        for (int i = 0; i < values.size(); ++i) {
            ReadWriteIOUtils.write((TSDataType)TSDataType.TEXT, (ByteBuffer)buffer);
            byte[] bytes = values.get(i).getBytes(TSFileConfig.STRING_CHARSET);
            ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)buffer);
            buffer.put(bytes);
        }
    }

    private void putValues(List<TSDataType> types, List<Object> values, ByteBuffer buffer) throws IoTDBConnectionException {
        block8: for (int i = 0; i < values.size(); ++i) {
            ReadWriteIOUtils.write((TSDataType)types.get(i), (ByteBuffer)buffer);
            switch (types.get(i)) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)values.get(i)).floatValue(), (ByteBuffer)buffer);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)values.get(i)), (ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    byte[] bytes = ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET);
                    ReadWriteIOUtils.write((int)bytes.length, (ByteBuffer)buffer);
                    buffer.put(bytes);
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException("Unsupported data type:" + types.get(i));
                }
            }
        }
    }

    private int calculateStrLength(List<String> values) {
        int res = 0;
        for (int i = 0; i < values.size(); ++i) {
            res += 2;
            res += 4;
            res += values.get(i).getBytes(TSFileConfig.STRING_CHARSET).length;
        }
        return res;
    }

    private int calculateLength(List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        int res = 0;
        block8: for (int i = 0; i < types.size(); ++i) {
            res += 2;
            switch (types.get(i)) {
                case BOOLEAN: {
                    ++res;
                    continue block8;
                }
                case INT32: {
                    res += 4;
                    continue block8;
                }
                case INT64: {
                    res += 8;
                    continue block8;
                }
                case FLOAT: {
                    res += 4;
                    continue block8;
                }
                case DOUBLE: {
                    res += 8;
                    continue block8;
                }
                case TEXT: {
                    res += 4;
                    res += ((String)values.get(i)).getBytes(TSFileConfig.STRING_CHARSET).length;
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException("Unsupported data type:" + types.get(i));
                }
            }
        }
        return res;
    }

    public void testInsertTablet(Tablet tablet) throws IoTDBConnectionException, BatchExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, false);
        try {
            RpcUtils.verifySuccess((List)this.client.testInsertTablet((TSInsertTabletReq)request).statusList);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void testInsertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, BatchExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted);
        try {
            RpcUtils.verifySuccess((List)this.client.testInsertTablet((TSInsertTabletReq)request).statusList);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void testInsertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, BatchExecutionException {
        TSInsertTabletsReq request = this.genTSInsertTabletsReq(tablets, false);
        try {
            RpcUtils.verifySuccess((List)this.client.testInsertTablets((TSInsertTabletsReq)request).statusList);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void testInsertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, BatchExecutionException {
        TSInsertTabletsReq request = this.genTSInsertTabletsReq(tablets, sorted);
        try {
            RpcUtils.verifySuccess((List)this.client.testInsertTablets((TSInsertTabletsReq)request).statusList);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, BatchExecutionException {
        TSInsertRecordsReq request = this.genTSInsertRecordsReq(deviceIds, times, measurementsList, valuesList);
        try {
            RpcUtils.verifySuccess((List)this.client.testInsertRecords((TSInsertRecordsReq)request).statusList);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, BatchExecutionException {
        TSInsertRecordsReq request = this.genTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList);
        try {
            RpcUtils.verifySuccess((List)this.client.testInsertRecords((TSInsertRecordsReq)request).statusList);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, values);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.testInsertRecord(request));
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request = this.genTSInsertRecordReq(deviceId, time, measurements, types, values);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.testInsertRecord(request));
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void deleteTimeseries(String path) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(path);
        this.deleteTimeseries(paths);
    }

    public void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.deleteTimeseries(this.sessionId, paths));
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void deleteData(String path, long time) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(path);
        this.deleteData(paths, time);
    }

    public void deleteData(List<String> paths, long time) throws IoTDBConnectionException, StatementExecutionException {
        TSDeleteDataReq request = new TSDeleteDataReq();
        request.setSessionId(this.sessionId);
        request.setPaths(paths);
        request.setTimestamp(time);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.deleteData(request));
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void setStorageGroup(String storageGroupId) throws IoTDBConnectionException, StatementExecutionException {
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.setStorageGroup(this.sessionId, storageGroupId));
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void deleteStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(storageGroup);
        this.deleteStorageGroups(groups);
    }

    public void deleteStorageGroups(List<String> storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.deleteStorageGroups(this.sessionId, storageGroup));
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IoTDBConnectionException, StatementExecutionException {
        this.createTimeseries(path, dataType, encoding, compressor, null, null, null, null);
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateTimeseriesReq request = new TSCreateTimeseriesReq();
        request.setSessionId(this.sessionId);
        request.setPath(path);
        request.setDataType(dataType.ordinal());
        request.setEncoding(encoding.ordinal());
        request.setCompressor(compressor.ordinal());
        request.setProps(props);
        request.setTags(tags);
        request.setAttributes(attributes);
        request.setMeasurementAlias(measurementAlias);
        try {
            RpcUtils.verifySuccess((TSStatus)this.client.createTimeseries(request));
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    public void createMultiTimeseries(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) throws IoTDBConnectionException, BatchExecutionException {
        TSCreateMultiTimeseriesReq request = new TSCreateMultiTimeseriesReq();
        request.setSessionId(this.sessionId);
        request.setPaths(paths);
        ArrayList<Integer> dataTypeOrdinals = new ArrayList<Integer>(paths.size());
        for (TSDataType tSDataType : dataTypes) {
            dataTypeOrdinals.add(tSDataType.ordinal());
        }
        request.setDataTypes(dataTypeOrdinals);
        ArrayList<Integer> encodingOrdinals = new ArrayList<Integer>(paths.size());
        for (TSEncoding tSEncoding : encodings) {
            encodingOrdinals.add(tSEncoding.ordinal());
        }
        request.setEncodings(encodingOrdinals);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(paths.size());
        for (CompressionType compression : compressors) {
            arrayList.add(compression.ordinal());
        }
        request.setCompressors(arrayList);
        request.setPropsList(propsList);
        request.setTagsList(tagsList);
        request.setAttributesList(attributesList);
        request.setMeasurementAliasList(measurementAliasList);
        try {
            RpcUtils.verifySuccess((List)this.client.createMultiTimeseries((TSCreateMultiTimeseriesReq)request).statusList);
        }
        catch (TException tException) {
            throw new IoTDBConnectionException((Throwable)tException);
        }
    }

    public boolean checkTimeseriesExists(String path) throws IoTDBConnectionException, StatementExecutionException {
        SessionDataSet dataSet = this.executeQueryStatement(String.format("SHOW TIMESERIES %s", path));
        boolean result = dataSet.hasNext();
        dataSet.closeOperationHandle();
        return result;
    }

    private synchronized String getTimeZone() throws StatementExecutionException, IoTDBConnectionException {
        TSGetTimeZoneResp resp;
        if (this.zoneId != null) {
            return this.zoneId.toString();
        }
        try {
            resp = this.client.getTimeZone(this.sessionId);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
        RpcUtils.verifySuccess((TSStatus)resp.getStatus());
        return resp.getTimeZone();
    }

    private synchronized void setTimeZone(String zoneId) throws StatementExecutionException, IoTDBConnectionException {
        TSStatus resp;
        TSSetTimeZoneReq req = new TSSetTimeZoneReq(this.sessionId, zoneId);
        try {
            resp = this.client.setTimeZone(req);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
        RpcUtils.verifySuccess((TSStatus)resp);
        this.zoneId = ZoneId.of(zoneId);
    }

    public SessionDataSet executeQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        TSExecuteStatementResp execResp;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.statementId);
        execReq.setFetchSize(this.fetchSize);
        try {
            execResp = this.client.executeQueryStatement(execReq);
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
        RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        return new SessionDataSet(sql, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.getQueryId(), this.client, this.sessionId, execResp.queryDataSet, execResp.isIgnoreTimeStamp());
    }

    public void executeNonQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.statementId);
        try {
            TSExecuteStatementResp execResp = this.client.executeUpdateStatement(execReq);
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (TException e) {
            throw new IoTDBConnectionException((Throwable)e);
        }
    }

    private boolean checkSorted(Tablet tablet) {
        for (int i = 1; i < tablet.rowSize; ++i) {
            if (tablet.timestamps[i] >= tablet.timestamps[i - 1]) continue;
            return false;
        }
        return true;
    }

    public void sortTablet(Tablet tablet) {
        int i;
        Integer[] index = new Integer[tablet.rowSize];
        for (i = 0; i < tablet.rowSize; ++i) {
            index[i] = i;
        }
        Arrays.sort(index, Comparator.comparingLong(o -> tablet.timestamps[o]));
        Arrays.sort(tablet.timestamps, 0, tablet.rowSize);
        for (i = 0; i < tablet.getSchemas().size(); ++i) {
            tablet.values[i] = this.sortList(tablet.values[i], ((MeasurementSchema)tablet.getSchemas().get(i)).getType(), index);
        }
    }

    private Object sortList(Object valueList, TSDataType dataType, Integer[] index) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] sortedValues = new boolean[boolValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedValues[i] = boolValues[index[i]];
                }
                return sortedValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] sortedIntValues = new int[intValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedIntValues[i] = intValues[index[i]];
                }
                return sortedIntValues;
            }
            case INT64: {
                long[] longValues = (long[])valueList;
                long[] sortedLongValues = new long[longValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedLongValues[i] = longValues[index[i]];
                }
                return sortedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] sortedFloatValues = new float[floatValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedFloatValues[i] = floatValues[index[i]];
                }
                return sortedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] sortedDoubleValues = new double[doubleValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedDoubleValues[i] = doubleValues[index[i]];
                }
                return sortedDoubleValues;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] sortedBinaryValues = new Binary[binaryValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedBinaryValues[i] = binaryValues[index[i]];
                }
                return sortedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type:" + dataType);
    }
}

