/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.windowing;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.utils.windowing.configuration.SlidingSizeWindowConfiguration;
import org.apache.iotdb.db.utils.windowing.exception.WindowingException;
import org.apache.iotdb.db.utils.windowing.handler.SlidingSizeWindowEvaluationHandler;
import org.apache.iotdb.db.utils.windowing.window.EvictableBatchList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SlidingSizeWindowEvaluationHandlerTest {
    @Before
    public void setUp() throws Exception {
        EvictableBatchList.setInternalBatchSize((int)2);
    }

    @After
    public void tearDown() throws Exception {
        EvictableBatchList.setInternalBatchSize((int)1000000);
    }

    @Test
    public void test00() throws WindowingException {
        this.doTest(1, 1, 0);
    }

    @Test
    public void test01() throws WindowingException {
        this.doTest(1, 1, 1);
    }

    @Test
    public void test02() throws WindowingException {
        this.doTest(1, 1, 2);
    }

    @Test
    public void test03() throws WindowingException {
        this.doTest(1, 1, 5);
    }

    @Test
    public void test04() throws WindowingException {
        this.doTest(1, 2, 0);
    }

    @Test
    public void test05() throws WindowingException {
        this.doTest(1, 2, 1);
    }

    @Test
    public void test06() throws WindowingException {
        this.doTest(1, 2, 2);
    }

    @Test
    public void test07() throws WindowingException {
        this.doTest(1, 2, 5);
    }

    @Test
    public void test08() throws WindowingException {
        this.doTest(7, 2, 5);
    }

    @Test
    public void test09() throws WindowingException {
        this.doTest(7, 3, 7);
    }

    @Test
    public void test10() throws WindowingException {
        this.doTest(7, 3, 24);
    }

    @Test
    public void test11() throws WindowingException {
        this.doTest(7, 10, 75);
    }

    @Test
    public void test12() throws WindowingException {
        this.doTest(7, 10, 76);
    }

    @Test
    public void test13() throws WindowingException {
        this.doTest(7, 10, 77);
    }

    @Test
    public void test14() throws WindowingException {
        this.doTest(7, 7, 75);
    }

    @Test
    public void test15() throws WindowingException {
        this.doTest(7, 7, 76);
    }

    @Test
    public void test16() throws WindowingException {
        this.doTest(7, 7, 77);
    }

    private void doTest(int windowSize, int slidingStep, int totalPointNumber) throws WindowingException {
        AtomicInteger count = new AtomicInteger(0);
        ConcurrentHashMap actualTVMap = new ConcurrentHashMap();
        SlidingSizeWindowEvaluationHandler handler = new SlidingSizeWindowEvaluationHandler(new SlidingSizeWindowConfiguration(TSDataType.INT32, windowSize, slidingStep), window -> {
            for (int i = 0; i < window.size(); ++i) {
                actualTVMap.put((int)window.getTime(i), window.getInt(i));
            }
            count.incrementAndGet();
        });
        for (int i = 0; i < totalPointNumber; ++i) {
            handler.collect((long)i, i);
            handler.collect((long)i, i);
            handler.collect((long)(i - 1), i);
        }
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).until(() -> (totalPointNumber < windowSize ? 0 : 1 + (totalPointNumber - windowSize) / slidingStep) == count.get());
        ConcurrentHashMap<Integer, Integer> expectedTVMap = new ConcurrentHashMap<Integer, Integer>();
        int windowCount = count.get();
        block1: for (int i = 0; i < windowCount; ++i) {
            for (int j = 0; j < windowSize; ++j) {
                int tv = i * slidingStep + j;
                if (totalPointNumber <= tv) break block1;
                expectedTVMap.put(tv, tv);
            }
        }
        Assert.assertEquals(expectedTVMap, actualTVMap);
    }
}

