/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.sort;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.iotdb.db.utils.sort.DiskSpiller;
import org.apache.iotdb.db.utils.sort.FileSpillerReader;
import org.apache.iotdb.db.utils.sort.MemoryReader;
import org.apache.iotdb.db.utils.sort.SortBufferManager;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumn;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SortUtilTest {
    private static final String folderPath = "SORT_TEST";
    private static final String filePrefix = "SORT_TEST" + File.separator + "tmp";
    private int maxTsBlockSizeInBytes;

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        this.maxTsBlockSizeInBytes = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
        TSFileDescriptor.getInstance().getConfig().setMaxTsBlockSizeInBytes(200);
    }

    @After
    public void tearDown() {
        TSFileDescriptor.getInstance().getConfig().setMaxTsBlockSizeInBytes(this.maxTsBlockSizeInBytes);
    }

    private void clear() {
        File tmpDir = new File(folderPath);
        if (!tmpDir.exists()) {
            return;
        }
        FileUtils.deleteFileOrDirectory((File)tmpDir);
    }

    @Test
    public void diskSortTest() {
        MergeSortKey sortKey;
        int index;
        double[] values = new double[]{1.0, 2.0, 3.0, 5.0, 6.0, 8.0, 11.0, 13.0, 15.0, 17.0};
        double[] values2 = new double[]{4.0, 7.0, 9.0, 10.0, 12.0, 14.0, 16.0, 18.0, 19.0, 20.0};
        TimeColumn timeColumn = new TimeColumn(10, new long[]{1L, 2L, 3L, 5L, 6L, 8L, 11L, 13L, 15L, 17L});
        DoubleColumn column = new DoubleColumn(10, Optional.empty(), values);
        TimeColumn timeColumn2 = new TimeColumn(10, new long[]{4L, 7L, 9L, 10L, 12L, 14L, 16L, 18L, 19L, 20L});
        DoubleColumn column2 = new DoubleColumn(10, Optional.empty(), values2);
        TsBlock tsBlock = new TsBlock(timeColumn, new Column[]{column});
        TsBlock tsBlock2 = new TsBlock(timeColumn2, new Column[]{column2});
        DiskSpiller diskSpiller = new DiskSpiller(folderPath, filePrefix, Collections.singletonList(TSDataType.DOUBLE));
        ArrayList<SortKey> sortKeyList = new ArrayList<SortKey>();
        for (int i = 0; i < 10; ++i) {
            sortKeyList.add(new SortKey(tsBlock, i));
        }
        SortBufferManager sortBufferManager = new SortBufferManager();
        try {
            sortBufferManager.allocateOneSortBranch();
            diskSpiller.spillSortedData(sortKeyList);
            List sortReaders = diskSpiller.getReaders(sortBufferManager);
            Assert.assertTrue((sortReaders.size() == 1 && sortReaders.get(0) instanceof FileSpillerReader ? 1 : 0) != 0);
            FileSpillerReader fileSpillerReader = (FileSpillerReader)sortReaders.get(0);
            index = 0;
            while (fileSpillerReader.hasNext()) {
                sortKey = fileSpillerReader.next();
                Assert.assertEquals((double)sortKey.tsBlock.getColumn(0).getDouble(index), (double)values[index], (double)0.001);
                ++index;
            }
            fileSpillerReader.close();
            Assert.assertEquals((long)10L, (long)index);
        }
        catch (Exception e) {
            this.clear();
            Assert.fail((String)e.getMessage());
        }
        ArrayList<MergeSortKey> mergeSortKeyList = new ArrayList<MergeSortKey>();
        for (int i = 0; i < 10; ++i) {
            mergeSortKeyList.add(new MergeSortKey(tsBlock2, i));
        }
        MemoryReader memoryReader = new MemoryReader(mergeSortKeyList);
        try {
            index = 0;
            while (memoryReader.hasNext()) {
                sortKey = memoryReader.next();
                Assert.assertEquals((double)sortKey.tsBlock.getColumn(0).getDouble(index), (double)values2[index], (double)0.001);
                ++index;
            }
            memoryReader.close();
            Assert.assertEquals((long)10L, (long)index);
        }
        catch (Exception e) {
            this.clear();
            Assert.fail((String)e.getMessage());
        }
        this.clear();
    }
}

