/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.Assert;
import org.junit.Test;

public class PrimitiveArrayManagerTest {
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Test
    public void testGetArrayRowCount() {
        Assert.assertEquals((long)1224827L, (long)PrimitiveArrayManager.getArrayRowCount((int)(1224826 * PrimitiveArrayManager.ARRAY_SIZE + 1)));
        Assert.assertEquals((long)1224826L, (long)PrimitiveArrayManager.getArrayRowCount((int)(1224826 * PrimitiveArrayManager.ARRAY_SIZE)));
        Assert.assertEquals((long)1L, (long)PrimitiveArrayManager.getArrayRowCount((int)PrimitiveArrayManager.ARRAY_SIZE));
        Assert.assertEquals((long)1L, (long)PrimitiveArrayManager.getArrayRowCount((int)(PrimitiveArrayManager.ARRAY_SIZE - 1)));
        Assert.assertEquals((long)2L, (long)PrimitiveArrayManager.getArrayRowCount((int)(PrimitiveArrayManager.ARRAY_SIZE + 1)));
    }

    @Test
    public void testUpdateLimits() {
        double AMPLIFICATION_FACTOR = 1.5;
        double POOLED_ARRAYS_MEMORY_THRESHOLD = (double)this.config.getAllocateMemoryForStorageEngine() * this.config.getBufferedArraysMemoryProportion() / AMPLIFICATION_FACTOR;
        int totalDataTypeSize = 0;
        for (TSDataType dataType : TSDataType.values()) {
            if (dataType.equals((Object)TSDataType.VECTOR) || dataType.equals((Object)TSDataType.UNKNOWN)) continue;
            totalDataTypeSize += dataType.getDataTypeSize();
        }
        double limit = POOLED_ARRAYS_MEMORY_THRESHOLD / (double)PrimitiveArrayManager.ARRAY_SIZE / (double)totalDataTypeSize;
        int i = 0;
        while ((double)i < limit + 1.0) {
            block10: for (TSDataType type : TSDataType.values()) {
                if (type.equals((Object)TSDataType.VECTOR) || type.equals((Object)TSDataType.UNKNOWN)) continue;
                Object o = PrimitiveArrayManager.allocate((TSDataType)type);
                switch (type) {
                    case BOOLEAN: {
                        Assert.assertTrue((boolean)(o instanceof boolean[]));
                        Assert.assertEquals((long)PrimitiveArrayManager.ARRAY_SIZE, (long)((boolean[])o).length);
                        continue block10;
                    }
                    case INT32: {
                        Assert.assertTrue((boolean)(o instanceof int[]));
                        Assert.assertEquals((long)PrimitiveArrayManager.ARRAY_SIZE, (long)((int[])o).length);
                        continue block10;
                    }
                    case INT64: {
                        Assert.assertTrue((boolean)(o instanceof long[]));
                        Assert.assertEquals((long)PrimitiveArrayManager.ARRAY_SIZE, (long)((long[])o).length);
                        continue block10;
                    }
                    case FLOAT: {
                        Assert.assertTrue((boolean)(o instanceof float[]));
                        Assert.assertEquals((long)PrimitiveArrayManager.ARRAY_SIZE, (long)((float[])o).length);
                        continue block10;
                    }
                    case DOUBLE: {
                        Assert.assertTrue((boolean)(o instanceof double[]));
                        Assert.assertEquals((long)PrimitiveArrayManager.ARRAY_SIZE, (long)((double[])o).length);
                        continue block10;
                    }
                    case TEXT: {
                        Assert.assertTrue((boolean)(o instanceof Binary[]));
                        Assert.assertEquals((long)PrimitiveArrayManager.ARRAY_SIZE, (long)((Binary[])o).length);
                    }
                }
            }
            ++i;
        }
    }
}

