/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.MergeSortComparator;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.utils.datastructure.MergeSortHeap;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.Assert;
import org.junit.Test;

public class MergeSortHeapTest {
    @Test
    public void minHeapTest() {
        String device0 = "device_0";
        TsBlockBuilder inputBuilder1 = new TsBlockBuilder(Arrays.asList(TSDataType.TEXT, TSDataType.INT32));
        inputBuilder1.getTimeColumnBuilder().writeLong(2L);
        inputBuilder1.getColumnBuilder(0).writeBinary(new Binary(device0, TSFileConfig.STRING_CHARSET));
        inputBuilder1.getColumnBuilder(1).writeInt(20);
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(4L);
        inputBuilder1.getColumnBuilder(0).writeBinary(new Binary(device0, TSFileConfig.STRING_CHARSET));
        inputBuilder1.getColumnBuilder(1).writeInt(40);
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(5L);
        inputBuilder1.getColumnBuilder(0).writeBinary(new Binary(device0, TSFileConfig.STRING_CHARSET));
        inputBuilder1.getColumnBuilder(1).appendNull();
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(6L);
        inputBuilder1.getColumnBuilder(0).writeBinary(new Binary(device0, TSFileConfig.STRING_CHARSET));
        inputBuilder1.getColumnBuilder(1).writeInt(60);
        inputBuilder1.declarePosition();
        String device1 = "device_1";
        TsBlockBuilder inputBuilder2 = new TsBlockBuilder(Arrays.asList(TSDataType.TEXT, TSDataType.INT32));
        inputBuilder2.getTimeColumnBuilder().writeLong(1L);
        inputBuilder2.getColumnBuilder(0).writeBinary(new Binary(device1, TSFileConfig.STRING_CHARSET));
        inputBuilder2.getColumnBuilder(1).writeInt(10);
        inputBuilder2.declarePosition();
        inputBuilder2.getTimeColumnBuilder().writeLong(3L);
        inputBuilder2.getColumnBuilder(0).writeBinary(new Binary(device1, TSFileConfig.STRING_CHARSET));
        inputBuilder2.getColumnBuilder(1).writeInt(30);
        inputBuilder2.declarePosition();
        inputBuilder2.getTimeColumnBuilder().writeLong(7L);
        inputBuilder2.getColumnBuilder(0).writeBinary(new Binary(device1, TSFileConfig.STRING_CHARSET));
        inputBuilder2.getColumnBuilder(1).appendNull();
        inputBuilder2.declarePosition();
        inputBuilder2.getTimeColumnBuilder().writeLong(8L);
        inputBuilder2.getColumnBuilder(0).writeBinary(new Binary(device1, TSFileConfig.STRING_CHARSET));
        inputBuilder2.getColumnBuilder(1).writeInt(80);
        inputBuilder2.declarePosition();
        Comparator comparator = MergeSortComparator.getComparator(Arrays.asList(new SortItem("TIME", Ordering.ASC), new SortItem("DEVICE", Ordering.ASC)), Arrays.asList(-1, 0), Arrays.asList(TSDataType.INT64, TSDataType.TEXT));
        MergeSortHeap minHeap = new MergeSortHeap(2, comparator);
        minHeap.push(new MergeSortKey(inputBuilder1.build(), 0));
        minHeap.push(new MergeSortKey(inputBuilder2.build(), 0));
        MergeSortKey k = minHeap.poll();
        Assert.assertEquals((long)1L, (long)k.tsBlock.getTimeByIndex(k.rowIndex));
        Assert.assertEquals((Object)device1, (Object)k.tsBlock.getColumn(0).getBinary(k.rowIndex).toString());
        k = minHeap.poll();
        Assert.assertEquals((long)2L, (long)k.tsBlock.getTimeByIndex(k.rowIndex));
        Assert.assertEquals((Object)device0, (Object)k.tsBlock.getColumn(0).getBinary(k.rowIndex).toString());
        MergeSortHeap maxHeap = new MergeSortHeap(2, comparator.reversed());
        TsBlock tsBlock1 = inputBuilder1.build();
        TsBlock tsBlock2 = inputBuilder2.build();
        maxHeap.push(new MergeSortKey(tsBlock1, 0));
        maxHeap.push(new MergeSortKey(tsBlock2, 0));
        Assert.assertTrue((comparator.compare(new MergeSortKey(tsBlock2, 1), maxHeap.peek()) > 0 ? 1 : 0) != 0);
        k = maxHeap.poll();
        Assert.assertEquals((long)2L, (long)k.tsBlock.getTimeByIndex(k.rowIndex));
        Assert.assertEquals((Object)device0, (Object)k.tsBlock.getColumn(0).getBinary(k.rowIndex).toString());
        k = maxHeap.poll();
        Assert.assertEquals((long)1L, (long)k.tsBlock.getTimeByIndex(k.rowIndex));
        Assert.assertEquals((Object)device1, (Object)k.tsBlock.getColumn(0).getBinary(k.rowIndex).toString());
    }
}

