/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.junit.Assert;
import org.junit.Test;

public class AlignedTVListTest {
    @Test
    public void testAlignedTVList1() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 5; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        AlignedTVList tvList = AlignedTVList.newAlignedList(dataTypes);
        for (long i = 0L; i < 1000L; ++i) {
            Object[] value = new Object[5];
            for (int j = 0; j < 5; ++j) {
                value[j] = i;
            }
            tvList.putAlignedValue(i, value);
        }
        for (int i = 0; i < tvList.rowCount; ++i) {
            StringBuilder builder = new StringBuilder("[");
            builder.append(i);
            for (int j = 1; j < 5; ++j) {
                builder.append(", ").append(i);
            }
            builder.append("]");
            Assert.assertEquals((Object)builder.toString(), (Object)tvList.getAlignedValue(i).toString());
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testAlignedTVList2() {
        int i;
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        dataTypes.add(TSDataType.BOOLEAN);
        dataTypes.add(TSDataType.INT32);
        dataTypes.add(TSDataType.INT64);
        dataTypes.add(TSDataType.FLOAT);
        dataTypes.add(TSDataType.DOUBLE);
        dataTypes.add(TSDataType.TEXT);
        AlignedTVList tvList = AlignedTVList.newAlignedList(dataTypes);
        for (i = 1000; i >= 0; --i) {
            Object[] value = new Object[]{false, 100, 1000L, Float.valueOf(0.1f), 0.2, new Binary("Test", TSFileConfig.STRING_CHARSET)};
            tvList.putAlignedValue((long)i, value);
        }
        tvList.sort();
        for (i = 0; i < tvList.rowCount; ++i) {
            StringBuilder builder = new StringBuilder("[");
            builder.append("false, 100, 1000, 0.1, 0.2, Test");
            builder.append("]");
            Assert.assertEquals((Object)builder.toString(), (Object)tvList.getAlignedValue(i).toString());
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testAlignedTVLists() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 5; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        AlignedTVList tvList = AlignedTVList.newAlignedList(dataTypes);
        long[][] vectorArray = new long[5][1001];
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            for (int j = 0; j < 5; ++j) {
                vectorArray[j][i] = i;
            }
        }
        tvList.putAlignedValues(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), (Object[])vectorArray, null, 0, 1000);
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testAlignedTVListsWithBitMaps() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        BitMap[] bitMaps = new BitMap[5];
        for (int i = 0; i < 5; ++i) {
            dataTypes.add(TSDataType.INT64);
            bitMaps[i] = new BitMap(1001);
        }
        AlignedTVList tvList = AlignedTVList.newAlignedList(dataTypes);
        long[][] vectorArray = new long[5][1001];
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            for (int j = 0; j < 5; ++j) {
                vectorArray[j][i] = i;
                if (i % 100 != 0) continue;
                bitMaps[j].mark(i);
            }
        }
        tvList.putAlignedValues(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), (Object[])vectorArray, bitMaps, 0, 1000);
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getTime((int)i));
            if (i % 100L != 0L) continue;
            Assert.assertEquals((Object)"[null, null, null, null, null]", (Object)tvList.getAlignedValue((int)i).toString());
        }
    }

    @Test
    public void testClone() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        BitMap[] bitMaps = new BitMap[5];
        for (int i = 0; i < 5; ++i) {
            dataTypes.add(TSDataType.INT64);
            bitMaps[i] = new BitMap(1001);
        }
        AlignedTVList tvList = AlignedTVList.newAlignedList(dataTypes);
        long[][] vectorArray = new long[5][1001];
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            for (int j = 0; j < 5; ++j) {
                vectorArray[j][i] = i;
                if (i % 100 != 0) continue;
                bitMaps[j].mark(i);
            }
        }
        tvList.putAlignedValues(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), (Object[])vectorArray, bitMaps, 0, 1000);
        AlignedTVList clonedTvList = tvList.clone();
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)tvList.getTime((int)i), (long)clonedTvList.getTime((int)i));
            Assert.assertEquals((Object)tvList.getAlignedValue((int)i).toString(), (Object)clonedTvList.getAlignedValue((int)i).toString());
            int column = 0;
            while (i < 5L) {
                Assert.assertEquals((Object)tvList.isNullValue((int)i, column), (Object)clonedTvList.isNullValue((int)i, column));
                ++i;
            }
        }
        for (int i = 0; i < dataTypes.size(); ++i) {
            Assert.assertEquals((long)tvList.memoryBinaryChunkSize[i], (long)clonedTvList.memoryBinaryChunkSize[i]);
        }
    }

    @Test
    public void testCalculateChunkSize() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        dataTypes.add(TSDataType.INT32);
        dataTypes.add(TSDataType.TEXT);
        AlignedTVList tvList = AlignedTVList.newAlignedList(dataTypes);
        for (int i = 0; i < 10; ++i) {
            Object[] value = new Object[]{i, new Binary(String.valueOf(i), TSFileConfig.STRING_CHARSET)};
            tvList.putAlignedValue((long)i, value);
        }
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[0], (long)0L);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[1], (long)360L);
        Object[] vectorArray = new Object[2];
        BitMap[] bitMaps = new BitMap[2];
        vectorArray[0] = new int[10];
        vectorArray[1] = new Binary[10];
        bitMaps[0] = new BitMap(10);
        bitMaps[1] = new BitMap(10);
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (int i = 0; i < 10; ++i) {
            timeList.add((long)i + 10L);
            ((int[])vectorArray[0])[i] = i;
            ((Binary[])vectorArray[1])[i] = new Binary(String.valueOf(i), TSFileConfig.STRING_CHARSET);
            if (i % 2 != 0) continue;
            bitMaps[1].mark(i);
        }
        tvList.putAlignedValues(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), vectorArray, bitMaps, 0, 10);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[1], (long)720L);
        tvList.delete(5L, 15L);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[1], (long)324L);
        tvList.deleteColumn(0);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize.length, (long)1L);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[0], (long)324L);
        tvList.extendColumn(TSDataType.INT32);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize.length, (long)2L);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[0], (long)324L);
        tvList.extendColumn(TSDataType.TEXT);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize.length, (long)3L);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[0], (long)324L);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[2], (long)0L);
        tvList.delete(4L, 6L);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize.length, (long)3L);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[0], (long)216L);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[2], (long)0L);
        tvList.clear();
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[0], (long)0L);
        Assert.assertEquals((long)tvList.memoryBinaryChunkSize[2], (long)0L);
    }
}

