/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.Assert;
import org.junit.Test;

public class TypeInferenceUtilsTest {
    @Test
    public void isNumberTest() {
        String[] values = new String[]{"123", "123.123", "-123.123", "+123.123", ".123", String.valueOf(Integer.MAX_VALUE), String.valueOf(Integer.MIN_VALUE), String.valueOf(Double.MAX_VALUE), String.valueOf(Double.MIN_VALUE), "abc", "123.", "123a", ".", "123.1.23", "77123 ", " 7112324 "};
        boolean[] results = new boolean[]{true, true, true, true, true, true, true, true, true, false, true, false, false, false, true, true};
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)TypeInferenceUtils.isNumber((String)values[i]), (Object)results[i]);
        }
    }

    @Test
    public void testInferType() throws QueryProcessException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        Object[] values = new Object[]{123, "abc", 123.123, true, Float.valueOf(123.1f), "123", "12.2", "9999999999999999", "true", "77123 ", " 7112324 ", "16777217", "16777216", "271840880000000000000000", "4.9387406015404442E17", "4E5", "1.0"};
        TSDataType[] inferredTypes = new TSDataType[]{TSDataType.INT32, TSDataType.TEXT, TSDataType.DOUBLE, TSDataType.BOOLEAN, TSDataType.FLOAT, config.getIntegerStringInferType(), config.getFloatingStringInferType(), config.getIntegerStringInferType(), config.getBooleanStringInferType(), config.getIntegerStringInferType(), config.getIntegerStringInferType(), config.getIntegerStringInferType(), config.getIntegerStringInferType(), config.getFloatingStringInferType(), config.getFloatingStringInferType(), config.getFloatingStringInferType(), config.getFloatingStringInferType()};
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)inferredTypes[i], (Object)TypeInferenceUtils.getPredictedDataType((Object)values[i], (boolean)true));
        }
    }

    @Test
    public void testNotInferType() {
        Object[] values = new Object[]{123, "abc", 123.123, true, Float.valueOf(123.1f), "123", "12.2", "true"};
        TSDataType[] encodings = new TSDataType[]{TSDataType.INT32, TSDataType.TEXT, TSDataType.DOUBLE, TSDataType.BOOLEAN, TSDataType.FLOAT, TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT};
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((Object)encodings[i], (Object)TypeInferenceUtils.getPredictedDataType((Object)values[i], (boolean)false));
        }
    }
}

