/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.junit.Assert;
import org.junit.Test;

public class TimestampPrecisionUtilsTest {
    @Test
    public void testCheckMsTimestampPrecision() {
        TimestampPrecisionUtils.TIMESTAMP_PRECISION = "ms";
        try {
            TimestampPrecisionUtils.checkTimestampPrecision((long)-1L);
            TimestampPrecisionUtils.checkTimestampPrecision((long)0L);
            TimestampPrecisionUtils.checkTimestampPrecision((long)1694689856546L);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCheckIllegalMsTimestampPrecision() {
        TimestampPrecisionUtils.TIMESTAMP_PRECISION = "ms";
        try {
            TimestampPrecisionUtils.checkTimestampPrecision((long)1694689856546000L);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCheckUsTimestampPrecision() {
        TimestampPrecisionUtils.TIMESTAMP_PRECISION = "us";
        try {
            TimestampPrecisionUtils.checkTimestampPrecision((long)-1L);
            TimestampPrecisionUtils.checkTimestampPrecision((long)0L);
            TimestampPrecisionUtils.checkTimestampPrecision((long)1694689856546L);
            TimestampPrecisionUtils.checkTimestampPrecision((long)1694689856546000L);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCheckIllegalUsTimestampPrecision() {
        TimestampPrecisionUtils.TIMESTAMP_PRECISION = "us";
        try {
            TimestampPrecisionUtils.checkTimestampPrecision((long)1694689856546000000L);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCheckNsTimestampPrecision() {
        TimestampPrecisionUtils.TIMESTAMP_PRECISION = "ns";
        try {
            TimestampPrecisionUtils.checkTimestampPrecision((long)-1L);
            TimestampPrecisionUtils.checkTimestampPrecision((long)0L);
            TimestampPrecisionUtils.checkTimestampPrecision((long)1694689856546L);
            TimestampPrecisionUtils.checkTimestampPrecision((long)1694689856546000L);
            TimestampPrecisionUtils.checkTimestampPrecision((long)1694689856546000000L);
            TimestampPrecisionUtils.checkTimestampPrecision((long)Long.MAX_VALUE);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

