/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Test;

public class SchemaUtilsTest {
    @Test
    public void getAggregatedDataTypesTest() {
        ArrayList<TSDataType> measurementTypes = new ArrayList<TSDataType>();
        measurementTypes.add(TSDataType.INT64);
        measurementTypes.add(TSDataType.TEXT);
        measurementTypes.add(TSDataType.BOOLEAN);
        measurementTypes.add(TSDataType.DOUBLE);
        Assert.assertEquals(Collections.nCopies(measurementTypes.size(), TSDataType.INT64), (Object)SchemaUtils.getAggregatedDataTypes(measurementTypes, (String)"min_time"));
        Assert.assertEquals(Collections.nCopies(measurementTypes.size(), TSDataType.INT64), (Object)SchemaUtils.getAggregatedDataTypes(measurementTypes, (String)"count"));
        Assert.assertEquals(Collections.nCopies(measurementTypes.size(), TSDataType.DOUBLE), (Object)SchemaUtils.getAggregatedDataTypes(measurementTypes, (String)"sum"));
        Assert.assertEquals(measurementTypes, (Object)SchemaUtils.getAggregatedDataTypes(measurementTypes, (String)"last_value"));
        Assert.assertEquals(measurementTypes, (Object)SchemaUtils.getAggregatedDataTypes(measurementTypes, (String)"max_value"));
    }

    @Test
    public void getSeriesTypeByPath() throws IllegalPathException {
        MeasurementPath measurementPath = new MeasurementPath("s1", TSDataType.INT64);
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)SchemaUtils.getSeriesTypeByPath((PartialPath)measurementPath, (String)"sum"));
        Assert.assertEquals((Object)TSDataType.INT64, (Object)SchemaUtils.getSeriesTypeByPath((PartialPath)measurementPath, (String)"last_value"));
    }

    @Test
    public void checkDataTypeWithEncoding() {
        try {
            SchemaUtils.checkDataTypeWithEncoding((TSDataType)TSDataType.TEXT, (TSEncoding)TSEncoding.RLE);
            Assert.fail((String)"expect exception");
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }
}

