/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegionPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.tools.schema.SRStatementGenerator;
import org.apache.iotdb.db.tools.schema.SchemaRegionSnapshotParser;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SchemaRegionSnapshotParserTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private SchemaRegionSnapshotParserTestParams rawConfig;
    protected final SchemaRegionSnapshotParserTestParams testParams;
    private String snapshotFileName;

    @Parameterized.Parameters(name="{0}")
    public static List<SchemaRegionSnapshotParserTestParams> getTestModes() {
        return Arrays.asList(new SchemaRegionSnapshotParserTestParams("MemoryMode", "Memory"), new SchemaRegionSnapshotParserTestParams("PBTree", "PBTree"));
    }

    @Before
    public void setUp() throws Exception {
        this.rawConfig = new SchemaRegionSnapshotParserTestParams("Raw-Config", COMMON_CONFIG.getSchemaEngineMode());
        COMMON_CONFIG.setSchemaEngineMode(this.testParams.schemaRegionMode);
        SchemaEngine.getInstance().init();
        if (this.testParams.schemaRegionMode.equals("Memory")) {
            this.snapshotFileName = "mtree.snapshot";
        } else if (this.testParams.schemaRegionMode.equals("PBTree")) {
            this.snapshotFileName = "pbtree.pst.snapshot";
        }
    }

    @After
    public void tearDown() throws Exception {
        SchemaEngine.getInstance().clear();
        this.cleanEnv();
        COMMON_CONFIG.setSchemaEngineMode(this.rawConfig.schemaRegionMode);
    }

    protected void cleanEnv() throws IOException {
        FileUtils.deleteDirectory((File)new File(IoTDBDescriptor.getInstance().getConfig().getSchemaDir()));
    }

    public SchemaRegionSnapshotParserTest(SchemaRegionSnapshotParserTestParams params) {
        this.testParams = params;
    }

    public ISchemaRegion getSchemaRegion(String database, int schemaRegionId) throws Exception {
        SchemaRegionId regionId = new SchemaRegionId(schemaRegionId);
        if (SchemaEngine.getInstance().getSchemaRegion(regionId) == null) {
            SchemaEngine.getInstance().createSchemaRegion(new PartialPath(database), regionId);
        }
        return SchemaEngine.getInstance().getSchemaRegion(regionId);
    }

    @Test
    public void testSimpleTranslateSnapshot() throws Exception {
        if (this.testParams.testModeName.equals("PBTree")) {
            return;
        }
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        PartialPath databasePath = new PartialPath("root.sg");
        HashMap<String, ICreateTimeSeriesPlan> planMap = new HashMap<String, ICreateTimeSeriesPlan>();
        planMap.put("root.sg.s1.g1.temp", SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.s1.g1.temp"), (TSDataType)TSDataType.FLOAT, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.SNAPPY, null, null, null, null));
        planMap.put("root.sg.s1.g1.status", SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.s1.g1.status"), (TSDataType)TSDataType.INT64, (TSEncoding)TSEncoding.TS_2DIFF, (CompressionType)CompressionType.LZ4, null, null, null, null));
        planMap.put("root.sg.s2.g2.t2.temp", SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.s2.g2.t2.temp"), (TSDataType)TSDataType.DOUBLE, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.GZIP, null, null, null, null));
        planMap.put("root.sg.s2.g4.status", SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.s2.g4.status"), (TSDataType)TSDataType.INT64, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.ZSTD, null, null, null, null));
        planMap.put("root.sg.s2.g5.level", SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.s2.g5.level"), (TSDataType)TSDataType.INT32, (TSEncoding)TSEncoding.GORILLA, (CompressionType)CompressionType.LZMA2, null, null, null, null));
        for (ICreateTimeSeriesPlan plan : planMap.values()) {
            schemaRegion.createTimeseries(plan, -1L);
        }
        File snapshotDir = new File(config.getSchemaDir() + File.separator + "snapshot");
        snapshotDir.mkdir();
        schemaRegion.createSnapshot(snapshotDir);
        SRStatementGenerator statements = SchemaRegionSnapshotParser.translate2Statements((Path)Paths.get(config.getSchemaDir() + File.separator + "snapshot" + File.separator + this.snapshotFileName, new String[0]), null, (PartialPath)databasePath);
        assert (statements != null);
        for (Statement stmt : statements) {
            CreateTimeSeriesStatement createTimeSeriesStatement = (CreateTimeSeriesStatement)stmt;
            ICreateTimeSeriesPlan plan = (ICreateTimeSeriesPlan)planMap.get(((PartialPath)createTimeSeriesStatement.getPaths().get(0)).toString());
            Assert.assertEquals((Object)plan.getEncoding(), (Object)createTimeSeriesStatement.getEncoding());
            Assert.assertEquals((Object)plan.getCompressor(), (Object)createTimeSeriesStatement.getCompressor());
            Assert.assertEquals((Object)plan.getDataType(), (Object)createTimeSeriesStatement.getDataType());
            Assert.assertEquals((Object)plan.getAlias(), (Object)createTimeSeriesStatement.getAlias());
            Assert.assertEquals((Object)plan.getProps(), (Object)createTimeSeriesStatement.getProps());
            Assert.assertEquals((Object)plan.getAttributes(), (Object)createTimeSeriesStatement.getAttributes());
            Assert.assertEquals((Object)plan.getTags(), (Object)createTimeSeriesStatement.getTags());
        }
        statements.checkException();
    }

    @Test
    public void testAlignedTimeseriesTranslateSnapshot() throws Exception {
        if (this.testParams.testModeName.equals("PBTree")) {
            return;
        }
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        PartialPath database = new PartialPath("root.sg");
        ICreateAlignedTimeSeriesPlan plan = SchemaRegionWritePlanFactory.getCreateAlignedTimeSeriesPlan((PartialPath)new PartialPath("root.sg.t1.t2"), Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.INT32, TSDataType.INT64, TSDataType.BOOLEAN), Arrays.asList(TSEncoding.PLAIN, TSEncoding.RLE, TSEncoding.PLAIN), Arrays.asList(CompressionType.SNAPPY, CompressionType.LZ4, CompressionType.UNCOMPRESSED), Arrays.asList("alias1", "alias2", null), Arrays.asList(new HashMap<String, String>(){
            {
                this.put("tag1", "t1");
                this.put("tag_1", "value2");
            }
        }, new HashMap<String, String>(){
            {
                this.put("tag2", "t2");
                this.put("tag_2", "t_2");
            }
        }, new HashMap()), Arrays.asList(new HashMap<String, String>(){
            {
                this.put("attr1", "a1");
                this.put("attr_1", "a_1");
            }
        }, new HashMap<String, String>(){
            {
                this.put("attr2", "a2");
            }
        }, new HashMap<String, String>(){
            {
                this.put("tag2", "t2");
                this.put("tag_2", "t_2");
            }
        }));
        schemaRegion.createAlignedTimeSeries(plan);
        File snapshotDir = new File(config.getSchemaDir() + File.separator + "snapshot");
        snapshotDir.mkdir();
        schemaRegion.createSnapshot(snapshotDir);
        SRStatementGenerator statements = SchemaRegionSnapshotParser.translate2Statements((Path)Paths.get(config.getSchemaDir() + File.separator + "snapshot" + File.separator + this.snapshotFileName, new String[0]), (Path)Paths.get(config.getSchemaDir() + File.separator + "snapshot" + File.separator + "tlog.txt.snapshot", new String[0]), (PartialPath)database);
        assert (statements != null);
        for (Statement stmt : statements) {
            CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement = (CreateAlignedTimeSeriesStatement)stmt;
            Assert.assertEquals((Object)plan.getDevicePath(), (Object)createAlignedTimeSeriesStatement.getDevicePath());
            Assert.assertEquals((long)plan.getTagsList().size(), (long)createAlignedTimeSeriesStatement.getTagsList().size());
            Assert.assertEquals((long)plan.getAliasList().size(), (long)createAlignedTimeSeriesStatement.getAliasList().size());
            Assert.assertEquals((long)plan.getAttributesList().size(), (long)createAlignedTimeSeriesStatement.getAttributesList().size());
            Assert.assertEquals((long)createAlignedTimeSeriesStatement.getMeasurements().size(), (long)createAlignedTimeSeriesStatement.getAttributesList().size());
            Assert.assertEquals((long)createAlignedTimeSeriesStatement.getMeasurements().size(), (long)createAlignedTimeSeriesStatement.getTagsList().size());
            Comparator<Map<String, String>> comp = new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> o1, Map<String, String> o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return Integer.compare(o1.hashCode(), o2.hashCode());
                }
            };
            Comparator<String> comp_str = new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return Integer.compare(o1.hashCode(), o2.hashCode());
                }
            };
            Collections.sort(plan.getAliasList(), comp_str);
            Collections.sort(createAlignedTimeSeriesStatement.getAliasList(), comp_str);
            Collections.sort(plan.getAttributesList(), comp);
            Collections.sort(createAlignedTimeSeriesStatement.getAttributesList(), comp);
            Collections.sort(plan.getMeasurements(), comp_str);
            Collections.sort(createAlignedTimeSeriesStatement.getMeasurements(), comp_str);
            Collections.sort(plan.getTagsList(), comp);
            Collections.sort(createAlignedTimeSeriesStatement.getTagsList(), comp);
            Collections.sort(plan.getEncodings());
            Collections.sort(createAlignedTimeSeriesStatement.getEncodings());
            Collections.sort(plan.getCompressors());
            Collections.sort(createAlignedTimeSeriesStatement.getCompressors());
            Collections.sort(plan.getDataTypes());
            Collections.sort(createAlignedTimeSeriesStatement.getDataTypes());
            Assert.assertEquals((Object)plan.getMeasurements(), (Object)createAlignedTimeSeriesStatement.getMeasurements());
            Assert.assertEquals((Object)plan.getAliasList(), (Object)createAlignedTimeSeriesStatement.getAliasList());
            Assert.assertEquals((Object)plan.getEncodings(), (Object)createAlignedTimeSeriesStatement.getEncodings());
            Assert.assertEquals((Object)plan.getCompressors(), (Object)createAlignedTimeSeriesStatement.getCompressors());
            Assert.assertEquals((Object)plan.getAttributesList(), (Object)createAlignedTimeSeriesStatement.getAttributesList());
            Assert.assertEquals((Object)plan.getTagsList(), (Object)createAlignedTimeSeriesStatement.getTagsList());
        }
        statements.checkException();
    }

    @Test
    public void testTemplateActivateTranslateSnapshot() throws Exception {
        if (this.testParams.testModeName.equals("PBTree")) {
            return;
        }
        ISchemaRegion schemaRegion = this.getSchemaRegion("root.sg", 0);
        PartialPath databasePath = new PartialPath("root.sg");
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.s1.g1.temp"), (TSDataType)TSDataType.FLOAT, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.SNAPPY, null, null, null, null), 0L);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.s1.g3.temp"), (TSDataType)TSDataType.FLOAT, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.SNAPPY, null, null, null, null), 0L);
        schemaRegion.createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg.s2.g1.temp"), (TSDataType)TSDataType.FLOAT, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.SNAPPY, null, null, null, null), 0L);
        Template template = new Template("t1", Collections.singletonList("s1"), Collections.singletonList(TSDataType.INT64), Collections.singletonList(TSEncoding.PLAIN), Collections.singletonList(CompressionType.GZIP));
        template.setId(0);
        HashMap<String, IActivateTemplateInClusterPlan> planMap = new HashMap<String, IActivateTemplateInClusterPlan>();
        IActivateTemplateInClusterPlan plan1 = SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.s2"), (int)1, (int)template.getId());
        IActivateTemplateInClusterPlan plan2 = SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg.s3"), (int)1, (int)template.getId());
        planMap.put("root.sg.s2", plan1);
        planMap.put("root.sg.s3", plan2);
        schemaRegion.activateSchemaTemplate(plan1, template);
        schemaRegion.activateSchemaTemplate(plan2, template);
        File snapshotDir = new File(config.getSchemaDir() + File.separator + "snapshot");
        snapshotDir.mkdir();
        schemaRegion.createSnapshot(snapshotDir);
        SRStatementGenerator statements = SchemaRegionSnapshotParser.translate2Statements((Path)Paths.get(config.getSchemaDir() + File.separator + "snapshot" + File.separator + this.snapshotFileName, new String[0]), null, (PartialPath)databasePath);
        int count = 0;
        assert (statements != null);
        for (Statement stmt : statements) {
            if (!(stmt instanceof ActivateTemplateStatement)) continue;
            ActivateTemplateStatement ATStatement = (ActivateTemplateStatement)stmt;
            IActivateTemplateInClusterPlan plan = (IActivateTemplateInClusterPlan)planMap.get(ATStatement.getPath().toString());
            Assert.assertEquals((Object)plan.getActivatePath(), (Object)ATStatement.getPath());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        statements.checkException();
    }

    @Test
    public void testComplicatedSnapshotParser() throws Exception {
        if (this.testParams.testModeName.equals("PBTree")) {
            return;
        }
        ISchemaRegion schemaRegion = this.getSchemaRegion("root", 0);
        PartialPath databasePath = new PartialPath("root");
        Template template = new Template();
        template.setId(1);
        template.addMeasurement("date", TSDataType.INT64, TSEncoding.RLE, CompressionType.UNCOMPRESSED);
        HashMap<String, Object> planMap = new HashMap<String, Object>();
        planMap.put("root.sg1.s1.t1", SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan((PartialPath)new PartialPath("root.sg1.s1.t1"), (int)3, (int)1));
        planMap.put("root.sg1.s1.t2.temperature", SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg1.s1.t2.temperature"), (TSDataType)TSDataType.INT64, (TSEncoding)TSEncoding.TS_2DIFF, (CompressionType)CompressionType.LZ4, null, null, null, null));
        planMap.put("root.sg1.s1.t2.status", SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg1.s1.t2.status"), (TSDataType)TSDataType.BOOLEAN, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.SNAPPY, null, null, null, (String)"statusA"));
        planMap.put("root.sg2.t1", SchemaRegionWritePlanFactory.getCreateAlignedTimeSeriesPlan((PartialPath)new PartialPath("root.sg2.t1"), (List)new ArrayList<String>(){
            {
                this.add("status");
            }
        }, (List)new ArrayList<TSDataType>(){
            {
                this.add(TSDataType.INT64);
            }
        }, (List)new ArrayList<TSEncoding>(){
            {
                this.add(TSEncoding.TS_2DIFF);
            }
        }, (List)new ArrayList<CompressionType>(){
            {
                this.add(CompressionType.SNAPPY);
            }
        }, (List)new ArrayList<String>(){
            {
                this.add("stat");
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap());
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("attr1", "a1");
                    }
                });
            }
        }));
        planMap.put("root.sg2.t2.level", SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg2.t2.level"), (TSDataType)TSDataType.INT64, (TSEncoding)TSEncoding.RLE, (CompressionType)CompressionType.UNCOMPRESSED, null, (Map)new HashMap<String, String>(){
            {
                this.put("tag1", "t1");
            }
        }, (Map)new HashMap<String, String>(){
            {
                this.put("attri1", "atr1");
            }
        }, null));
        planMap.put("root.sg2.t2.t1", SchemaRegionWritePlanFactory.getCreateAlignedTimeSeriesPlan((PartialPath)new PartialPath("root.sg2.t2.t1"), (List)new ArrayList<String>(){
            {
                this.add("temperature");
                this.add("level");
            }
        }, (List)new ArrayList<TSDataType>(){
            {
                this.add(TSDataType.INT64);
                this.add(TSDataType.INT32);
            }
        }, (List)new ArrayList<TSEncoding>(){
            {
                this.add(TSEncoding.RLE);
                this.add(TSEncoding.RLE);
            }
        }, (List)new ArrayList<CompressionType>(){
            {
                this.add(CompressionType.SNAPPY);
                this.add(CompressionType.UNCOMPRESSED);
            }
        }, (List)new ArrayList<String>(){
            {
                this.add(null);
                this.add("lev");
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap());
                this.add(new HashMap<String, String>(){
                    {
                        this.put("tag1", "t1");
                    }
                });
            }
        }, (List)new ArrayList<Map<String, String>>(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("attr1", "a1");
                    }
                });
                this.add(new HashMap());
            }
        }));
        for (ISchemaRegionPlan plan : planMap.values()) {
            if (plan instanceof ICreateTimeSeriesPlan) {
                schemaRegion.createTimeseries((ICreateTimeSeriesPlan)plan, -1L);
                continue;
            }
            if (plan instanceof ICreateAlignedTimeSeriesPlan) {
                schemaRegion.createAlignedTimeSeries((ICreateAlignedTimeSeriesPlan)plan);
                continue;
            }
            if (!(plan instanceof IActivateTemplateInClusterPlan)) continue;
            schemaRegion.activateSchemaTemplate((IActivateTemplateInClusterPlan)plan, template);
        }
        File snapshotDir = new File(config.getSchemaDir() + File.separator + "snapshot");
        snapshotDir.mkdir();
        schemaRegion.createSnapshot(snapshotDir);
        SRStatementGenerator statements = SchemaRegionSnapshotParser.translate2Statements((Path)Paths.get(config.getSchemaDir() + File.separator + "snapshot" + File.separator + this.snapshotFileName, new String[0]), (Path)Paths.get(config.getSchemaDir() + File.separator + "snapshot" + File.separator + "tlog.txt.snapshot", new String[0]), (PartialPath)databasePath);
        assert (statements != null);
        int count = 0;
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.compareTo(o2);
            }
        };
        for (Statement stmt : statements) {
            ICreateAlignedTimeSeriesPlan plan;
            if (stmt instanceof CreateAlignedTimeSeriesStatement) {
                CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement = (CreateAlignedTimeSeriesStatement)stmt;
                plan = (ICreateAlignedTimeSeriesPlan)planMap.get(createAlignedTimeSeriesStatement.getDevicePath().toString());
                Assert.assertNotNull((Object)plan);
                Collections.sort(plan.getMeasurements());
                Collections.sort(createAlignedTimeSeriesStatement.getMeasurements());
                Assert.assertEquals((Object)plan.getMeasurements(), (Object)createAlignedTimeSeriesStatement.getMeasurements());
                Collections.sort(plan.getAliasList(), comparator);
                Collections.sort(createAlignedTimeSeriesStatement.getAliasList(), comparator);
                Assert.assertEquals((Object)plan.getAliasList(), (Object)createAlignedTimeSeriesStatement.getAliasList());
                Assert.assertEquals((Object)plan.getEncodings(), (Object)createAlignedTimeSeriesStatement.getEncodings());
                Collections.sort(plan.getCompressors());
                Collections.sort(createAlignedTimeSeriesStatement.getCompressors());
                Assert.assertEquals((Object)plan.getCompressors(), (Object)createAlignedTimeSeriesStatement.getCompressors());
                Assert.assertEquals((long)plan.getAttributesList().size(), (long)createAlignedTimeSeriesStatement.getAttributesList().size());
                Assert.assertEquals((long)plan.getTagsList().size(), (long)createAlignedTimeSeriesStatement.getTagsList().size());
            } else if (stmt instanceof CreateTimeSeriesStatement) {
                CreateTimeSeriesStatement createTimeSeriesStatement = (CreateTimeSeriesStatement)stmt;
                plan = (ICreateTimeSeriesPlan)planMap.get(createTimeSeriesStatement.getPath().toString());
                Assert.assertNotNull((Object)plan);
                Assert.assertEquals((Object)plan.getEncoding(), (Object)createTimeSeriesStatement.getEncoding());
                Assert.assertEquals((Object)plan.getCompressor(), (Object)createTimeSeriesStatement.getCompressor());
                Assert.assertEquals((Object)plan.getDataType(), (Object)createTimeSeriesStatement.getDataType());
                Assert.assertEquals((Object)plan.getAlias(), (Object)createTimeSeriesStatement.getAlias());
                Assert.assertEquals((Object)plan.getProps(), (Object)createTimeSeriesStatement.getProps());
                Assert.assertEquals((Object)plan.getAttributes(), (Object)createTimeSeriesStatement.getAttributes());
                Assert.assertEquals((Object)plan.getTags(), (Object)createTimeSeriesStatement.getTags());
            } else if (stmt instanceof ActivateTemplateStatement) {
                ActivateTemplateStatement activateTemplateStatement = (ActivateTemplateStatement)stmt;
                plan = (IActivateTemplateInClusterPlan)planMap.get(activateTemplateStatement.getPath().toString());
                Assert.assertNotNull((Object)plan);
            }
            ++count;
        }
        Assert.assertEquals((long)planMap.size(), (long)count);
        statements.checkException();
    }

    protected static class SchemaRegionSnapshotParserTestParams {
        private final String testModeName;
        private final String schemaRegionMode;

        private SchemaRegionSnapshotParserTestParams(String testModeName, String schemaEngineMode) {
            this.testModeName = testModeName;
            this.schemaRegionMode = schemaEngineMode;
        }

        public String getTestModeName() {
            return this.testModeName;
        }

        public String getSchemaRegionMode() {
            return this.schemaRegionMode;
        }

        public String toString() {
            return this.testModeName;
        }
    }
}

