/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class QueryDataSetUtilsTest {
    private static final String BINARY_STR = "ty love zm";

    @Test
    public void testConvertTsBlockByFetchSize() throws IoTDBException, IOException {
        Pair res = QueryDataSetUtils.convertTsBlockByFetchSize((IQueryExecution)this.buildQueryExecution(), (int)10);
        this.compareRes((Pair<TSQueryDataSet, Boolean>)res);
    }

    private IQueryExecution buildQueryExecution() throws IoTDBException, IOException {
        IQueryExecution queryExecution = (IQueryExecution)Mockito.mock(IQueryExecution.class);
        Mockito.when((Object)queryExecution.getOutputValueColumnCount()).thenReturn((Object)6);
        TsBlockBuilder builder = new TsBlockBuilder(Arrays.asList(TSDataType.BOOLEAN, TSDataType.INT32, TSDataType.INT64, TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.TEXT));
        builder.getTimeColumnBuilder().writeLong(1L);
        builder.getColumnBuilder(0).writeBoolean(true);
        builder.getColumnBuilder(1).writeInt(1);
        builder.getColumnBuilder(2).writeLong(1L);
        builder.getColumnBuilder(3).writeFloat(1.1f);
        builder.getColumnBuilder(4).appendNull();
        builder.getColumnBuilder(5).writeBinary(new Binary(BINARY_STR, TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
        builder.getTimeColumnBuilder().writeLong(2L);
        builder.getColumnBuilder(0).appendNull();
        builder.getColumnBuilder(1).appendNull();
        builder.getColumnBuilder(2).appendNull();
        builder.getColumnBuilder(3).appendNull();
        builder.getColumnBuilder(4).writeDouble(3.14);
        builder.getColumnBuilder(5).appendNull();
        builder.declarePosition();
        Mockito.when((Object)queryExecution.getBatchResult()).thenReturn(Optional.of(builder.build()), (Object[])new Optional[]{Optional.empty()});
        Mockito.when((Object)queryExecution.getByteBufferBatchResult()).thenReturn(Optional.of(new TsBlockSerde().serialize(builder.build())), (Object[])new Optional[]{Optional.empty()});
        return queryExecution;
    }

    private void compareRes(Pair<TSQueryDataSet, Boolean> res) {
        double delta = 1.0E-5;
        Assert.assertEquals((Object)true, (Object)res.right);
        Assert.assertEquals((long)16L, (long)((TSQueryDataSet)res.left).time.limit());
        Assert.assertEquals((long)1L, (long)((TSQueryDataSet)res.left).time.getLong());
        Assert.assertEquals((long)2L, (long)((TSQueryDataSet)res.left).time.getLong());
        Assert.assertEquals((long)6L, (long)((TSQueryDataSet)res.left).valueList.size());
        Assert.assertEquals((long)6L, (long)((TSQueryDataSet)res.left).bitmapList.size());
        Assert.assertEquals((long)1L, (long)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(0)).limit());
        Assert.assertEquals((long)1L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(0)).limit());
        Assert.assertEquals((long)1L, (long)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(0)).get());
        Assert.assertEquals((long)-128L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(0)).get());
        Assert.assertEquals((long)4L, (long)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(1)).limit());
        Assert.assertEquals((long)1L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(1)).limit());
        Assert.assertEquals((long)1L, (long)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(1)).getInt());
        Assert.assertEquals((long)-128L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(1)).get());
        Assert.assertEquals((long)8L, (long)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(2)).limit());
        Assert.assertEquals((long)1L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(2)).limit());
        Assert.assertEquals((long)1L, (long)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(2)).getLong());
        Assert.assertEquals((long)-128L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(2)).get());
        Assert.assertEquals((long)4L, (long)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(3)).limit());
        Assert.assertEquals((long)1L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(3)).limit());
        Assert.assertEquals((double)1.1f, (double)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(3)).getFloat(), (double)1.0E-5);
        Assert.assertEquals((long)-128L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(3)).get());
        Assert.assertEquals((long)8L, (long)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(4)).limit());
        Assert.assertEquals((long)1L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(4)).limit());
        Assert.assertEquals((double)3.14, (double)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(4)).getDouble(), (double)1.0E-5);
        Assert.assertEquals((long)64L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(4)).get());
        Assert.assertEquals((long)1L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(5)).limit());
        Assert.assertEquals((long)14L, (long)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(5)).limit());
        Assert.assertEquals((long)10L, (long)((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(5)).getInt());
        byte[] bytes = new byte[10];
        ((ByteBuffer)((TSQueryDataSet)res.left).valueList.get(5)).get(bytes);
        Assert.assertEquals((Object)BINARY_STR, (Object)new String(bytes));
        Assert.assertEquals((long)-128L, (long)((ByteBuffer)((TSQueryDataSet)res.left).bitmapList.get(5)).get());
    }

    @Test
    public void testConvertQueryResultByFetchSize() throws IoTDBException, IOException {
        Pair res = QueryDataSetUtils.convertQueryResultByFetchSize((IQueryExecution)this.buildQueryExecution(), (int)10);
        this.compareTsBlock((Pair<List<ByteBuffer>, Boolean>)res);
    }

    private void compareTsBlock(Pair<List<ByteBuffer>, Boolean> res) {
        double delta = 1.0E-5;
        Assert.assertEquals((Object)true, (Object)res.right);
        Assert.assertEquals((long)1L, (long)((List)res.left).size());
        TsBlockSerde serde = new TsBlockSerde();
        TsBlock tsBlock = serde.deserialize((ByteBuffer)((List)res.left).get(0));
        Assert.assertEquals((long)2L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)1L, (long)tsBlock.getTimeColumn().getLong(0));
        Assert.assertEquals((long)2L, (long)tsBlock.getTimeColumn().getLong(1));
        Assert.assertFalse((boolean)tsBlock.getColumn(0).isNull(0));
        Assert.assertTrue((boolean)tsBlock.getColumn(0).getBoolean(0));
        Assert.assertTrue((boolean)tsBlock.getColumn(0).isNull(1));
        Assert.assertFalse((boolean)tsBlock.getColumn(1).isNull(0));
        Assert.assertEquals((long)1L, (long)tsBlock.getColumn(1).getInt(0));
        Assert.assertTrue((boolean)tsBlock.getColumn(1).isNull(1));
        Assert.assertFalse((boolean)tsBlock.getColumn(2).isNull(0));
        Assert.assertEquals((long)1L, (long)tsBlock.getColumn(2).getLong(0));
        Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(1));
        Assert.assertFalse((boolean)tsBlock.getColumn(3).isNull(0));
        Assert.assertEquals((double)1.1f, (double)tsBlock.getColumn(3).getFloat(0), (double)1.0E-5);
        Assert.assertTrue((boolean)tsBlock.getColumn(3).isNull(1));
        Assert.assertTrue((boolean)tsBlock.getColumn(4).isNull(0));
        Assert.assertFalse((boolean)tsBlock.getColumn(4).isNull(1));
        Assert.assertEquals((double)3.14, (double)tsBlock.getColumn(4).getDouble(1), (double)1.0E-5);
        Assert.assertFalse((boolean)tsBlock.getColumn(5).isNull(0));
        Assert.assertEquals((Object)new Binary(BINARY_STR, TSFileConfig.STRING_CHARSET), (Object)tsBlock.getColumn(5).getBinary(0));
        Assert.assertTrue((boolean)tsBlock.getColumn(5).isNull(1));
    }
}

