/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.utils.OpenFileNumUtil;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFileNumUtilTest {
    private static final Logger logger = LoggerFactory.getLogger(OpenFileNumUtilTest.class);
    private static final String TEST_FILE_PREFIX = "testFileForOpenFileNumUtil";
    private static final String MAC_OS_NAME = "mac";
    private static final String LINUX_OS_NAME = "linux";
    private static final int UNSUPPORTED_OS_ERROR_CODE = -2;
    private OpenFileNumUtil openFileNumUtil = OpenFileNumUtil.getInstance();
    private ArrayList<File> fileList = new ArrayList();
    private ArrayList<FileWriter> fileWriterList = new ArrayList();
    private String testFileName;
    private int totalOpenFileNumBefore;
    private int totalOpenFileNumAfter;
    private int totalOpenFileNumChange;
    private int testFileNum = 66;
    private String currDir;
    private File testDataDirRoot;
    private String os = System.getProperty("os.name").toLowerCase();

    private static int getProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return Integer.parseInt(runtimeMXBean.getName().split("@")[0]);
    }

    @Before
    public void setUp() {
        int testProcessID = OpenFileNumUtilTest.getProcessID();
        this.openFileNumUtil.setPid(testProcessID);
        String dataFilePath = (String)OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM.getPath().get(0);
        String userDir = System.getProperty("user.dir");
        this.currDir = userDir + File.separator + TestConstant.BASE_OUTPUT_PATH + testProcessID;
        this.testDataDirRoot = new File(this.currDir);
        this.currDir = this.currDir + File.separator + dataFilePath;
        File testDataDir = new File(this.currDir);
        if (!testDataDir.isDirectory() && !testDataDir.mkdirs()) {
            logger.error("Create test file dir {} failed.", (Object)testDataDir.getPath());
        }
        this.testFileName = TEST_FILE_PREFIX + testProcessID;
    }

    @After
    public void tearDown() {
        for (FileWriter fw : this.fileWriterList) {
            try {
                fw.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        for (File file : this.fileList) {
            if (!file.exists()) continue;
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        this.fileWriterList.clear();
        this.fileList.clear();
        try {
            FileUtils.deleteDirectory((File)this.testDataDirRoot);
        }
        catch (IOException e) {
            logger.error("Delete test data dir {} failed.", (Object)this.testDataDirRoot);
        }
    }

    @Test
    public void testDataOpenFileNumWhenCreateFile() {
        if (this.os.startsWith(MAC_OS_NAME) || this.os.startsWith(LINUX_OS_NAME)) {
            this.totalOpenFileNumBefore = this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM);
            for (int i = 0; i < this.testFileNum; ++i) {
                this.fileList.add(new File(this.currDir + this.testFileName + i));
            }
            this.totalOpenFileNumAfter = this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM);
            this.totalOpenFileNumChange = this.totalOpenFileNumAfter - this.totalOpenFileNumBefore;
            if (this.openFileNumUtil.isCommandValid()) {
                Assert.assertEquals((long)0L, (long)this.totalOpenFileNumChange);
            } else {
                Assert.assertEquals((long)-2L, (long)this.totalOpenFileNumBefore);
                Assert.assertEquals((long)-2L, (long)this.totalOpenFileNumAfter);
            }
        } else {
            Assert.assertEquals((long)-2L, (long)this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM));
        }
    }

    @Test
    public void testDataOpenFileNumWhenCreateFileWriter() {
        if (this.os.startsWith(MAC_OS_NAME) || this.os.startsWith(LINUX_OS_NAME)) {
            for (int i = 0; i < this.testFileNum; ++i) {
                this.fileList.add(new File(this.currDir + this.testFileName + i));
            }
            this.totalOpenFileNumBefore = this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM);
            for (File file : this.fileList) {
                if (file.exists()) {
                    try {
                        this.fileWriterList.add(new FileWriter(file));
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                    continue;
                }
                try {
                    boolean flag = file.createNewFile();
                    if (flag) {
                        logger.debug("Create a file {} successfully", (Object)file);
                        this.fileWriterList.add(new FileWriter(file));
                        continue;
                    }
                    logger.error("create test file {} failed when creating file writer.", (Object)file.getPath());
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            this.totalOpenFileNumAfter = this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM);
            this.totalOpenFileNumChange = this.totalOpenFileNumAfter - this.totalOpenFileNumBefore;
            if (this.openFileNumUtil.isCommandValid()) {
                Assert.assertEquals((long)this.testFileNum, (long)this.totalOpenFileNumChange);
            } else {
                Assert.assertEquals((long)-2L, (long)this.totalOpenFileNumBefore);
                Assert.assertEquals((long)-2L, (long)this.totalOpenFileNumAfter);
            }
        } else {
            Assert.assertEquals((long)-2L, (long)this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM));
        }
    }

    @Test
    public void testDataOpenFileNumWhenFileWriterWriting() {
        logger.debug("testDataOpenFileNumWhenFileWriterWriting...");
        if (this.os.startsWith(MAC_OS_NAME) || this.os.startsWith(LINUX_OS_NAME)) {
            for (int i = 0; i < this.testFileNum; ++i) {
                this.fileList.add(new File(this.currDir + this.testFileName + i));
            }
            for (File file : this.fileList) {
                if (file.exists()) {
                    try {
                        this.fileWriterList.add(new FileWriter(file));
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                    continue;
                }
                try {
                    if (!file.createNewFile()) {
                        logger.error("create test file {} failed.", (Object)file.getPath());
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
                try {
                    this.fileWriterList.add(new FileWriter(file));
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            this.totalOpenFileNumBefore = this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM);
            for (FileWriter fw : this.fileWriterList) {
                try {
                    fw.write("this is a test file for open file number counting.");
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            this.totalOpenFileNumAfter = this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM);
            this.totalOpenFileNumChange = this.totalOpenFileNumAfter - this.totalOpenFileNumBefore;
            if (this.openFileNumUtil.isCommandValid()) {
                Assert.assertEquals((long)0L, (long)this.totalOpenFileNumChange);
            } else {
                Assert.assertEquals((long)-2L, (long)this.totalOpenFileNumBefore);
                Assert.assertEquals((long)-2L, (long)this.totalOpenFileNumAfter);
            }
        } else {
            Assert.assertEquals((long)-2L, (long)this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.SEQUENCE_FILE_OPEN_NUM));
        }
    }

    @Test
    public void testDataOpenFileNumWhenFileWriterClose() {
        logger.debug("testDataOpenFileNumWhenFileWriterClose...");
        if (this.os.startsWith(MAC_OS_NAME) || this.os.startsWith(LINUX_OS_NAME)) {
            for (int i = 0; i < this.testFileNum; ++i) {
                this.fileList.add(new File(this.currDir + this.testFileName + i));
            }
            for (File file : this.fileList) {
                if (file.exists()) {
                    try {
                        this.fileWriterList.add(new FileWriter(file));
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                    continue;
                }
                try {
                    if (!file.createNewFile()) {
                        logger.error("create test file {} failed.", (Object)file.getPath());
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
                try {
                    this.fileWriterList.add(new FileWriter(file));
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            for (FileWriter fw : this.fileWriterList) {
                try {
                    fw.write("this is a test file for open file number counting.");
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            this.totalOpenFileNumBefore = this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM);
            for (FileWriter fw : this.fileWriterList) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            this.totalOpenFileNumAfter = this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM);
            this.totalOpenFileNumChange = this.totalOpenFileNumAfter - this.totalOpenFileNumBefore;
            if (this.openFileNumUtil.isCommandValid()) {
                Assert.assertEquals((long)(-this.testFileNum), (long)this.totalOpenFileNumChange);
            } else {
                Assert.assertEquals((long)-2L, (long)this.totalOpenFileNumBefore);
                Assert.assertEquals((long)-2L, (long)this.totalOpenFileNumAfter);
            }
        } else {
            Assert.assertEquals((long)-2L, (long)this.openFileNumUtil.get(OpenFileNumUtil.OpenFileNumStatistics.DIGEST_OPEN_FILE_NUM));
        }
    }
}

