/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.exception.StorageGroupNotReadyException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.thrift.OperationType;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.junit.Assert;
import org.junit.Test;

public class ErrorHandlingUtilsTest {
    @Test
    public void onNpeOrUnexpectedExceptionTest() {
        TSStatus status = ErrorHandlingUtils.onNpeOrUnexpectedException((Exception)new IOException("test-IOException"), (OperationType)OperationType.EXECUTE_STATEMENT, (TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        Assert.assertEquals((long)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (long)status.getCode());
        status = ErrorHandlingUtils.onNpeOrUnexpectedException((Exception)new NullPointerException("test-NullPointerException"), (OperationType)OperationType.EXECUTE_STATEMENT, (TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        Assert.assertEquals((long)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (long)status.getCode());
        status = ErrorHandlingUtils.onNpeOrUnexpectedException((Exception)new RuntimeException("test-RuntimeException"), (OperationType)OperationType.EXECUTE_STATEMENT, (TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        Assert.assertEquals((long)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (long)status.getCode());
    }

    @Test
    public void onQueryExceptionTest() {
        TSStatus status = ErrorHandlingUtils.onQueryException((Exception)new StorageGroupNotReadyException("test-StorageGroupNotReadyException", 0), (OperationType)OperationType.EXECUTE_STATEMENT);
        Assert.assertEquals((long)TSStatusCode.STORAGE_ENGINE_NOT_READY.getStatusCode(), (long)status.getCode());
        status = ErrorHandlingUtils.onQueryException((Exception)((Object)new SemanticException("test-SemanticException")), (OperationType)OperationType.EXECUTE_STATEMENT);
        Assert.assertEquals((long)TSStatusCode.SEMANTIC_ERROR.getStatusCode(), (long)status.getCode());
    }

    @Test
    public void onNonQueryExceptionTest() {
        TSStatus status = ErrorHandlingUtils.onNonQueryException((Exception)new PathNotExistException("test-PathNotExistException"), (OperationType)OperationType.EXECUTE_STATEMENT);
        Assert.assertEquals((long)TSStatusCode.PATH_NOT_EXIST.getStatusCode(), (long)status.getCode());
    }

    @Test
    public void onIoTDBExceptionTest() {
        TSStatus status = ErrorHandlingUtils.onIoTDBException((Exception)((Object)new QueryProcessException("test-QueryProcessException")), (OperationType)OperationType.EXECUTE_STATEMENT, (int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        Assert.assertEquals((long)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (long)status.getCode());
    }
}

