/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.read.control.QueryResourceManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.WALRecoverManager;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.iotdb.db.storageengine.rescon.memory.MemTableManager;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.storageengine.rescon.memory.TsFileResourceManager;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.rpc.TConfigurationConst;
import org.apache.iotdb.rpc.TSocketWrapper;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.udf.api.exception.UDFManagementException;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentUtils {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentUtils.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private static final TierManager tierManager = TierManager.getInstance();
    public static long TEST_QUERY_JOB_ID = 1L;
    public static QueryContext TEST_QUERY_CONTEXT = new QueryContext(TEST_QUERY_JOB_ID);
    public static FragmentInstanceContext TEST_QUERY_FI_CONTEXT = FragmentInstanceContext.createFragmentInstanceContextForCompaction((long)TEST_QUERY_JOB_ID);
    private static final long oldSeqTsFileSize = config.getSeqTsFileSize();
    private static final long oldUnSeqTsFileSize = config.getUnSeqTsFileSize();
    private static TConfiguration tConfiguration = TConfigurationConst.defaultTConfiguration;
    public static boolean examinePorts = Boolean.parseBoolean(System.getProperty("test.port.closed", "false"));

    public static void cleanEnv() throws IOException, StorageEngineException {
        boolean closed;
        CompactionTaskManager.getInstance().waitAllCompactionFinish();
        try {
            if (UDFManagementService.getInstance() != null) {
                UDFManagementService.getInstance().deregisterAll();
            }
        }
        catch (UDFManagementException e) {
            Assert.fail((String)e.getMessage());
        }
        logger.debug("EnvironmentUtil cleanEnv...");
        QueryResourceManager.getInstance().endQuery(TEST_QUERY_JOB_ID);
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        if (examinePorts && !(closed = EnvironmentUtils.examinePorts())) {
            try {
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!EnvironmentUtils.examinePorts()) {
                Assert.fail((String)"failed to close some ports");
            }
        }
        WALManager.getInstance().stop();
        WALRecoverManager.getInstance().clear();
        StorageEngine.getInstance().stop();
        SchemaEngine.getInstance().clear();
        FlushManager.getInstance().stop();
        CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.Running);
        IoTDBDescriptor.getInstance().getConfig().setEnableMQTTService(false);
        if (config.isMetaDataCacheEnable()) {
            ChunkCache.getInstance().clear();
            TimeSeriesMetadataCache.getInstance().clear();
            BloomFilterCache.getInstance().clear();
        }
        PrimitiveArrayManager.close();
        SystemInfo.getInstance().close();
        MemTableManager.getInstance().close();
        TsFileResourceManager.getInstance().clear();
        try {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        EnvironmentUtils.cleanAllDir();
        config.setSeqTsFileSize(oldSeqTsFileSize);
        config.setUnSeqTsFileSize(oldUnSeqTsFileSize);
    }

    private static boolean examinePorts() {
        TSocket transport = TSocketWrapper.wrap((TConfiguration)tConfiguration, (String)"127.0.0.1", (int)6667, (int)100);
        if (transport != null && !transport.isOpen()) {
            try {
                transport.open();
                logger.error("stop daemon failed. 6667 can be connected now.");
                transport.close();
                return false;
            }
            catch (TTransportException tTransportException) {
                // empty catch block
            }
        }
        if ((transport = TSocketWrapper.wrap((TConfiguration)tConfiguration, (String)"127.0.0.1", (int)5555, (int)100)) != null && !transport.isOpen()) {
            try {
                transport.open();
                logger.error("stop Sync daemon failed. 5555 can be connected now.");
                transport.close();
                return false;
            }
            catch (TTransportException tTransportException) {
                // empty catch block
            }
        }
        try {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:31999/jmxrmi");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url);
            logger.error("stop JMX failed. 31999 can be connected now.");
            jmxConnector.close();
            return false;
        }
        catch (IOException url) {
            boolean bl;
            Socket socket = new Socket();
            try {
                socket.connect(new InetSocketAddress("127.0.0.1", 9091), 100);
                logger.error("stop MetricService failed. 9091 can be connected now.");
                bl = false;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return true;
                }
            }
            socket.close();
            return bl;
        }
    }

    public static void cleanAllDir() throws IOException {
        for (String path : tierManager.getAllLocalSequenceFileFolders()) {
            EnvironmentUtils.cleanDir(path);
        }
        for (String path : tierManager.getAllLocalUnSequenceFileFolders()) {
            EnvironmentUtils.cleanDir(path);
        }
        EnvironmentUtils.cleanDir(config.getSystemDir());
        EnvironmentUtils.cleanDir(config.getQueryDir());
        EnvironmentUtils.cleanDir(config.getUdfDir());
        EnvironmentUtils.cleanDir(config.getTriggerDir());
        EnvironmentUtils.cleanDir(config.getExtPipeDir());
        EnvironmentUtils.cleanDir(config.getExtDir());
        EnvironmentUtils.cleanDir(config.getMqttDir());
        for (String walDir : commonConfig.getWalDirs()) {
            EnvironmentUtils.cleanDir(walDir);
        }
        EnvironmentUtils.cleanDir(commonConfig.getSyncDir());
        for (String dataDir : config.getDataDirs()) {
            EnvironmentUtils.cleanDir(dataDir);
        }
    }

    public static void cleanDir(String dir) throws IOException {
        FSFactoryProducer.getFSFactory().deleteDirectory(dir);
    }

    public static void envSetUp() {
        logger.debug("EnvironmentUtil setup...");
        config.setThriftServerAwaitTimeForStopService(60);
        config.setAvgSeriesPointNumberThreshold(Integer.MAX_VALUE);
        config.setAvgSeriesPointNumberThreshold(Integer.MAX_VALUE);
        EnvironmentUtils.createAllDir();
        try {
            StorageEngine.getInstance().start();
            SchemaEngine.getInstance().init();
            CompactionTaskManager.getInstance().start();
            WALManager.getInstance().start();
            FlushManager.getInstance().start();
        }
        catch (StartupException e) {
            throw new RuntimeException(e);
        }
        DeviceIDFactory.getInstance().reset();
        TEST_QUERY_JOB_ID = QueryResourceManager.getInstance().assignQueryId();
        TEST_QUERY_CONTEXT = new QueryContext(TEST_QUERY_JOB_ID);
    }

    private static void createAllDir() {
        for (String path : tierManager.getAllLocalSequenceFileFolders()) {
            EnvironmentUtils.createDir(path);
        }
        for (String path : tierManager.getAllLocalUnSequenceFileFolders()) {
            EnvironmentUtils.createDir(path);
        }
        EnvironmentUtils.createDir(config.getSystemDir());
        String sgDir = FilePathUtils.regularizePath((String)config.getSystemDir()) + "databases";
        EnvironmentUtils.createDir(sgDir);
        EnvironmentUtils.createDir(commonConfig.getSyncDir());
        EnvironmentUtils.createDir(config.getQueryDir());
        EnvironmentUtils.createDir(TestConstant.OUTPUT_DATA_DIR);
        for (String walDir : commonConfig.getWalDirs()) {
            EnvironmentUtils.createDir(walDir);
        }
        for (String dataDir : config.getDataDirs()) {
            EnvironmentUtils.createDir(dataDir);
        }
    }

    private static void createDir(String dir) {
        File file = FSFactoryProducer.getFSFactory().getFile(dir);
        file.mkdirs();
    }

    public static void recursiveDeleteFolder(String path) throws IOException {
        File file = new File(path);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                FileUtils.deleteDirectory((File)file);
            } else {
                for (File f : files) {
                    EnvironmentUtils.recursiveDeleteFolder(f.getAbsolutePath());
                }
                FileUtils.deleteDirectory((File)file);
            }
        } else {
            FileUtils.delete((File)file);
        }
    }
}

