/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.service;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.trigger.exception.TriggerManagementException;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.db.trigger.service.TriggerManagementService;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.junit.Assert;
import org.junit.Test;

public class TriggerManagementServiceTest {
    private static final TriggerManagementService SERVICE = TriggerManagementService.getInstance();

    @Test
    public void testRegisterAndActiveAndInactiveAndDrop() {
        try {
            List triggerInformationList;
            TriggerInformation triggerInformation;
            block4: {
                triggerInformation = new TriggerInformation(new PartialPath("root.test.**"), "test1", "org.apache.iotdb.db.trigger.service.TestTrigger", false, "test1.jar", null, TriggerEvent.AFTER_INSERT, TTriggerState.INACTIVE, false, null, FailureStrategy.OPTIMISTIC, "testMD5test");
                triggerInformationList = SERVICE.getAllTriggerInformationInTriggerTable();
                Assert.assertEquals((long)0L, (long)triggerInformationList.size());
                try {
                    SERVICE.doRegister(triggerInformation, false);
                }
                catch (TriggerManagementException e) {
                    if (e.getMessage().contains("reflect")) break block4;
                    Assert.fail();
                }
            }
            triggerInformationList = SERVICE.getAllTriggerInformationInTriggerTable();
            Assert.assertEquals((long)1L, (long)triggerInformationList.size());
            Assert.assertEquals((Object)triggerInformation, triggerInformationList.get(0));
            Assert.assertEquals((Object)TTriggerState.INACTIVE, (Object)((TriggerInformation)triggerInformationList.get(0)).getTriggerState());
            SERVICE.activeTrigger("test1");
            Assert.assertEquals((Object)TTriggerState.ACTIVE, (Object)((TriggerInformation)SERVICE.getAllTriggerInformationInTriggerTable().get(0)).getTriggerState());
            SERVICE.inactiveTrigger("test1");
            Assert.assertEquals((Object)TTriggerState.INACTIVE, (Object)((TriggerInformation)SERVICE.getAllTriggerInformationInTriggerTable().get(0)).getTriggerState());
            SERVICE.dropTrigger("test1", false);
            Assert.assertEquals((long)0L, (long)SERVICE.getAllTriggerInformationInTriggerTable().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

