/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.executor;

import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.trigger.executor.TriggerExecutor;
import org.apache.iotdb.db.trigger.executor.TriggerFireResult;
import org.apache.iotdb.db.trigger.executor.TriggerFireVisitor;
import org.apache.iotdb.db.trigger.service.TriggerManagementService;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.iotdb.trigger.api.TriggerAttributes;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TriggerExecuteTest {
    @After
    public void clear() {
        TriggerManagementService.getInstance().getTriggerTable().clear();
    }

    @Test
    public void testTriggerExecutor() {
        try {
            TriggerInformation triggerInformation = new TriggerInformation(new PartialPath("root.sg.**"), "test1", "org.apache.iotdb.db.trigger.service.TestTrigger", false, "test1.jar", null, TriggerEvent.AFTER_INSERT, TTriggerState.ACTIVE, false, null, FailureStrategy.OPTIMISTIC, "testMD5test");
            TestTrigger trigger = new TestTrigger();
            TriggerExecutor executor = new TriggerExecutor(triggerInformation, (Trigger)trigger, false);
            TriggerManagementService.getInstance().fakeRegister(triggerInformation, executor);
            InsertRowNode insertRowNode = this.getInsertRowNodeWithMeasurementSchemas();
            TriggerFireVisitor fireVisitor = new TriggerFireVisitor();
            TriggerFireResult result = fireVisitor.process((PlanNode)insertRowNode, TriggerEvent.AFTER_INSERT);
            Assert.assertEquals((Object)TriggerFireResult.SUCCESS, (Object)result);
            executor.onDrop();
            TestTrigger test = trigger;
            Assert.assertTrue((boolean)test.onCreated);
            Assert.assertTrue((boolean)test.onValidated);
            Assert.assertTrue((boolean)test.onFired);
            Assert.assertTrue((boolean)test.onDropped);
            Assert.assertEquals((Object)FailureStrategy.OPTIMISTIC, (Object)executor.getFailureStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private InsertRowNode getInsertRowNodeWithMeasurementSchemas() throws IllegalPathException {
        long time = 80L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN};
        Object[] columns = new Object[]{5.0, Float.valueOf(6.0f), 1000L, 10, true};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId("plannode 2"), new PartialPath("root.sg"), false, new String[]{"s1", "s2", "s3", "s4", "s5"}, dataTypes, time, columns, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64), new MeasurementSchema("s4", TSDataType.INT32), new MeasurementSchema("s5", TSDataType.BOOLEAN)});
        return insertRowNode;
    }

    private static class TestTrigger
    implements Trigger {
        boolean onDropped = false;
        boolean onValidated = false;
        boolean onCreated = false;
        boolean onFired = false;

        private TestTrigger() {
        }

        public void validate(TriggerAttributes attributes) throws Exception {
            this.onValidated = true;
        }

        public void onCreate(TriggerAttributes attributes) {
            this.onCreated = true;
        }

        public boolean fire(Tablet tablet) {
            this.onFired = true;
            return true;
        }

        public void onDrop() {
            this.onDropped = true;
        }
    }
}

