/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.IOException;
import java.util.Arrays;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.AbstractCompactionTest;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.tools.validate.TsFileOverlapValidationAndRepairTool;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileOverlapValidationAndRepairToolTest
extends AbstractCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException, InterruptedException {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        super.tearDown();
    }

    @Test
    public void test1() throws IOException {
        String device1 = "d1";
        String device2 = "d2";
        TsFileResource resource1 = this.createTsFileAndResource();
        resource1.updateStartTime((IDeviceID)new PlainDeviceID(device1), 10L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID(device1), 30L);
        resource1.updateStartTime((IDeviceID)new PlainDeviceID(device2), 20L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID(device2), 40L);
        resource1.serialize();
        resource1.close();
        TsFileResource resource2 = this.createTsFileAndResource();
        resource2.updateStartTime((IDeviceID)new PlainDeviceID(device1), 29L);
        resource2.updateEndTime((IDeviceID)new PlainDeviceID(device1), 30L);
        resource2.updateStartTime((IDeviceID)new PlainDeviceID(device2), 50L);
        resource2.updateEndTime((IDeviceID)new PlainDeviceID(device2), 60L);
        resource2.serialize();
        resource2.close();
        TsFileResource resource3 = this.createTsFileAndResource();
        resource3.updateStartTime((IDeviceID)new PlainDeviceID(device1), 40L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID(device1), 50L);
        resource3.updateStartTime((IDeviceID)new PlainDeviceID(device2), 70L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID(device2), 80L);
        resource3.serialize();
        resource3.close();
        int overlapFileNum = TsFileOverlapValidationAndRepairTool.checkTimePartitionHasOverlap(Arrays.asList(resource1, resource2, resource3));
        Assert.assertEquals((long)1L, (long)overlapFileNum);
    }

    @Test
    public void test2() throws IOException {
        String device1 = "d1";
        String device2 = "d2";
        TsFileResource resource1 = this.createTsFileAndResource();
        resource1.updateStartTime((IDeviceID)new PlainDeviceID(device1), 10L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID(device1), 30L);
        resource1.updateStartTime((IDeviceID)new PlainDeviceID(device2), 20L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID(device2), 40L);
        resource1.serialize();
        resource1.close();
        TsFileResource resource2 = this.createTsFileAndResource();
        resource2.updateStartTime((IDeviceID)new PlainDeviceID(device1), 29L);
        resource2.updateEndTime((IDeviceID)new PlainDeviceID(device1), 30L);
        resource2.updateStartTime((IDeviceID)new PlainDeviceID(device2), 50L);
        resource2.updateEndTime((IDeviceID)new PlainDeviceID(device2), 60L);
        resource2.serialize();
        resource2.close();
        TsFileResource resource3 = this.createTsFileAndResource();
        resource3.updateStartTime((IDeviceID)new PlainDeviceID(device1), 30L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID(device1), 50L);
        resource3.updateStartTime((IDeviceID)new PlainDeviceID(device2), 70L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID(device2), 80L);
        resource3.serialize();
        resource3.close();
        int overlapFileNum = TsFileOverlapValidationAndRepairTool.checkTimePartitionHasOverlap(Arrays.asList(resource1, resource2, resource3));
        Assert.assertEquals((long)2L, (long)overlapFileNum);
    }

    @Test
    public void test3() throws IOException {
        String device1 = "d1";
        String device2 = "d2";
        TsFileResource resource1 = this.createTsFileAndResource();
        resource1.updateStartTime((IDeviceID)new PlainDeviceID(device1), 10L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID(device1), 30L);
        resource1.updateStartTime((IDeviceID)new PlainDeviceID(device2), 20L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID(device2), 40L);
        resource1.serialize();
        resource1.close();
        TsFileResource resource2 = this.createTsFileAndResource();
        resource2.updateStartTime((IDeviceID)new PlainDeviceID(device1), 10L);
        resource2.updateEndTime((IDeviceID)new PlainDeviceID(device1), 20L);
        resource2.updateStartTime((IDeviceID)new PlainDeviceID(device2), 50L);
        resource2.updateEndTime((IDeviceID)new PlainDeviceID(device2), 60L);
        resource2.serialize();
        resource2.close();
        TsFileResource resource3 = this.createTsFileAndResource();
        resource3.updateStartTime((IDeviceID)new PlainDeviceID(device1), 30L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID(device1), 50L);
        resource3.updateStartTime((IDeviceID)new PlainDeviceID(device2), 70L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID(device2), 80L);
        resource3.serialize();
        resource3.close();
        int overlapFileNum = TsFileOverlapValidationAndRepairTool.checkTimePartitionHasOverlap(Arrays.asList(resource1, resource2, resource3));
        Assert.assertEquals((long)2L, (long)overlapFileNum);
    }

    @Test
    public void test4() throws IOException {
        String device1 = "d1";
        String device2 = "d2";
        TsFileResource resource1 = this.createTsFileAndResource();
        resource1.updateStartTime((IDeviceID)new PlainDeviceID(device1), 10L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID(device1), 30L);
        resource1.updateStartTime((IDeviceID)new PlainDeviceID(device2), 20L);
        resource1.updateEndTime((IDeviceID)new PlainDeviceID(device2), 40L);
        resource1.serialize();
        resource1.close();
        TsFileResource resource2 = this.createTsFileAndResource();
        resource2.updateStartTime((IDeviceID)new PlainDeviceID(device1), 10L);
        resource2.updateEndTime((IDeviceID)new PlainDeviceID(device1), 50L);
        resource2.updateStartTime((IDeviceID)new PlainDeviceID(device2), 50L);
        resource2.updateEndTime((IDeviceID)new PlainDeviceID(device2), 60L);
        resource2.serialize();
        resource2.close();
        TsFileResource resource3 = this.createTsFileAndResource();
        resource3.updateStartTime((IDeviceID)new PlainDeviceID(device1), 40L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID(device1), 50L);
        resource3.updateStartTime((IDeviceID)new PlainDeviceID(device2), 70L);
        resource3.updateEndTime((IDeviceID)new PlainDeviceID(device2), 80L);
        resource3.serialize();
        resource3.close();
        int overlapFileNum = TsFileOverlapValidationAndRepairTool.checkTimePartitionHasOverlap(Arrays.asList(resource1, resource2, resource3));
        Assert.assertEquals((long)1L, (long)overlapFileNum);
    }

    private TsFileResource createTsFileAndResource() throws IOException {
        TsFileResource resource = this.createEmptyFileAndResource(true);
        TsFileIOWriter writer = new TsFileIOWriter(resource.getTsFile());
        writer.endFile();
        writer.close();
        return resource;
    }
}

