/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.tools.settle.TsFileAndModSettleTool;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileAndModSettleToolTest {
    private final long newPartitionInterval = 3600000L;
    protected final long maxTimestamp = 50000L;
    protected final String folder = "target" + File.separator + "settle";
    protected final String STORAGE_GROUP = "root.sg_0";
    protected final String DEVICE1 = "root.sg_0.device_1";
    protected final String DEVICE2 = "root.sg_0.device_2";
    protected final String SENSOR1 = "sensor_1";
    protected final String SENSOR2 = "sensor_2";
    private final long VALUE_OFFSET = 1L;
    private String path = null;
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private long originPartitionInterval;

    @Before
    public void setUp() {
        this.originPartitionInterval = COMMON_CONFIG.getTimePartitionInterval();
        COMMON_CONFIG.setTimePartitionInterval(3600000L);
        EnvironmentUtils.envSetUp();
        File f = new File(this.folder);
        if (!f.exists()) {
            boolean success = f.mkdir();
            Assert.assertTrue((boolean)success);
        }
        this.path = this.folder + File.separator + System.currentTimeMillis() + "-" + 0 + "-0.tsfile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() {
        File[] fileLists;
        for (File f : fileLists = FSFactoryProducer.getFSFactory().listFilesBySuffix(this.folder, ".tsfile")) {
            if (!f.exists()) continue;
            boolean deleteSuccess = f.delete();
            Assert.assertTrue((boolean)deleteSuccess);
        }
        File directory = new File(this.folder);
        FileUtils.deleteFileOrDirectory((File)directory);
        try {
            EnvironmentUtils.cleanEnv();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            COMMON_CONFIG.setTimePartitionInterval(this.originPartitionInterval);
        }
    }

    @Test
    public void settleTsFilesAndModsTest() {
        try {
            List<TsFileResource> resourcesToBeSettled = this.createFiles();
            ArrayList settledResources = new ArrayList();
            for (TsFileResource oldResource : resourcesToBeSettled) {
                TsFileAndModSettleTool tsFileAndModSettleTool = TsFileAndModSettleTool.getInstance();
                tsFileAndModSettleTool.settleOneTsFileAndMod(oldResource, settledResources);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public List<TsFileResource> createFiles() throws IOException, InterruptedException {
        ArrayList<TsFileResource> resourcesToBeSettled = new ArrayList<TsFileResource>();
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        String timeseriesPath = "root.sg_0root.sg_0.device_1sensor_1";
        this.createFile(resourcesToBeSettled, deviceSensorsMap, timeseriesPath);
        this.path = this.folder + File.separator + System.currentTimeMillis() + "-" + 0 + "-0.tsfile";
        sensors.add("sensor_2");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        timeseriesPath = "root.sg_0root.sg_0.device_1sensor_2";
        this.createFile(resourcesToBeSettled, deviceSensorsMap, timeseriesPath);
        Thread.sleep(100L);
        this.path = this.folder + File.separator + System.currentTimeMillis() + "-" + 0 + "-0.tsfile";
        this.createOneTsFile(deviceSensorsMap);
        TsFileResource tsFileResource = new TsFileResource(new File(this.path));
        tsFileResource.serialize();
        tsFileResource.close();
        resourcesToBeSettled.add(tsFileResource);
        return resourcesToBeSettled;
    }

    private void createFile(List<TsFileResource> resourcesToBeSettled, HashMap<String, List<String>> deviceSensorsMap, String timeseriesPath) throws IOException {
        this.createOneTsFile(deviceSensorsMap);
        this.createlModificationFile(timeseriesPath);
        TsFileResource tsFileResource = new TsFileResource(new File(this.path));
        tsFileResource.setModFile(new ModificationFile(tsFileResource.getTsFilePath() + ".mods"));
        tsFileResource.serialize();
        tsFileResource.close();
        resourcesToBeSettled.add(tsFileResource);
    }

    public void createlModificationFile(String timeseriesPath) {
        String modFilePath = this.path + ".mods";
        ModificationFile modificationFile = new ModificationFile(modFilePath);
        ArrayList<Deletion> mods = new ArrayList<Deletion>();
        try {
            PartialPath partialPath = new PartialPath(timeseriesPath);
            mods.add(new Deletion(partialPath, 10000000L, 1500L, 10000L));
            mods.add(new Deletion(partialPath, 10000000L, 20000L, 30000L));
            mods.add(new Deletion(partialPath, 10000000L, 45000L, 50000L));
            for (Modification modification : mods) {
                modificationFile.write(modification);
            }
            modificationFile.close();
        }
        catch (IOException | IllegalPathException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected void createOneTsFile(HashMap<String, List<String>> deviceSensorsMap) {
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(this.path);
            TsFileWriter tsFileWriter = new TsFileWriter(f);
            try {
                for (Map.Entry<String, List<String>> entry : deviceSensorsMap.entrySet()) {
                    String device = entry.getKey();
                    for (String sensor : entry.getValue()) {
                        tsFileWriter.registerTimeseries(new Path(device), new MeasurementSchema(sensor, TSDataType.INT64, TSEncoding.RLE));
                    }
                }
            }
            catch (WriteProcessException e) {
                Assert.fail((String)e.getMessage());
            }
            for (long timestamp = 0L; timestamp < 50000L; timestamp += 1000L) {
                for (Map.Entry<String, List<String>> entry : deviceSensorsMap.entrySet()) {
                    String device = entry.getKey();
                    TSRecord tsRecord = new TSRecord(timestamp, device);
                    for (String sensor : entry.getValue()) {
                        LongDataPoint dataPoint = new LongDataPoint(sensor, timestamp + 1L);
                        tsRecord.addTuple((DataPoint)dataPoint);
                    }
                    tsFileWriter.write(tsRecord);
                }
            }
            tsFileWriter.flushAllChunkGroups();
            tsFileWriter.close();
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

