/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.schemaengine.SchemaEngineMode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.tools.schema.PBTreeFileSketchTool;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PBTreeFileSketchTest {
    private final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();

    @Before
    public void setUp() {
        CommonDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.PBTree.toString());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        File sketch = new File("sketch_schemafile.txt");
        sketch.deleteOnExit();
        EnvironmentUtils.cleanEnv();
        CommonDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    private void prepareData() throws IOException, MetadataException {
        int TEST_SCHEMA_REGION_ID = 0;
        SchemaFile sf = SchemaFile.initSchemaFile((String)"root.test.vRoot1", (int)TEST_SCHEMA_REGION_ID);
        Iterator<ICachedMNode> ite = this.getTreeBFT(this.getFlatTree(500, "aa"));
        while (ite.hasNext()) {
            ICachedMNode cur = ite.next();
            if (cur.isMeasurement()) continue;
            ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer((ICachedMNode)cur);
            container.transferAllBufferReceivingToFlushing();
            sf.writeMNode(cur);
        }
        sf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchemaFileSketch() throws Exception {
        this.prepareData();
        File file = new File("target" + File.separator + "tmp" + File.separator + "system" + File.separator + "schema" + File.separator + "root.test.vRoot1" + File.separator + "0" + File.separator + "pbtree.pst");
        File sketchFile = new File("sketch_schemafile.txt");
        PBTreeFileSketchTool.main((String[])new String[]{"-f", file.getAbsolutePath(), "-o", sketchFile.getAbsolutePath()});
        try (SchemaFile sf = SchemaFile.loadSchemaFile((File)file);){
            StringWriter sw = new StringWriter();
            sf.inspect(new PrintWriter(sw));
            Assert.assertEquals((Object)sw.toString(), (Object)new String(Files.readAllBytes(Paths.get(sketchFile.getAbsolutePath(), new String[0]))));
        }
    }

    private Iterator<ICachedMNode> getTreeBFT(final ICachedMNode root) {
        return new Iterator<ICachedMNode>(){
            Queue<ICachedMNode> queue = new LinkedList<ICachedMNode>();
            {
                this.queue.add(root);
            }

            @Override
            public boolean hasNext() {
                return this.queue.size() > 0;
            }

            @Override
            public ICachedMNode next() {
                ICachedMNode curNode = this.queue.poll();
                if (!curNode.isMeasurement() && curNode.getChildren().size() > 0) {
                    for (ICachedMNode child : curNode.getChildren().values()) {
                        this.queue.add(child);
                    }
                }
                return curNode;
            }
        };
    }

    private ICachedMNode getFlatTree(int flatSize, String id) {
        ICachedMNode root = (ICachedMNode)this.nodeFactory.createInternalMNode(null, "root");
        ICachedMNode test = (ICachedMNode)this.nodeFactory.createInternalMNode((IMNode)root, "test");
        ICachedMNode internalNode = (ICachedMNode)this.nodeFactory.createDatabaseDeviceMNode(null, "vRoot1", 0L);
        for (int idx = 0; idx < flatSize; ++idx) {
            String measurementId = id + idx;
            MeasurementSchema schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            internalNode.addChild((IMNode)((ICachedMNode)this.nodeFactory.createMeasurementMNode(internalNode.getAsDeviceMNode(), measurementId, (IMeasurementSchema)schema, measurementId + "als").getAsMNode()));
        }
        test.addChild((IMNode)internalNode);
        return internalNode;
    }
}

