/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.tools.schema.MLogParser;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MLogParserTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private String[] storageGroups = new String[]{"root.sg0", "root.sg1", "root.sg"};
    private int[] schemaRegionIds = new int[]{0, 1, 2};
    private int[] mlogLineNum = new int[]{50, 54, 0};
    private String schemaRegionConsensusProtocolClass;

    @Before
    public void setUp() {
        this.schemaRegionConsensusProtocolClass = config.getSchemaRegionConsensusProtocolClass();
        config.setSchemaRegionConsensusProtocolClass("org.apache.iotdb.consensus.simple.SimpleConsensus");
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        File file = new File("target" + File.separator + "tmp" + File.separator + "text.mlog");
        file.delete();
        file = new File("target" + File.separator + "tmp" + File.separator + "text.snapshot");
        file.delete();
        EnvironmentUtils.cleanEnv();
        config.setSchemaRegionConsensusProtocolClass(this.schemaRegionConsensusProtocolClass);
    }

    private void prepareData() throws Exception {
        int i;
        SchemaEngine schemaEngine = SchemaEngine.getInstance();
        for (i = 0; i < this.storageGroups.length; ++i) {
            SchemaEngine.getInstance().createSchemaRegion(new PartialPath(this.storageGroups[i]), new SchemaRegionId(this.schemaRegionIds[i]));
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 10; ++k) {
                    try {
                        schemaEngine.getSchemaRegion(new SchemaRegionId(this.schemaRegionIds[i])).createTimeseries(SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan((PartialPath)new PartialPath("root.sg" + i + ".device" + j + ".s" + k), (TSDataType)TSDataType.INT32, (TSEncoding)TSEncoding.PLAIN, (CompressionType)CompressionType.GZIP, null, null, null, null), -1L);
                        continue;
                    }
                    catch (MetadataException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            PathPatternTree patternTree = new PathPatternTree();
            patternTree.appendPathPattern(new PartialPath("root.sg1.device1.s1"));
            patternTree.constructTree();
            schemaEngine.getSchemaRegion(new SchemaRegionId(1)).constructSchemaBlackList(patternTree);
            schemaEngine.getSchemaRegion(new SchemaRegionId(1)).deleteTimeseriesInBlackList(patternTree);
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tag1", "value1");
            schemaEngine.getSchemaRegion(new SchemaRegionId(1)).addTags(tags, new PartialPath("root.sg1.device1.s2"));
            schemaEngine.getSchemaRegion(new SchemaRegionId(1)).upsertAliasAndTagsAndAttributes("hello", null, null, new PartialPath("root.sg1.device1.s3"));
        }
        catch (IOException | MetadataException e) {
            e.printStackTrace();
        }
        try {
            SchemaEngine.getInstance().createSchemaRegion(new PartialPath("root.sg"), new SchemaRegionId(this.schemaRegionIds[2]));
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testMLogParser() throws Exception {
        this.prepareData();
        SchemaEngine.getInstance().forceMlog();
        for (int i = 0; i < this.storageGroups.length; ++i) {
            this.testParseMLog(this.storageGroups[i], this.schemaRegionIds[i], this.mlogLineNum[i]);
        }
    }

    private void testParseMLog(String storageGroup, int schemaRegionId, int expectedLineNum) throws IOException {
        this.testParseLog(IoTDBDescriptor.getInstance().getConfig().getSchemaDir() + File.separator + storageGroup + File.separator + schemaRegionId + File.separator + "mlog.bin", expectedLineNum);
    }

    private void testParseLog(String path, int expectedNum) throws IOException {
        File file = new File("target" + File.separator + "tmp" + File.separator + "text.mlog");
        file.delete();
        MLogParser.main((String[])new String[]{"-f", path, "-o", "target" + File.separator + "tmp" + File.separator + "text.mlog"});
        try (BufferedReader reader = new BufferedReader(new FileReader("target" + File.separator + "tmp" + File.separator + "text.mlog"));){
            String line;
            int lineNum = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                ++lineNum;
                lines.add(line);
            }
            if (lineNum != expectedNum) {
                for (String content : lines) {
                    System.out.println(content);
                }
            }
            Assert.assertEquals((long)expectedNum, (long)lineNum);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

