/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryPosition;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALInsertNodeCache;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WALInsertNodeCacheTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String identifier = String.valueOf(Integer.MAX_VALUE);
    private static final String logDirectory = TestConstant.BASE_OUTPUT_PATH.concat("wal-test");
    private static final String databasePath = "root.test_sg";
    private static final String devicePath = "root.test_sg.test_d";
    private static final String dataRegionId = "1";
    private static final WALInsertNodeCache cache = WALInsertNodeCache.getInstance((Integer)1);
    private WALMode prevMode;
    private WALNode walNode;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(logDirectory);
        cache.clear();
        this.prevMode = config.getWalMode();
        config.setWalMode(WALMode.SYNC);
        this.walNode = new WALNode(identifier, logDirectory);
    }

    @After
    public void tearDown() throws Exception {
        this.walNode.close();
        cache.clear();
        config.setWalMode(this.prevMode);
        EnvironmentUtils.cleanDir(logDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadAfterSyncBuffer() throws IllegalPathException {
        try {
            this.walNode.setBufferSize(16);
            PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
            this.walNode.onMemTableCreated((IMemTable)memTable, logDirectory + "/fake.tsfile");
            InsertRowNode node1 = this.getInsertRowNode(System.currentTimeMillis());
            node1.setSearchIndex(1L);
            WALFlushListener flushListener = this.walNode.log(memTable.getMemTableId(), node1);
            WALEntryPosition position = flushListener.getWalEntryHandler().getWalEntryPosition();
            this.walNode.rollWALFile();
            Awaitility.await().until(() -> this.walNode.isAllWALEntriesConsumed() && position.canRead());
            System.out.println(position.getPosition());
            Assert.assertEquals((Object)node1, (Object)cache.getInsertNode(position));
        }
        finally {
            this.walNode.setBufferSize(config.getWalBufferSize());
        }
    }

    @Test
    public void testGetInsertNodeInParallel() throws IllegalPathException {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode.onMemTableCreated((IMemTable)memTable, logDirectory + "/fake.tsfile");
        InsertRowNode node1 = this.getInsertRowNode(System.currentTimeMillis());
        node1.setSearchIndex(1L);
        WALFlushListener flushListener = this.walNode.log(memTable.getMemTableId(), node1);
        WALEntryPosition position = flushListener.getWalEntryHandler().getWalEntryPosition();
        this.walNode.rollWALFile();
        Awaitility.await().until(() -> this.walNode.isAllWALEntriesConsumed() && position.canRead());
        AtomicBoolean failure = new AtomicBoolean(false);
        ArrayList<Thread> threadList = new ArrayList<Thread>(5);
        for (int i = 0; i < 5; ++i) {
            Thread getInsertNodeThread = new Thread(() -> {
                try {
                    Assert.assertEquals((Object)node1, (Object)cache.getInsertNode(position));
                }
                catch (Throwable e) {
                    failure.set(true);
                }
            });
            threadList.add(getInsertNodeThread);
            getInsertNodeThread.start();
        }
        Awaitility.await().until(() -> {
            for (Thread thread : threadList) {
                if (!thread.isAlive()) continue;
                return false;
            }
            return true;
        });
        Assert.assertFalse((boolean)failure.get());
    }

    @Test
    public void testLoadUnsealedWALFile() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode.onMemTableCreated((IMemTable)memTable, logDirectory + "/fake.tsfile");
        InsertRowNode node1 = this.getInsertRowNode(System.currentTimeMillis());
        node1.setSearchIndex(1L);
        WALFlushListener flushListener = this.walNode.log(memTable.getMemTableId(), node1);
        WALEntryPosition position = flushListener.getWalEntryHandler().getWalEntryPosition();
        Awaitility.await().until(() -> this.walNode.isAllWALEntriesConsumed() && position.canRead());
        Assert.assertEquals((Object)node1, (Object)cache.getInsertNode(position));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchLoad() throws Exception {
        boolean oldIsBatchLoadEnabled = cache.isBatchLoadEnabled();
        cache.setIsBatchLoadEnabled(true);
        WALInsertNodeCache localC = cache;
        try {
            PrimitiveMemTable memTable1 = new PrimitiveMemTable(databasePath, dataRegionId);
            this.walNode.onMemTableCreated((IMemTable)memTable1, logDirectory + "/fake1.tsfile");
            InsertRowNode node1 = this.getInsertRowNode(System.currentTimeMillis());
            node1.setSearchIndex(1L);
            WALFlushListener flushListener1 = this.walNode.log(memTable1.getMemTableId(), node1);
            WALEntryPosition position1 = flushListener1.getWalEntryHandler().getWalEntryPosition();
            InsertRowNode node2 = this.getInsertRowNode(System.currentTimeMillis());
            node1.setSearchIndex(2L);
            WALFlushListener flushListener2 = this.walNode.log(memTable1.getMemTableId(), node2);
            WALEntryPosition position2 = flushListener2.getWalEntryHandler().getWalEntryPosition();
            PrimitiveMemTable memTable2 = new PrimitiveMemTable(databasePath, dataRegionId);
            this.walNode.onMemTableCreated((IMemTable)memTable2, logDirectory + "/fake2.tsfile");
            InsertRowNode node3 = this.getInsertRowNode(System.currentTimeMillis());
            node1.setSearchIndex(3L);
            WALFlushListener flushListener3 = this.walNode.log(memTable2.getMemTableId(), node3);
            WALEntryPosition position3 = flushListener3.getWalEntryHandler().getWalEntryPosition();
            this.walNode.rollWALFile();
            Awaitility.await().until(() -> this.walNode.isAllWALEntriesConsumed() && position3.canRead());
            cache.clear();
            cache.addMemTable(memTable1.getMemTableId());
            Assert.assertEquals((Object)node1, (Object)cache.getInsertNode(position1));
            Assert.assertTrue((boolean)cache.contains(position1));
            Assert.assertTrue((boolean)cache.contains(position2));
            Assert.assertFalse((boolean)cache.contains(position3));
            cache.removeMemTable(memTable1.getMemTableId());
            cache.clear();
            Assert.assertEquals((Object)node1, (Object)cache.getInsertNode(position1));
            Assert.assertTrue((boolean)cache.contains(position1));
            Assert.assertFalse((boolean)cache.contains(position2));
            Assert.assertFalse((boolean)cache.contains(position3));
        }
        finally {
            WALInsertNodeCache.getInstance((Integer)1).setIsBatchLoadEnabled(oldIsBatchLoadEnabled);
        }
    }

    private InsertRowNode getInsertRowNode(long time) throws IllegalPathException {
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false, new Binary("hh0", TSFileConfig.STRING_CHARSET)};
        InsertRowNode node = new InsertRowNode(new PlanNodeId(""), new PartialPath(devicePath), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, time, columns, false);
        MeasurementSchema[] schemas = new MeasurementSchema[6];
        for (int i = 0; i < 6; ++i) {
            schemas[i] = new MeasurementSchema("s" + (i + 1), dataTypes[i]);
        }
        node.setMeasurementSchemas(schemas);
        return node;
    }
}

