/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.recover.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALRecoverException;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.TsFileUtilsForRecoverTest;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnsealedTsFileRecoverPerformerTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String SG_NAME = "root.recover_sg";
    private static final IDeviceID DEVICE1_NAME = new PlainDeviceID("root.recover_sg".concat(".d1"));
    private static final IDeviceID DEVICE2_NAME = new PlainDeviceID("root.recover_sg".concat(".d2"));
    private static final String FILE_NAME = TsFileUtilsForRecoverTest.getTestTsFilePath("root.recover_sg", 0L, 0L, 1L);
    private TsFileResource tsFileResource;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(new File(FILE_NAME).getParent());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        if (this.tsFileResource != null) {
            this.tsFileResource.close();
        }
        EnvironmentUtils.cleanDir(new File(FILE_NAME).getParent());
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testRedoInsertPlan() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCrashedFile(file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".resource")).exists());
        long time = 4L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.DOUBLE};
        Object[] columns = new Object[]{Float.valueOf(1.0f), 1.0};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId(""), new PartialPath(DEVICE2_NAME), false, new String[]{"s1", "s2"}, dataTypes, time, columns, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.FLOAT), new MeasurementSchema("s2", TSDataType.DOUBLE)});
        int fakeMemTableId = 1;
        WALInfoEntry walEntry = new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)insertRowNode);
        this.tsFileResource = new TsFileResource(file);
        try (UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(this.tsFileResource, true, performer -> Assert.assertFalse((boolean)performer.canWrite()));){
            recoverPerformer.startRecovery();
            Assert.assertTrue((boolean)recoverPerformer.hasCrashed());
            Assert.assertTrue((boolean)recoverPerformer.canWrite());
            Assert.assertEquals((long)3L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
            recoverPerformer.redoLog((WALEntry)walEntry);
            recoverPerformer.endRecovery();
        }
        TsFileSequenceReader reader = new TsFileSequenceReader(FILE_NAME);
        List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        Assert.assertEquals((long)2L, (long)chunkMetadataList.size());
        Chunk chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(0));
        Assert.assertEquals((long)3L, (long)chunk.getChunkStatistic().getEndTime());
        chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(1));
        Assert.assertEquals((long)4L, (long)chunk.getChunkStatistic().getEndTime());
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)4L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".resource")).exists());
    }

    @Test
    public void testRedoDeletePlan() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCrashedFile(file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".resource")).exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".mods")).exists());
        DeleteDataNode deleteDataNode = new DeleteDataNode(new PlanNodeId("0"), Collections.singletonList(new PartialPath(DEVICE2_NAME)), Long.MIN_VALUE, Long.MAX_VALUE);
        int fakeMemTableId = 1;
        WALInfoEntry walEntry = new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)deleteDataNode);
        this.tsFileResource = new TsFileResource(file);
        try (UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(this.tsFileResource, true, performer -> Assert.assertFalse((boolean)performer.canWrite()));){
            recoverPerformer.startRecovery();
            Assert.assertTrue((boolean)recoverPerformer.hasCrashed());
            Assert.assertTrue((boolean)recoverPerformer.canWrite());
            Assert.assertEquals((long)3L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
            recoverPerformer.redoLog((WALEntry)walEntry);
            recoverPerformer.endRecovery();
        }
        TsFileSequenceReader reader = new TsFileSequenceReader(FILE_NAME);
        List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        Assert.assertEquals((long)1L, (long)chunkMetadataList.size());
        Chunk chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(0));
        Assert.assertEquals((long)3L, (long)chunk.getChunkStatistic().getEndTime());
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".resource")).exists());
        Assert.assertTrue((boolean)new File(FILE_NAME.concat(".mods")).exists());
    }

    private void generateCrashedFile(File tsFile) throws IOException, WriteProcessException {
        long truncateSize;
        try (TsFileWriter writer = new TsFileWriter(tsFile);){
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s1", TSDataType.FLOAT, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s2", TSDataType.DOUBLE, TSEncoding.RLE));
            writer.write(new TSRecord(1L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 1)).addTuple((DataPoint)new LongDataPoint("s2", 1L)));
            writer.write(new TSRecord(2L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 2)).addTuple((DataPoint)new LongDataPoint("s2", 2L)));
            writer.write(new TSRecord(3L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 3.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 3.0)));
            writer.flushAllChunkGroups();
            try (FileChannel channel = new FileInputStream(tsFile).getChannel();){
                truncateSize = channel.size();
            }
            writer.write(new TSRecord(4L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 4.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 4.0)));
            writer.flushAllChunkGroups();
            channel = new FileInputStream(tsFile).getChannel();
            try {
                truncateSize = (truncateSize + channel.size()) / 2L;
            }
            finally {
                if (channel != null) {
                    channel.close();
                }
            }
        }
        try (FileChannel channel = new FileOutputStream(tsFile, true).getChannel();){
            channel.truncate(truncateSize);
        }
    }

    @Test
    public void testRecoverNullInsertRowPlan() throws Exception {
        File file = new File(FILE_NAME);
        this.generateCrashedFile(file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".resource")).exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".mods")).exists());
        long time = 4L;
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId("plannode 1"), new PartialPath(DEVICE2_NAME), false, new String[]{"s1"}, new TSDataType[]{TSDataType.INT64}, time, (Object[])new Integer[]{1}, false);
        insertRowNode.markFailedMeasurement(0);
        time = 5L;
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId("plannode 2"), new PartialPath(DEVICE2_NAME), false, new String[]{"s1"}, new TSDataType[]{TSDataType.INT64}, null, new long[]{time}, null, (Object[])new Integer[]{1}, 1);
        insertTabletNode.markFailedMeasurement(0);
        int fakeMemTableId = 1;
        WALInfoEntry walEntry1 = new WALInfoEntry((long)fakeMemTableId++, (WALEntryValue)insertRowNode);
        WALInfoEntry walEntry2 = new WALInfoEntry((long)fakeMemTableId, (WALEntryValue)insertTabletNode);
        this.tsFileResource = new TsFileResource(file);
        try (UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(this.tsFileResource, true, performer -> Assert.assertFalse((boolean)performer.canWrite()));){
            recoverPerformer.startRecovery();
            Assert.assertTrue((boolean)recoverPerformer.hasCrashed());
            Assert.assertTrue((boolean)recoverPerformer.canWrite());
            recoverPerformer.redoLog((WALEntry)walEntry1);
            recoverPerformer.redoLog((WALEntry)walEntry2);
            recoverPerformer.endRecovery();
        }
    }

    @Test
    public void testRecoverDuplicate() throws IllegalPathException, IOException, WriteProcessException, DataRegionException, WALRecoverException {
        File file = new File(FILE_NAME);
        this.generateCrashedFile(file);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".resource")).exists());
        Assert.assertFalse((boolean)new File(FILE_NAME.concat(".mods")).exists());
        this.tsFileResource = new TsFileResource(file);
        int fakeMemTableId = 1;
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        memTable.setDatabaseAndDataRegionId(SG_NAME, "0");
        ArrayList<MeasurementSchema> schemaList = new ArrayList<MeasurementSchema>();
        schemaList.add(new MeasurementSchema("s1", TSDataType.INT32));
        memTable.write(DEVICE1_NAME, schemaList, 1L, new Object[]{100000});
        WALInfoEntry duplicateMemTableSnapshotWalEntry = new WALInfoEntry((long)fakeMemTableId++, (WALEntryValue)memTable);
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId("plannode 1"), new PartialPath(DEVICE1_NAME), false, new String[]{"s1"}, new TSDataType[]{TSDataType.INT32}, 2L, (Object[])new Integer[]{20}, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.INT32)});
        WALInfoEntry duplicateWalEntry = new WALInfoEntry((long)fakeMemTableId++, (WALEntryValue)insertRowNode);
        InsertRowNode insertRowNode2 = new InsertRowNode(new PlanNodeId("plannode 2"), new PartialPath(DEVICE1_NAME), false, new String[]{"s1"}, new TSDataType[]{TSDataType.INT32}, 10L, (Object[])new Integer[]{10}, false);
        insertRowNode2.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.INT32)});
        WALInfoEntry normalWalEntry = new WALInfoEntry((long)fakeMemTableId++, (WALEntryValue)insertRowNode2);
        try (UnsealedTsFileRecoverPerformer performer = new UnsealedTsFileRecoverPerformer(this.tsFileResource, true, p -> Assert.assertFalse((boolean)p.canWrite()));){
            performer.startRecovery();
            performer.redoLog((WALEntry)duplicateMemTableSnapshotWalEntry);
            performer.redoLog((WALEntry)duplicateWalEntry);
            performer.redoLog((WALEntry)normalWalEntry);
            performer.endRecovery();
            performer.getTsFileResource();
        }
        try (TsFileSequenceReader reader = new TsFileSequenceReader(FILE_NAME);){
            List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1", true));
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                Chunk chunk = reader.readMemChunk(chunkMetadata);
                ChunkReader chunkReader = new ChunkReader(chunk);
                while (chunkReader.hasNextSatisfiedPage()) {
                    BatchData batchData = chunkReader.nextPageData();
                    while (batchData.hasCurrent()) {
                        Assert.assertEquals((Object)((int)batchData.currentTime()), (Object)batchData.currentValue());
                        batchData.next();
                    }
                }
            }
        }
    }
}

