/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.recover;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.concurrent.ExceptionalCountDownLatch;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALBuffer;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALInfoEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.CheckpointManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.WALRecoverManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.TsFileUtilsForRecoverTest;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALRecoverListener;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WALRecoverManagerTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private static final String SG_NAME = "root.recover_sg";
    private static final String DATA_REGION_ID = "1";
    private static final IDeviceID DEVICE1_NAME = new PlainDeviceID("root.recover_sg".concat(".d1"));
    private static final IDeviceID DEVICE2_NAME = new PlainDeviceID("root.recover_sg".concat(".d2"));
    private static final String FILE_WITH_WAL_NAME = TsFileUtilsForRecoverTest.getTestTsFilePath("root.recover_sg", 0L, 0L, 1L);
    private static final String FILE_WITHOUT_WAL_NAME = TsFileUtilsForRecoverTest.getTestTsFilePath("root.recover_sg", 0L, 1L, 1L);
    private static final String WAL_NODE_IDENTIFIER = String.valueOf(Integer.MAX_VALUE);
    private static final String WAL_NODE_FOLDER = commonConfig.getWalDirs()[0].concat(File.separator + WAL_NODE_IDENTIFIER);
    private static final WALRecoverManager recoverManager = WALRecoverManager.getInstance();
    private WALMode prevMode;
    private WALBuffer walBuffer;
    private CheckpointManager checkpointManager;
    private TsFileResource tsFileWithWALResource;
    private TsFileResource tsFileWithoutWALResource;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(new File(FILE_WITH_WAL_NAME).getParent());
        EnvironmentUtils.envSetUp();
        this.prevMode = config.getWalMode();
        config.setWalMode(WALMode.SYNC);
        this.walBuffer = new WALBuffer(WAL_NODE_IDENTIFIER, WAL_NODE_FOLDER);
        this.checkpointManager = this.walBuffer.getCheckpointManager();
    }

    @After
    public void tearDown() throws Exception {
        if (this.tsFileWithWALResource != null) {
            this.tsFileWithWALResource.close();
        }
        if (this.tsFileWithoutWALResource != null) {
            this.tsFileWithoutWALResource.close();
        }
        this.checkpointManager.close();
        this.walBuffer.close();
        config.setWalMode(this.prevMode);
        EnvironmentUtils.cleanDir(new File(FILE_WITH_WAL_NAME).getParent());
        EnvironmentUtils.cleanDir(new File(FILE_WITHOUT_WAL_NAME).getParent());
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testNormalProcedure() throws Exception {
        this.prepareCheckpointAndWALFileForNormal();
        WALRecoverManager.getInstance().clear();
        this.recoverAndCheck();
    }

    private void prepareCheckpointAndWALFileForNormal() throws MetadataException, ExecutionException, InterruptedException, QueryProcessException {
        int threadsNum = 5;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        long firstWALVersionId = this.walBuffer.getCurrentWALFileVersion();
        for (int i = 0; i < threadsNum; ++i) {
            PrimitiveMemTable primitiveMemTable = new PrimitiveMemTable(SG_NAME, DATA_REGION_ID);
            long memTableId = primitiveMemTable.getMemTableId();
            Callable<Void> writeTask = () -> this.lambda$prepareCheckpointAndWALFileForNormal$0((IMemTable)primitiveMemTable, firstWALVersionId, memTableId);
            Future<Void> future = executorService.submit(writeTask);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        Awaitility.await().until(() -> this.walBuffer.isAllWALEntriesConsumed());
        long firstValidVersionId = this.walBuffer.getCurrentWALFileVersion();
        PrimitiveMemTable targetMemTable = new PrimitiveMemTable(SG_NAME, DATA_REGION_ID);
        WALInfoEntry walEntry = new WALInfoEntry(targetMemTable.getMemTableId(), (WALEntryValue)this.getInsertRowNode(((PlainDeviceID)DEVICE2_NAME).toStringID(), 4L), true);
        this.walBuffer.write((WALEntry)walEntry);
        walEntry.getWalFlushListener().waitForResult();
        walEntry = new WALInfoEntry(targetMemTable.getMemTableId(), (WALEntryValue)this.getInsertRowsNode(((PlainDeviceID)DEVICE2_NAME).toStringID(), 5L), true);
        this.walBuffer.write((WALEntry)walEntry);
        walEntry.getWalFlushListener().waitForResult();
        MemTableInfo memTableInfo = new MemTableInfo((IMemTable)targetMemTable, FILE_WITH_WAL_NAME, firstValidVersionId);
        this.checkpointManager.makeCreateMemTableCPInMemory(memTableInfo);
        this.checkpointManager.makeCreateMemTableCPOnDisk(memTableInfo.getMemTableId());
        this.checkpointManager.fsyncCheckpointFile();
    }

    @Test
    public void testMemTableSnapshot() throws Exception {
        this.prepareCheckpointAndWALFileForSnapshot();
        WALRecoverManager.getInstance().clear();
        this.recoverAndCheck();
    }

    private void prepareCheckpointAndWALFileForSnapshot() throws MetadataException, ExecutionException, InterruptedException, QueryProcessException {
        int threadsNum = 5;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        long firstWALVersionId = this.walBuffer.getCurrentWALFileVersion();
        for (int i = 0; i < threadsNum; ++i) {
            PrimitiveMemTable primitiveMemTable = new PrimitiveMemTable(SG_NAME, DATA_REGION_ID);
            long memTableId = primitiveMemTable.getMemTableId();
            Callable<Void> writeTask = () -> this.lambda$prepareCheckpointAndWALFileForSnapshot$2((IMemTable)primitiveMemTable, firstWALVersionId, memTableId);
            Future<Void> future = executorService.submit(writeTask);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        Awaitility.await().until(() -> this.walBuffer.isAllWALEntriesConsumed());
        long firstValidVersionId = this.walBuffer.getCurrentWALFileVersion();
        PrimitiveMemTable targetMemTable = new PrimitiveMemTable(SG_NAME, DATA_REGION_ID);
        InsertRowNode insertRowNode = this.getInsertRowNode(((PlainDeviceID)DEVICE2_NAME).toStringID(), 4L);
        targetMemTable.insert(insertRowNode);
        WALInfoEntry walEntry = new WALInfoEntry(targetMemTable.getMemTableId(), (WALEntryValue)insertRowNode, true);
        this.walBuffer.write((WALEntry)walEntry);
        walEntry.getWalFlushListener().waitForResult();
        InsertRowsNode insertRowsNode = this.getInsertRowsNode(((PlainDeviceID)DEVICE2_NAME).toStringID(), 5L);
        for (InsertRowNode node : insertRowsNode.getInsertRowNodeList()) {
            targetMemTable.insert(node);
        }
        walEntry = new WALInfoEntry(targetMemTable.getMemTableId(), (WALEntryValue)insertRowsNode, true);
        this.walBuffer.write((WALEntry)walEntry);
        walEntry.getWalFlushListener().waitForResult();
        walEntry = new WALInfoEntry(targetMemTable.getMemTableId(), (WALEntryValue)targetMemTable, true);
        this.walBuffer.write((WALEntry)walEntry);
        walEntry.getWalFlushListener().waitForResult();
        MemTableInfo memTableInfo = new MemTableInfo((IMemTable)targetMemTable, FILE_WITH_WAL_NAME, firstValidVersionId);
        this.checkpointManager.makeCreateMemTableCPInMemory(memTableInfo);
        this.checkpointManager.makeCreateMemTableCPOnDisk(memTableInfo.getMemTableId());
        this.checkpointManager.fsyncCheckpointFile();
    }

    private void recoverAndCheck() throws Exception {
        List<WALRecoverListener> recoverListeners = this.prepareCrashedTsFile();
        recoverManager.setAllDataRegionScannedLatch(new ExceptionalCountDownLatch(0));
        recoverManager.recover();
        try {
            for (WALRecoverListener recoverListener : recoverListeners) {
                Assert.assertEquals((Object)AbstractResultListener.Status.SUCCESS, (Object)recoverListener.waitForResult());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TsFileSequenceReader reader = new TsFileSequenceReader(FILE_WITH_WAL_NAME);
        List chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        Assert.assertEquals((long)2L, (long)chunkMetadataList.size());
        Chunk chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(0));
        Assert.assertEquals((long)3L, (long)chunk.getChunkStatistic().getEndTime());
        chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(1));
        Assert.assertEquals((long)15L, (long)chunk.getChunkStatistic().getEndTime());
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileWithWALResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileWithWALResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileWithWALResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)15L, (long)this.tsFileWithWALResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)new File(FILE_WITH_WAL_NAME).exists());
        Assert.assertTrue((boolean)new File(FILE_WITH_WAL_NAME.concat(".resource")).exists());
        reader = new TsFileSequenceReader(FILE_WITHOUT_WAL_NAME);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE1_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s1", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        chunkMetadataList = reader.getChunkMetadataList(new Path(DEVICE2_NAME, "s2", true));
        Assert.assertNotNull((Object)chunkMetadataList);
        Assert.assertEquals((long)1L, (long)chunkMetadataList.size());
        chunk = reader.readMemChunk((ChunkMetadata)chunkMetadataList.get(0));
        Assert.assertEquals((long)3L, (long)chunk.getChunkStatistic().getEndTime());
        reader.close();
        Assert.assertEquals((long)1L, (long)this.tsFileWithoutWALResource.getStartTime(DEVICE1_NAME));
        Assert.assertEquals((long)2L, (long)this.tsFileWithoutWALResource.getEndTime(DEVICE1_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileWithoutWALResource.getStartTime(DEVICE2_NAME));
        Assert.assertEquals((long)3L, (long)this.tsFileWithoutWALResource.getEndTime(DEVICE2_NAME));
        Assert.assertTrue((boolean)new File(FILE_WITHOUT_WAL_NAME).exists());
        Assert.assertTrue((boolean)new File(FILE_WITHOUT_WAL_NAME.concat(".resource")).exists());
    }

    private InsertRowNode getInsertRowNode(String devicePath, long time) throws MetadataException, QueryProcessException {
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.DOUBLE};
        Object[] columns = new Object[]{Float.valueOf(1.0f), 1.0};
        PartialPath path = new PartialPath(devicePath);
        String[] measurements = new String[]{"s1", "s2"};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId(""), path, false, measurements, dataTypes, time, columns, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.FLOAT), new MeasurementSchema("s2", TSDataType.DOUBLE)});
        return insertRowNode;
    }

    private InsertRowsNode getInsertRowsNode(String devicePath, long time) throws MetadataException, QueryProcessException {
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.DOUBLE};
        Object[] columns = new Object[]{Float.valueOf(1.0f), 1.0};
        PartialPath path = new PartialPath(devicePath);
        String[] measurements = new String[]{"s1", "s2"};
        InsertRowNode insertRowNode = new InsertRowNode(new PlanNodeId(""), path, false, measurements, dataTypes, time, columns, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.FLOAT), new MeasurementSchema("s2", TSDataType.DOUBLE)});
        InsertRowsNode insertRowsNode = new InsertRowsNode(new PlanNodeId(""));
        insertRowsNode.addOneInsertRowNode(insertRowNode, 0);
        insertRowNode = new InsertRowNode(new PlanNodeId(""), path, false, measurements, dataTypes, time + 10L, columns, false);
        insertRowNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.FLOAT), new MeasurementSchema("s2", TSDataType.DOUBLE)});
        insertRowsNode.addOneInsertRowNode(insertRowNode, 1);
        return insertRowsNode;
    }

    private InsertTabletNode getInsertTabletNode(String devicePath) throws IllegalPathException {
        long[] times = new long[]{110L, 111L, 112L, 113L};
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        dataTypes.add(TSDataType.DOUBLE);
        dataTypes.add(TSDataType.FLOAT);
        dataTypes.add(TSDataType.INT64);
        dataTypes.add(TSDataType.INT32);
        dataTypes.add(TSDataType.BOOLEAN);
        dataTypes.add(TSDataType.TEXT);
        Object[] columns = new Object[]{new double[times.length], new float[times.length], new long[times.length], new int[times.length], new boolean[times.length], new Binary[times.length]};
        for (int r = 0; r < times.length; ++r) {
            ((double[])columns[0])[r] = 1.0 + (double)r;
            ((float[])columns[1])[r] = 2 + r;
            ((long[])columns[2])[r] = 10000 + r;
            ((int[])columns[3])[r] = 100 + r;
            ((boolean[])columns[4])[r] = r % 2 == 0;
            ((Binary[])columns[5])[r] = new Binary("hh" + r, TSFileConfig.STRING_CHARSET);
        }
        BitMap[] bitMaps = new BitMap[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            if (bitMaps[i] == null) {
                bitMaps[i] = new BitMap(times.length);
            }
            bitMaps[i].mark(i % times.length);
        }
        InsertTabletNode insertTabletNode = new InsertTabletNode(new PlanNodeId(""), new PartialPath(devicePath), true, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes.toArray(new TSDataType[0]), times, bitMaps, columns, times.length);
        insertTabletNode.setMeasurementSchemas(new MeasurementSchema[]{new MeasurementSchema("s1", TSDataType.DOUBLE), new MeasurementSchema("s2", TSDataType.FLOAT), new MeasurementSchema("s3", TSDataType.INT64), new MeasurementSchema("s4", TSDataType.INT32), new MeasurementSchema("s5", TSDataType.BOOLEAN), new MeasurementSchema("s6", TSDataType.TEXT)});
        return insertTabletNode;
    }

    private List<WALRecoverListener> prepareCrashedTsFile() throws IOException, WriteProcessException {
        ArrayList<WALRecoverListener> recoverListeners = new ArrayList<WALRecoverListener>();
        File fileWithWAL = new File(FILE_WITH_WAL_NAME);
        this.generateCrashedFile(fileWithWAL);
        this.tsFileWithWALResource = new TsFileResource(fileWithWAL);
        UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(this.tsFileWithWALResource, true, performer -> Assert.assertFalse((boolean)performer.canWrite()));
        recoverManager.addRecoverPerformer(recoverPerformer);
        recoverListeners.add(recoverPerformer.getRecoverListener());
        File fileWithoutWAL = new File(FILE_WITHOUT_WAL_NAME);
        this.generateCrashedFile(fileWithoutWAL);
        this.tsFileWithoutWALResource = new TsFileResource(fileWithoutWAL);
        recoverPerformer = new UnsealedTsFileRecoverPerformer(this.tsFileWithoutWALResource, true, performer -> Assert.assertFalse((boolean)performer.canWrite()));
        recoverManager.addRecoverPerformer(recoverPerformer);
        recoverListeners.add(recoverPerformer.getRecoverListener());
        return recoverListeners;
    }

    private void generateCrashedFile(File tsFile) throws IOException, WriteProcessException {
        long truncateSize;
        try (TsFileWriter writer = new TsFileWriter(tsFile);){
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE1_NAME), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s1", TSDataType.FLOAT, TSEncoding.RLE));
            writer.registerTimeseries(new Path(DEVICE2_NAME), new MeasurementSchema("s2", TSDataType.DOUBLE, TSEncoding.RLE));
            writer.write(new TSRecord(1L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 1)).addTuple((DataPoint)new LongDataPoint("s2", 1L)));
            writer.write(new TSRecord(2L, DEVICE1_NAME).addTuple((DataPoint)new IntDataPoint("s1", 2)).addTuple((DataPoint)new LongDataPoint("s2", 2L)));
            writer.write(new TSRecord(3L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 3.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 3.0)));
            writer.flushAllChunkGroups();
            try (FileChannel channel = new FileInputStream(tsFile).getChannel();){
                truncateSize = channel.size();
            }
            writer.write(new TSRecord(4L, DEVICE2_NAME).addTuple((DataPoint)new FloatDataPoint("s1", 4.0f)).addTuple((DataPoint)new DoubleDataPoint("s2", 4.0)));
            writer.flushAllChunkGroups();
            channel = new FileInputStream(tsFile).getChannel();
            try {
                truncateSize = (truncateSize + channel.size()) / 2L;
            }
            finally {
                if (channel != null) {
                    channel.close();
                }
            }
        }
        try (FileChannel channel = new FileOutputStream(tsFile, true).getChannel();){
            channel.truncate(truncateSize);
        }
    }

    private /* synthetic */ Void lambda$prepareCheckpointAndWALFileForSnapshot$2(IMemTable fakeMemTable, long firstWALVersionId, long memTableId) throws Exception {
        MemTableInfo memTableInfo = new MemTableInfo(fakeMemTable, "fake.tsfile", 0L);
        this.checkpointManager.makeCreateMemTableCPInMemory(memTableInfo);
        this.checkpointManager.makeCreateMemTableCPOnDisk(memTableInfo.getMemTableId());
        try {
            while (this.walBuffer.getCurrentWALFileVersion() - firstWALVersionId < 2L) {
                WALInfoEntry walEntry = new WALInfoEntry(memTableId, (WALEntryValue)this.getInsertTabletNode(SG_NAME.concat("test_d" + memTableId)));
                this.walBuffer.write((WALEntry)walEntry);
            }
        }
        catch (IllegalPathException e) {
            Assert.fail();
        }
        this.checkpointManager.makeFlushMemTableCP(fakeMemTable.getMemTableId());
        return null;
    }

    private /* synthetic */ Void lambda$prepareCheckpointAndWALFileForNormal$0(IMemTable fakeMemTable, long firstWALVersionId, long memTableId) throws Exception {
        MemTableInfo memTableInfo = new MemTableInfo(fakeMemTable, "fake.tsfile", 0L);
        this.checkpointManager.makeCreateMemTableCPInMemory(memTableInfo);
        this.checkpointManager.makeCreateMemTableCPOnDisk(memTableInfo.getMemTableId());
        try {
            while (this.walBuffer.getCurrentWALFileVersion() - firstWALVersionId < 2L) {
                WALInfoEntry walEntry = new WALInfoEntry(memTableId, (WALEntryValue)this.getInsertTabletNode(SG_NAME.concat("test_d" + memTableId)));
                this.walBuffer.write((WALEntry)walEntry);
            }
        }
        catch (IllegalPathException e) {
            Assert.fail();
        }
        this.checkpointManager.makeFlushMemTableCP(fakeMemTable.getMemTableId());
        return null;
    }
}

