/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.node;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.consensus.iot.log.ConsensusReqReader;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionTest;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.MemTablePinException;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileUtils;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALInsertNodeCache;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WalDeleteOutdatedNewTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String identifier1 = String.valueOf(Integer.MAX_VALUE);
    private static final String logDirectory1 = TestConstant.BASE_OUTPUT_PATH.concat("sequence/root.test_sg/1/2910/");
    private static final String databasePath = "root.test_sg";
    private static final String devicePath = "root.test_sg.test_d";
    private static final String dataRegionId = "1";
    private WALMode prevMode;
    private String prevConsensus;
    private WALNode walNode1;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(logDirectory1);
        this.prevMode = config.getWalMode();
        this.prevConsensus = config.getDataRegionConsensusProtocolClass();
        config.setWalMode(WALMode.SYNC);
        config.setDataRegionConsensusProtocolClass("org.apache.iotdb.consensus.ratis.RatisConsensus");
        this.walNode1 = new WALNode(identifier1, logDirectory1);
        DataRegionTest.DummyDataRegion dataRegion = new DataRegionTest.DummyDataRegion(logDirectory1, databasePath);
        dataRegion.updatePartitionFileVersion(2911L, 0L);
        StorageEngine.getInstance().setDataRegion(new DataRegionId(1), (DataRegion)dataRegion);
    }

    @After
    public void tearDown() throws Exception {
        this.walNode1.close();
        config.setWalMode(this.prevMode);
        config.setDataRegionConsensusProtocolClass(this.prevConsensus);
        EnvironmentUtils.cleanDir(logDirectory1);
        StorageEngine.getInstance().reset();
        WALInsertNodeCache.getInstance((Integer)1).clear();
    }

    @Test
    public void test01() throws IllegalPathException {
        PrimitiveMemTable memTable1 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable1, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 1L));
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 2L));
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 3L));
        PrimitiveMemTable memTable2 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable2, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 4L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 5L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 6L));
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        Map memTableIdsOfWal = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)1L, (long)memTableIdsOfWal.size());
        Assert.assertEquals((long)2L, (long)((Set)memTableIdsOfWal.get(0L)).size());
        Assert.assertEquals((long)1L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
        this.walNode1.close();
    }

    @Test
    public void test02() throws IllegalPathException {
        PrimitiveMemTable memTable1 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable1, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 1L));
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 2L));
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 3L));
        PrimitiveMemTable memTable2 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable2, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 4L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 5L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 6L));
        this.walNode1.rollWALFile();
        this.walNode1.onMemTableCreated((IMemTable)memTable2, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 7L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 8L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 9L));
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        Map memTableIdsOfWal = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)2L, (long)memTableIdsOfWal.size());
        Assert.assertEquals((long)1L, (long)((Set)memTableIdsOfWal.get(1L)).size());
        Assert.assertEquals((long)2L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
    }

    @Test
    public void test03() throws IllegalPathException {
        PrimitiveMemTable memTable0 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable0, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 1L));
        PrimitiveMemTable memTable1 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable1, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 2L));
        this.walNode1.rollWALFile();
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 3L));
        Map memTableIdsOfWal = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        this.walNode1.onMemTableFlushed((IMemTable)memTable0);
        this.walNode1.onMemTableFlushed((IMemTable)memTable1);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        Assert.assertEquals((long)2L, (long)memTableIdsOfWal.size());
        Assert.assertEquals((long)2L, (long)((Set)memTableIdsOfWal.get(0L)).size());
        File[] files = WALFileUtils.listAllWALFiles((File)new File(logDirectory1));
        Assert.assertEquals((long)2L, (long)files.length);
        this.walNode1.deleteOutdatedFiles();
        Map memTableIdsOfWalAfter = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)0L, (long)memTableIdsOfWalAfter.size());
        File[] filesAfter = WALFileUtils.listAllWALFiles((File)new File(logDirectory1));
        Assert.assertEquals((long)1L, (long)filesAfter.length);
    }

    @Test
    public void test04() throws IllegalPathException {
        PrimitiveMemTable memTable0 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable0, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 1L));
        this.walNode1.rollWALFile();
        PrimitiveMemTable memTable1 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable1, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.rollWALFile();
        PrimitiveMemTable memTable2 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable2, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 2L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 3L));
        this.walNode1.onMemTableFlushed((IMemTable)memTable2);
        this.walNode1.onMemTableFlushed((IMemTable)memTable0);
        this.walNode1.onMemTableFlushed((IMemTable)memTable1);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        Map memTableIdsOfWal = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)3L, (long)memTableIdsOfWal.size());
        Assert.assertEquals((long)3L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
        this.walNode1.deleteOutdatedFiles();
        Map memTableIdsOfWalAfter = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)0L, (long)memTableIdsOfWalAfter.size());
        Assert.assertEquals((long)1L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
    }

    @Test
    public void test05() throws IllegalPathException, MemTablePinException {
        PrimitiveMemTable memTable0 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable0, logDirectory1 + "/fake.tsfile");
        WALFlushListener listener = this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 1L));
        this.walNode1.rollWALFile();
        WALEntryHandler handler = listener.getWalEntryHandler();
        handler.pinMemTable();
        this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 2L));
        PrimitiveMemTable memTable1 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable1, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 3L));
        this.walNode1.rollWALFile();
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 4L));
        this.walNode1.rollWALFile();
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 5L));
        this.walNode1.onMemTableFlushed((IMemTable)memTable0);
        this.walNode1.onMemTableFlushed((IMemTable)memTable1);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        Map memTableIdsOfWal = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)4L, (long)memTableIdsOfWal.size());
        Assert.assertEquals((long)4L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
        this.walNode1.deleteOutdatedFiles();
        Map memTableIdsOfWalAfter = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)3L, (long)memTableIdsOfWalAfter.size());
        Assert.assertEquals((long)3L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
    }

    @Test
    public void test06() throws IllegalPathException {
        PrimitiveMemTable memTable0 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable0, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 1L));
        this.walNode1.rollWALFile();
        this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 2L));
        this.walNode1.rollWALFile();
        this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 3L));
        this.walNode1.rollWALFile();
        this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 4L));
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        Map memTableIdsOfWal = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)4L, (long)memTableIdsOfWal.size());
        Assert.assertEquals((long)4L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
        this.walNode1.deleteOutdatedFiles();
        Map memTableIdsOfWalAfter = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)4L, (long)memTableIdsOfWalAfter.size());
        Assert.assertEquals((long)4L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
    }

    @Test
    public void test07() throws IllegalPathException {
        PrimitiveMemTable memTable0 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable0, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 1L));
        this.walNode1.rollWALFile();
        PrimitiveMemTable memTable1 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable1, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        PrimitiveMemTable memTable2 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable2, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.rollWALFile();
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.rollWALFile();
        PrimitiveMemTable memTable3 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable3, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable3.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.rollWALFile();
        this.walNode1.log(memTable3.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.onMemTableFlushed((IMemTable)memTable1);
        this.walNode1.onMemTableFlushed((IMemTable)memTable2);
        this.walNode1.onMemTableFlushed((IMemTable)memTable3);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        Map memTableIdsOfWal = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)5L, (long)memTableIdsOfWal.size());
        Assert.assertEquals((long)5L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
        this.walNode1.deleteOutdatedFiles();
        Map memTableIdsOfWalAfter = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)2L, (long)memTableIdsOfWalAfter.size());
        Assert.assertEquals((long)2L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
        this.walNode1.onMemTableFlushed((IMemTable)memTable0);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        this.walNode1.deleteOutdatedFiles();
        Map memTableIdsOfWalAfterAfter = this.walNode1.getWALBuffer().getMemTableIdsOfWal();
        Assert.assertEquals((long)0L, (long)memTableIdsOfWalAfterAfter.size());
        Assert.assertEquals((long)1L, (long)WALFileUtils.listAllWALFiles((File)new File(logDirectory1)).length);
    }

    @Test
    public void test08() throws IllegalPathException {
        PrimitiveMemTable memTable0 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable0, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 1L));
        this.walNode1.rollWALFile();
        ConsensusReqReader.ReqIterator itr1 = this.walNode1.getReqIterator(1L);
        Assert.assertFalse((boolean)itr1.hasNext());
        PrimitiveMemTable memTable1 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable1, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable1.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), -1L));
        this.walNode1.onMemTableFlushed((IMemTable)memTable1);
        this.walNode1.rollWALFile();
        ConsensusReqReader.ReqIterator itr2 = this.walNode1.getReqIterator(1L);
        Assert.assertTrue((boolean)itr2.hasNext());
        PrimitiveMemTable memTable2 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable2, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 2L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 3L));
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        ConsensusReqReader.ReqIterator itr3 = this.walNode1.getReqIterator(1L);
        Assert.assertTrue((boolean)itr3.hasNext());
        this.walNode1.deleteOutdatedFiles();
        ConsensusReqReader.ReqIterator itr4 = this.walNode1.getReqIterator(1L);
        Assert.assertFalse((boolean)itr4.hasNext());
        this.walNode1.rollWALFile();
        Assert.assertTrue((boolean)itr4.hasNext());
    }

    @Test
    public void test09() throws IllegalPathException {
        PrimitiveMemTable memTable0 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable0, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable0.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 1L));
        this.walNode1.rollWALFile();
        PrimitiveMemTable memTable2 = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable2, logDirectory1 + "/fake.tsfile");
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 2L));
        this.walNode1.log(memTable2.getMemTableId(), WalDeleteOutdatedNewTest.generateInsertRowNode(devicePath, System.currentTimeMillis(), 3L));
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        ConsensusReqReader.ReqIterator itr3 = this.walNode1.getReqIterator(1L);
        Assert.assertFalse((boolean)itr3.hasNext());
    }

    public static InsertRowNode generateInsertRowNode(String devicePath, long time, long searchIndex) throws IllegalPathException {
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false, new Binary("hh0", TSFileConfig.STRING_CHARSET)};
        InsertRowNode node = new InsertRowNode(new PlanNodeId(""), new PartialPath(devicePath), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, time, columns, false);
        MeasurementSchema[] schemas = new MeasurementSchema[6];
        for (int i = 0; i < 6; ++i) {
            schemas[i] = new MeasurementSchema("s" + (i + 1), dataTypes[i]);
        }
        node.setMeasurementSchemas(schemas);
        node.setSearchIndex(searchIndex);
        return node;
    }
}

