/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.node;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALFakeNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALFlushListener;
import org.junit.Assert;
import org.junit.Test;

public class WALFakeNodeTest {
    private IWALNode walNode;

    @Test
    public void testSuccessFakeNode() {
        this.walNode = WALFakeNode.getSuccessInstance();
        ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
        walFlushListeners.add(this.walNode.log(1L, new InsertRowNode(new PlanNodeId("0"))));
        walFlushListeners.add(this.walNode.log(1L, new InsertTabletNode(new PlanNodeId("1")), 0, 0));
        walFlushListeners.add(this.walNode.log(1L, new DeleteDataNode(new PlanNodeId("2"), Collections.emptyList(), 0L, 0L)));
        try {
            for (WALFlushListener walFlushListener : walFlushListeners) {
                Assert.assertNotEquals((Object)AbstractResultListener.Status.FAILURE, (Object)walFlushListener.waitForResult());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testFailureFakeNode() {
        Exception expectedException = new Exception("test");
        this.walNode = WALFakeNode.getFailureInstance((Exception)expectedException);
        ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
        walFlushListeners.add(this.walNode.log(1L, new InsertRowNode(new PlanNodeId("0"))));
        walFlushListeners.add(this.walNode.log(1L, new InsertTabletNode(new PlanNodeId("1")), 0, 0));
        walFlushListeners.add(this.walNode.log(1L, new DeleteDataNode(new PlanNodeId("2"), Collections.emptyList(), 0L, 0L)));
        try {
            for (WALFlushListener walFlushListener : walFlushListeners) {
                Assert.assertEquals((Object)AbstractResultListener.Status.FAILURE, (Object)walFlushListener.waitForResult());
                Assert.assertEquals((Object)expectedException, (Object)walFlushListener.getCause().getCause());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

