/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.node;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.iot.log.ConsensusReqReader;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.CheckpointManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.MemTablePinException;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.WALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALEntryHandler;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALInsertNodeCache;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WALEntryHandlerTest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String identifier1 = String.valueOf(Integer.MAX_VALUE);
    private static final String identifier2 = String.valueOf(0x7FFFFFFE);
    private static final String logDirectory1 = TestConstant.BASE_OUTPUT_PATH.concat("wal-test" + identifier1);
    private static final String logDirectory2 = TestConstant.BASE_OUTPUT_PATH.concat("wal-test" + identifier2);
    private static final String databasePath = "root.test_sg";
    private static final String devicePath = "root.test_sg.test_d";
    private static final String dataRegionId = "1";
    private WALMode prevMode;
    private WALNode walNode1;
    private WALNode walNode2;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(logDirectory1);
        EnvironmentUtils.cleanDir(logDirectory2);
        this.prevMode = config.getWalMode();
        config.setWalMode(WALMode.SYNC);
        this.walNode1 = new WALNode(identifier1, logDirectory1);
        this.walNode2 = new WALNode(identifier2, logDirectory2);
    }

    @After
    public void tearDown() throws Exception {
        this.walNode1.close();
        this.walNode2.close();
        config.setWalMode(this.prevMode);
        EnvironmentUtils.cleanDir(logDirectory1);
        EnvironmentUtils.cleanDir(logDirectory2);
        WALInsertNodeCache.getInstance((Integer)1).clear();
    }

    @Test(expected=MemTablePinException.class)
    public void pinDeletedMemTable1() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), this.getInsertRowNode(devicePath, System.currentTimeMillis()));
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
    }

    @Test(expected=MemTablePinException.class)
    public void pinDeletedMemTable2() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), this.getInsertRowsNode(devicePath, System.currentTimeMillis()));
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
    }

    @Test
    public void pinMemTable1() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        InsertRowNode node1 = this.getInsertRowNode(devicePath, System.currentTimeMillis());
        node1.setSearchIndex(1L);
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), node1);
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
        this.walNode1.rollWALFile();
        InsertRowNode node2 = this.getInsertRowNode(devicePath, System.currentTimeMillis());
        node2.setSearchIndex(2L);
        this.walNode1.log(memTable.getMemTableId(), node2);
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        this.walNode1.rollWALFile();
        ConsensusReqReader.ReqIterator itr = this.walNode1.getReqIterator(1L);
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((Object)node1, (Object)WALEntry.deserializeForConsensus((ByteBuffer)((IConsensusRequest)itr.next().getRequests().get(0)).serializeToByteBuffer()));
        this.walNode1.deleteOutdatedFiles();
        itr = this.walNode1.getReqIterator(1L);
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((Object)node1, (Object)WALEntry.deserializeForConsensus((ByteBuffer)((IConsensusRequest)itr.next().getRequests().get(0)).serializeToByteBuffer()));
    }

    @Test
    public void pinMemTable2() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        InsertRowsNode node1 = this.getInsertRowsNode(devicePath, System.currentTimeMillis());
        node1.setSearchIndex(1L);
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), node1);
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
        this.walNode1.rollWALFile();
        InsertRowsNode node2 = this.getInsertRowsNode(devicePath, System.currentTimeMillis());
        node2.setSearchIndex(2L);
        this.walNode1.log(memTable.getMemTableId(), node2);
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        this.walNode1.rollWALFile();
        ConsensusReqReader.ReqIterator itr = this.walNode1.getReqIterator(1L);
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((Object)node1, (Object)WALEntry.deserializeForConsensus((ByteBuffer)((IConsensusRequest)itr.next().getRequests().get(0)).serializeToByteBuffer()));
        this.walNode1.deleteOutdatedFiles();
        itr = this.walNode1.getReqIterator(1L);
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((Object)node1, (Object)WALEntry.deserializeForConsensus((ByteBuffer)((IConsensusRequest)itr.next().getRequests().get(0)).serializeToByteBuffer()));
    }

    @Test(expected=MemTablePinException.class)
    public void unpinDeletedMemTable1() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), this.getInsertRowNode(devicePath, System.currentTimeMillis()));
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.unpinMemTable();
    }

    @Test(expected=MemTablePinException.class)
    public void unpinDeletedMemTable2() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), this.getInsertRowsNode(devicePath, System.currentTimeMillis()));
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.unpinMemTable();
    }

    @Test
    public void unpinFlushedMemTable1() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), this.getInsertRowNode(devicePath, System.currentTimeMillis()));
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
        handler.pinMemTable();
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        CheckpointManager checkpointManager = this.walNode1.getCheckpointManager();
        handler.unpinMemTable();
        MemTableInfo oldestMemTableInfo = checkpointManager.getOldestUnpinnedMemTableInfo();
        Assert.assertNull((Object)oldestMemTableInfo);
        handler.unpinMemTable();
        Assert.assertNull((Object)checkpointManager.getOldestUnpinnedMemTableInfo());
    }

    @Test
    public void unpinFlushedMemTable2() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), this.getInsertRowsNode(devicePath, System.currentTimeMillis()));
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
        handler.pinMemTable();
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        CheckpointManager checkpointManager = this.walNode1.getCheckpointManager();
        handler.unpinMemTable();
        MemTableInfo oldestMemTableInfo = checkpointManager.getOldestUnpinnedMemTableInfo();
        Assert.assertNull((Object)oldestMemTableInfo);
        handler.unpinMemTable();
        Assert.assertNull((Object)checkpointManager.getOldestUnpinnedMemTableInfo());
    }

    @Test
    public void unpinMemTable1() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        InsertRowNode node1 = this.getInsertRowNode(devicePath, System.currentTimeMillis());
        node1.setSearchIndex(1L);
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), node1);
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        this.walNode1.rollWALFile();
        this.walNode1.rollWALFile();
        ConsensusReqReader.ReqIterator itr = this.walNode1.getReqIterator(1L);
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((Object)node1, (Object)WALEntry.deserializeForConsensus((ByteBuffer)((IConsensusRequest)itr.next().getRequests().get(0)).serializeToByteBuffer()));
        handler.unpinMemTable();
        this.walNode1.deleteOutdatedFiles();
        itr = this.walNode1.getReqIterator(1L);
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void unpinMemTable2() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        InsertRowsNode node1 = this.getInsertRowsNode(devicePath, System.currentTimeMillis());
        node1.setSearchIndex(1L);
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), node1);
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        this.walNode1.rollWALFile();
        this.walNode1.rollWALFile();
        ConsensusReqReader.ReqIterator itr = this.walNode1.getReqIterator(1L);
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((Object)node1, (Object)WALEntry.deserializeForConsensus((ByteBuffer)((IConsensusRequest)itr.next().getRequests().get(0)).serializeToByteBuffer()));
        handler.unpinMemTable();
        this.walNode1.deleteOutdatedFiles();
        itr = this.walNode1.getReqIterator(1L);
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void getUnFlushedValue1() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        InsertRowNode node1 = this.getInsertRowNode(devicePath, System.currentTimeMillis());
        node1.setSearchIndex(1L);
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), node1);
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        Assert.assertEquals((Object)node1, (Object)handler.getInsertNode());
    }

    @Test
    public void getUnFlushedValue2() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        InsertRowsNode node1 = this.getInsertRowsNode(devicePath, System.currentTimeMillis());
        node1.setSearchIndex(1L);
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), node1);
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        Assert.assertEquals((Object)node1, (Object)handler.getInsertNode());
    }

    @Test
    public void getFlushedValue1() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        InsertRowNode node1 = this.getInsertRowNode(devicePath, System.currentTimeMillis());
        node1.setSearchIndex(1L);
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), node1);
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        Assert.assertEquals((Object)node1, (Object)handler.getInsertNode());
    }

    @Test
    public void getFlushedValue2() throws Exception {
        PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
        this.walNode1.onMemTableCreated((IMemTable)memTable, logDirectory1 + "/fake.tsfile");
        InsertRowsNode node1 = this.getInsertRowsNode(devicePath, System.currentTimeMillis());
        node1.setSearchIndex(1L);
        WALFlushListener flushListener = this.walNode1.log(memTable.getMemTableId(), node1);
        WALEntryHandler handler = flushListener.getWalEntryHandler();
        handler.pinMemTable();
        this.walNode1.onMemTableFlushed((IMemTable)memTable);
        Awaitility.await().until(() -> this.walNode1.isAllWALEntriesConsumed());
        Assert.assertEquals((Object)node1, (Object)handler.getInsertNode());
    }

    @Test
    public void testConcurrentGetValue1() throws Exception {
        int threadsNum = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int i = 0; i < threadsNum; ++i) {
            WALNode wALNode = i % 2 == 0 ? this.walNode1 : this.walNode2;
            String logDirectory = i % 2 == 0 ? logDirectory1 : logDirectory2;
            Callable<Void> writeTask = () -> {
                int j;
                PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
                walNode.onMemTableCreated((IMemTable)memTable, logDirectory + "/fake.tsfile");
                ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
                ArrayList<InsertRowNode> expectedInsertRowNodes = new ArrayList<InsertRowNode>();
                try {
                    for (j = 0; j < 1000; ++j) {
                        long memTableId = memTable.getMemTableId();
                        InsertRowNode node = this.getInsertRowNode(devicePath + memTableId, System.currentTimeMillis());
                        expectedInsertRowNodes.add(node);
                        WALFlushListener walFlushListener = walNode.log(memTableId, node);
                        walFlushListeners.add(walFlushListener);
                    }
                }
                catch (IllegalPathException e) {
                    Assert.fail();
                }
                Awaitility.await().until(() -> ((WALNode)walNode).isAllWALEntriesConsumed());
                ((WALFlushListener)walFlushListeners.get(0)).getWalEntryHandler().pinMemTable();
                walNode.onMemTableFlushed((IMemTable)memTable);
                for (j = 0; j < expectedInsertRowNodes.size(); ++j) {
                    InsertRowNode expect = (InsertRowNode)expectedInsertRowNodes.get(j);
                    InsertRowNode actual = (InsertRowNode)((WALFlushListener)walFlushListeners.get(j)).getWalEntryHandler().getInsertNode();
                    Assert.assertEquals((Object)expect, (Object)actual);
                }
                ((WALFlushListener)walFlushListeners.get(0)).getWalEntryHandler().unpinMemTable();
                return null;
            };
            Future<Void> future = executorService.submit(writeTask);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
    }

    @Test
    public void testConcurrentGetValue2() throws Exception {
        int threadsNum = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int i = 0; i < threadsNum; ++i) {
            WALNode wALNode = i % 2 == 0 ? this.walNode1 : this.walNode2;
            String logDirectory = i % 2 == 0 ? logDirectory1 : logDirectory2;
            Callable<Void> writeTask = () -> {
                int j;
                PrimitiveMemTable memTable = new PrimitiveMemTable(databasePath, dataRegionId);
                walNode.onMemTableCreated((IMemTable)memTable, logDirectory + "/fake.tsfile");
                ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
                ArrayList<InsertRowsNode> expectedInsertRowsNodes = new ArrayList<InsertRowsNode>();
                try {
                    for (j = 0; j < 1000; ++j) {
                        long memTableId = memTable.getMemTableId();
                        InsertRowsNode node = this.getInsertRowsNode(devicePath + memTableId, System.currentTimeMillis());
                        expectedInsertRowsNodes.add(node);
                        WALFlushListener walFlushListener = walNode.log(memTableId, node);
                        walFlushListeners.add(walFlushListener);
                    }
                }
                catch (IllegalPathException e) {
                    Assert.fail();
                }
                Awaitility.await().until(() -> ((WALNode)walNode).isAllWALEntriesConsumed());
                ((WALFlushListener)walFlushListeners.get(0)).getWalEntryHandler().pinMemTable();
                walNode.onMemTableFlushed((IMemTable)memTable);
                for (j = 0; j < expectedInsertRowsNodes.size(); ++j) {
                    InsertRowsNode expect = (InsertRowsNode)expectedInsertRowsNodes.get(j);
                    InsertRowsNode actual = (InsertRowsNode)((WALFlushListener)walFlushListeners.get(j)).getWalEntryHandler().getInsertNode();
                    Assert.assertEquals((Object)expect, (Object)actual);
                }
                ((WALFlushListener)walFlushListeners.get(0)).getWalEntryHandler().unpinMemTable();
                return null;
            };
            Future<Void> future = executorService.submit(writeTask);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
    }

    private InsertRowNode getInsertRowNode(String devicePath, long time) throws IllegalPathException {
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false, new Binary("hh0", TSFileConfig.STRING_CHARSET)};
        InsertRowNode node = new InsertRowNode(new PlanNodeId(""), new PartialPath(devicePath), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, time, columns, false);
        MeasurementSchema[] schemas = new MeasurementSchema[6];
        for (int i = 0; i < 6; ++i) {
            schemas[i] = new MeasurementSchema("s" + (i + 1), dataTypes[i]);
        }
        node.setMeasurementSchemas(schemas);
        return node;
    }

    private InsertRowsNode getInsertRowsNode(String devicePath, long firstTime) throws IllegalPathException {
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false, new Binary("hh0", TSFileConfig.STRING_CHARSET)};
        InsertRowNode node = new InsertRowNode(new PlanNodeId(""), new PartialPath(devicePath), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, firstTime, columns, false);
        MeasurementSchema[] schemas = new MeasurementSchema[6];
        for (int i = 0; i < 6; ++i) {
            schemas[i] = new MeasurementSchema("s" + (i + 1), dataTypes[i]);
        }
        node.setMeasurementSchemas(schemas);
        InsertRowsNode insertRowsNode = new InsertRowsNode(new PlanNodeId(""));
        insertRowsNode.addOneInsertRowNode(node, 0);
        node = new InsertRowNode(new PlanNodeId(""), new PartialPath(devicePath), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, firstTime + 10L, columns, false);
        schemas = new MeasurementSchema[6];
        for (int i = 0; i < 6; ++i) {
            schemas[i] = new MeasurementSchema("s" + (i + 1), dataTypes[i]);
        }
        node.setMeasurementSchemas(schemas);
        insertRowsNode.addOneInsertRowNode(node, 1);
        return insertRowsNode;
    }
}

