/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.Checkpoint;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.CheckpointManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.CheckpointType;
import org.apache.iotdb.db.storageengine.dataregion.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.CheckpointReader;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.CheckpointRecoverUtils;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.CheckpointFileUtils;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CheckpointManagerTest {
    private static final String database = "root.test";
    private static final String dataRegionId = "1";
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String identifier = String.valueOf(Integer.MAX_VALUE);
    private static final String logDirectory = TestConstant.BASE_OUTPUT_PATH.concat("wal-test");
    private CheckpointManager checkpointManager;
    private long prevFileSize;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.cleanDir(logDirectory);
        this.prevFileSize = config.getCheckpointFileSizeThresholdInByte();
        config.setCheckpointFileSizeThresholdInByte(10240L);
        this.checkpointManager = new CheckpointManager(identifier, logDirectory);
    }

    @After
    public void tearDown() throws Exception {
        this.checkpointManager.close();
        config.setCheckpointFileSizeThresholdInByte(this.prevFileSize);
        EnvironmentUtils.cleanDir(logDirectory);
    }

    @Test
    public void testNewFile() {
        Checkpoint initCheckpoint = new Checkpoint(CheckpointType.GLOBAL_MEMORY_TABLE_INFO, Collections.emptyList());
        List<Checkpoint> expectedCheckpoints = Collections.singletonList(initCheckpoint);
        CheckpointReader checkpointReader = new CheckpointReader(new File(logDirectory + File.separator + CheckpointFileUtils.getLogFileName((long)0L)));
        List actualCheckpoints = checkpointReader.getCheckpoints();
        Assert.assertEquals(expectedCheckpoints, (Object)actualCheckpoints);
    }

    @Test
    public void testConcurrentWrite() throws Exception {
        int threadsNum = 5;
        ExecutorService executorService = Executors.newFixedThreadPool(threadsNum);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ConcurrentHashMap expectedMemTableId2Info = new ConcurrentHashMap();
        ConcurrentHashMap versionId2memTableId = new ConcurrentHashMap();
        int memTablesNum = 10;
        for (int i = 0; i < memTablesNum; ++i) {
            long l = i;
            Callable<Void> writeTask = () -> {
                String tsFilePath = logDirectory + File.separator + versionId + ".tsfile";
                MemTableInfo memTableInfo = new MemTableInfo((IMemTable)new PrimitiveMemTable(database, dataRegionId), tsFilePath, versionId);
                versionId2memTableId.put(versionId, memTableInfo.getMemTableId());
                this.checkpointManager.makeCreateMemTableCPInMemory(memTableInfo);
                this.checkpointManager.makeCreateMemTableCPOnDisk(memTableInfo.getMemTableId());
                if (versionId < (long)(memTablesNum / 2)) {
                    this.checkpointManager.makeFlushMemTableCP(((Long)versionId2memTableId.get(versionId)).longValue());
                } else {
                    expectedMemTableId2Info.put(memTableInfo.getMemTableId(), memTableInfo);
                }
                return null;
            };
            Future<Void> future = executorService.submit(writeTask);
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        Assert.assertEquals((long)(memTablesNum / 2), (long)this.checkpointManager.getFirstValidWALVersionId());
        Map actualMemTableId2Info = CheckpointRecoverUtils.recoverMemTableInfo((File)new File(logDirectory)).getMemTableId2Info();
        Assert.assertEquals(expectedMemTableId2Info, (Object)actualMemTableId2Info);
    }

    @Test
    public void testTriggerLogRoller() {
        int size = 0;
        long versionId = 0L;
        HashMap<Long, MemTableInfo> expectedMemTableId2Info = new HashMap<Long, MemTableInfo>();
        HashMap<Long, Long> versionId2memTableId = new HashMap<Long, Long>();
        while ((long)size < config.getCheckpointFileSizeThresholdInByte()) {
            String tsFilePath = logDirectory + File.separator + ++versionId + ".tsfile";
            MemTableInfo memTableInfo = new MemTableInfo((IMemTable)new PrimitiveMemTable(database, dataRegionId), tsFilePath, versionId);
            versionId2memTableId.put(versionId, memTableInfo.getMemTableId());
            Checkpoint checkpoint = new Checkpoint(CheckpointType.CREATE_MEMORY_TABLE, Collections.singletonList(memTableInfo));
            size += checkpoint.serializedSize();
            this.checkpointManager.makeCreateMemTableCPInMemory(memTableInfo);
            this.checkpointManager.makeCreateMemTableCPOnDisk(memTableInfo.getMemTableId());
            if (versionId < 5L) {
                checkpoint = new Checkpoint(CheckpointType.FLUSH_MEMORY_TABLE, Collections.singletonList(memTableInfo));
                size += checkpoint.serializedSize();
                this.checkpointManager.makeFlushMemTableCP(((Long)versionId2memTableId.get(versionId)).longValue());
                continue;
            }
            expectedMemTableId2Info.put(memTableInfo.getMemTableId(), memTableInfo);
        }
        this.checkpointManager.fsyncCheckpointFile();
        Assert.assertEquals((long)5L, (long)this.checkpointManager.getFirstValidWALVersionId());
        Assert.assertFalse((boolean)new File(logDirectory + File.separator + CheckpointFileUtils.getLogFileName((long)0L)).exists());
        Assert.assertTrue((boolean)new File(logDirectory + File.separator + CheckpointFileUtils.getLogFileName((long)1L)).exists());
        Map actualMemTableId2Info = CheckpointRecoverUtils.recoverMemTableInfo((File)new File(logDirectory)).getMemTableId2Info();
        Assert.assertEquals(expectedMemTableId2Info, (Object)actualMemTableId2Info);
    }
}

