/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.allocation;

import java.io.File;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.allocation.RoundRobinStrategy;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileUtils;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoundRobinStrategyTest {
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private final String[] walDirs = new String[]{TestConstant.BASE_OUTPUT_PATH.concat("wal_test1"), TestConstant.BASE_OUTPUT_PATH.concat("wal_test2"), TestConstant.BASE_OUTPUT_PATH.concat("wal_test3")};
    private String[] prevWalDirs;

    @Before
    public void setUp() throws Exception {
        this.prevWalDirs = commonConfig.getWalDirs();
        EnvironmentUtils.envSetUp();
        commonConfig.setWalDirs(this.walDirs);
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        for (String walDir : this.walDirs) {
            EnvironmentUtils.cleanDir(walDir);
        }
        commonConfig.setWalDirs(this.prevWalDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllocateWALNode() throws IllegalPathException {
        RoundRobinStrategy roundRobinStrategy = new RoundRobinStrategy(6);
        IWALNode[] walNodes = new IWALNode[6];
        try {
            for (int i = 0; i < 12; ++i) {
                IWALNode walNode = roundRobinStrategy.applyForWALNode(String.valueOf(i));
                if (i < 6) {
                    walNodes[i] = walNode;
                } else {
                    Assert.assertEquals((Object)walNodes[i % 6], (Object)walNode);
                }
                walNode.log((long)i, this.getInsertRowNode());
            }
            for (String string : this.walDirs) {
                File walDirFile = new File(string);
                Assert.assertTrue((boolean)walDirFile.exists());
                File[] nodeDirs = walDirFile.listFiles(File::isDirectory);
                Assert.assertNotNull((Object)nodeDirs);
                Assert.assertEquals((long)2L, (long)nodeDirs.length);
                for (File nodeDir : nodeDirs) {
                    Assert.assertTrue((boolean)nodeDir.exists());
                    Assert.assertNotEquals((long)0L, (long)WALFileUtils.listAllWALFiles((File)nodeDir).length);
                }
            }
        }
        finally {
            for (String string : walNodes) {
                if (string == null) continue;
                string.close();
            }
        }
    }

    private InsertRowNode getInsertRowNode() throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.DOUBLE, TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT};
        Object[] columns = new Object[]{1.0, Float.valueOf(2.0f), 10000L, 100, false, new Binary("hh0", TSFileConfig.STRING_CHARSET)};
        MeasurementSchema[] schemas = new MeasurementSchema[]{new MeasurementSchema("s1", dataTypes[0]), new MeasurementSchema("s2", dataTypes[1]), new MeasurementSchema("s3", dataTypes[2]), new MeasurementSchema("s4", dataTypes[3]), new MeasurementSchema("s5", dataTypes[4]), new MeasurementSchema("s6", dataTypes[5])};
        return new InsertRowNode(new PlanNodeId("0"), new PartialPath("root.test_sg.test_d"), false, new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes, schemas, time, columns, true);
    }
}

