/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceList;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.Assert;
import org.junit.Test;

public class TsFileResourceListTest {
    private TsFileResource generateTsFileResource(int id) {
        File file = new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)id, (long)id, (int)id, (int)id));
        return new TsFileResource(file);
    }

    @Test
    public void testAdd() {
        TsFileResource resourceHasPre;
        TsFileResource resourceHasNext;
        TsFileResourceList tsFileResourceList = new TsFileResourceList();
        ArrayList<TsFileResource> tsFileResources = new ArrayList<TsFileResource>();
        for (int i = 0; i < 5; ++i) {
            TsFileResource resource = this.generateTsFileResource(i);
            tsFileResources.add(resource);
            tsFileResourceList.add(resource);
        }
        resourceHasNext.next = resourceHasNext = new TsFileResource();
        Assert.assertFalse((boolean)tsFileResourceList.add(resourceHasNext));
        resourceHasPre.prev = resourceHasPre = new TsFileResource();
        Assert.assertFalse((boolean)tsFileResourceList.add(resourceHasPre));
        Assert.assertEquals((long)5L, (long)tsFileResourceList.size());
        Iterator iterator = tsFileResourceList.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Assert.assertSame(tsFileResources.get(index++), iterator.next());
        }
    }

    @Test
    public void testKeepOrderInsert() throws Exception {
        TsFileResourceList tsFileResourceList = new TsFileResourceList();
        TsFileResource resource1 = this.generateTsFileResource(10);
        tsFileResourceList.keepOrderInsert(resource1);
        Assert.assertEquals((Object)resource1, (Object)tsFileResourceList.get(0));
        Assert.assertEquals((long)1L, (long)tsFileResourceList.size());
        TsFileResource resource2 = this.generateTsFileResource(100);
        tsFileResourceList.keepOrderInsert(resource2);
        Assert.assertEquals((Object)resource2, (Object)tsFileResourceList.get(1));
        Assert.assertEquals((long)2L, (long)tsFileResourceList.size());
        TsFileResource resource3 = this.generateTsFileResource(50);
        tsFileResourceList.keepOrderInsert(resource3);
        Assert.assertEquals((Object)resource3, (Object)tsFileResourceList.get(1));
        Assert.assertEquals((long)3L, (long)tsFileResourceList.size());
        TsFileResource resource4 = this.generateTsFileResource(75);
        tsFileResourceList.keepOrderInsert(resource4);
        Assert.assertEquals((Object)resource4, (Object)tsFileResourceList.get(2));
        Assert.assertEquals((long)4L, (long)tsFileResourceList.size());
        TsFileResource resource5 = this.generateTsFileResource(5);
        tsFileResourceList.keepOrderInsert(resource5);
        Assert.assertEquals((Object)resource5, (Object)tsFileResourceList.get(0));
        Assert.assertEquals((long)5L, (long)tsFileResourceList.size());
    }

    @Test
    public void testRemove() {
        TsFileResourceList tsFileResourceList = new TsFileResourceList();
        ArrayList<TsFileResource> tsFileResources = new ArrayList<TsFileResource>();
        for (int i = 0; i < 5; ++i) {
            TsFileResource resource = this.generateTsFileResource(i);
            tsFileResources.add(resource);
            tsFileResourceList.add(resource);
        }
        tsFileResourceList.remove(tsFileResources.get(0));
        tsFileResources.remove(0);
        Assert.assertEquals((long)4L, (long)tsFileResourceList.size());
        TsFileResource toBeRemoved = (TsFileResource)tsFileResources.get(3);
        tsFileResourceList.remove((Object)toBeRemoved);
        tsFileResources.remove(toBeRemoved);
        Iterator iterator = tsFileResourceList.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Assert.assertSame(tsFileResources.get(index++), iterator.next());
        }
    }

    @Test
    public void removeNotIncludedResourceTest() {
        TsFileResourceList tsFileResourceList = new TsFileResourceList();
        TsFileResource resource = new TsFileResource();
        tsFileResourceList.add(resource);
        tsFileResourceList.remove((Object)resource);
        Assert.assertEquals((long)0L, (long)tsFileResourceList.size());
        TsFileResource notIncluded = new TsFileResource();
        Assert.assertFalse((boolean)tsFileResourceList.remove((Object)notIncluded));
    }

    @Test
    public void testGetList() {
        TsFileResourceList tsFileResourceList = new TsFileResourceList();
        ArrayList<TsFileResource> tsFileResources = new ArrayList<TsFileResource>();
        for (int i = 0; i < 5; ++i) {
            TsFileResource resource = this.generateTsFileResource(i);
            tsFileResources.add(resource);
            tsFileResourceList.add(resource);
        }
        Iterator iterator = tsFileResourceList.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals(tsFileResources.get(i++), iterator.next());
        }
        Iterator reverseIterator = tsFileResourceList.reverseIterator();
        i = tsFileResourceList.size() - 1;
        while (reverseIterator.hasNext()) {
            Assert.assertEquals(tsFileResources.get(i--), reverseIterator.next());
        }
    }

    @Test
    public void testCount() {
        TsFileResource resource2;
        int i;
        TsFileResourceList tsFileResourceList = new TsFileResourceList();
        ArrayList<TsFileResource> tsFileResources = new ArrayList<TsFileResource>();
        tsFileResourceList.remove((Object)this.generateTsFileResource(2000));
        Assert.assertEquals((long)tsFileResourceList.size(), (long)0L);
        for (i = 0; i < 10; ++i) {
            resource2 = this.generateTsFileResource(i);
            tsFileResources.add(resource2);
            tsFileResourceList.add(resource2);
        }
        Assert.assertEquals((Object)tsFileResourceList.getHeader(), tsFileResources.get(0));
        Assert.assertEquals((Object)tsFileResourceList.getTail(), tsFileResources.get(tsFileResources.size() - 1));
        Assert.assertEquals((long)tsFileResourceList.size(), (long)tsFileResources.size());
        tsFileResourceList.remove(tsFileResources.get(0));
        tsFileResourceList.remove(tsFileResources.get(2));
        tsFileResourceList.remove(tsFileResources.get(tsFileResources.size() - 1));
        Assert.assertEquals((Object)tsFileResourceList.getHeader(), tsFileResources.get(1));
        Assert.assertEquals((Object)tsFileResourceList.getTail(), tsFileResources.get(tsFileResources.size() - 2));
        Assert.assertEquals((long)tsFileResourceList.size(), (long)(tsFileResources.size() - 3));
        for (i = 10; i < 15; ++i) {
            resource2 = this.generateTsFileResource(i);
            tsFileResources.add(resource2);
            tsFileResourceList.add(resource2);
        }
        Assert.assertEquals((Object)tsFileResourceList.getTail(), tsFileResources.get(tsFileResources.size() - 1));
        Assert.assertEquals((long)tsFileResourceList.size(), (long)(tsFileResources.size() - 3));
        tsFileResourceList.remove((Object)this.generateTsFileResource(1000));
        Assert.assertEquals((Object)tsFileResourceList.getHeader(), tsFileResources.get(1));
        Assert.assertEquals((Object)tsFileResourceList.getTail(), tsFileResources.get(tsFileResources.size() - 1));
        Assert.assertEquals((long)tsFileResourceList.size(), (long)(tsFileResources.size() - 3));
        for (TsFileResource resource2 : tsFileResources) {
            tsFileResourceList.remove((Object)resource2);
        }
        Assert.assertEquals((long)tsFileResourceList.size(), (long)0L);
        Assert.assertNull((Object)tsFileResourceList.getHeader());
        Assert.assertNull((Object)tsFileResourceList.getTail());
        for (int i2 = tsFileResources.size() - 1; i2 >= 0; --i2) {
            tsFileResourceList.add((TsFileResource)tsFileResources.get(i2));
        }
        Assert.assertEquals((long)tsFileResourceList.size(), (long)tsFileResources.size());
        Assert.assertEquals((Object)tsFileResourceList.getHeader(), tsFileResources.get(tsFileResources.size() - 1));
        Assert.assertEquals((Object)tsFileResourceList.getTail(), tsFileResources.get(0));
    }

    @Test
    public void testKeepOrderInsertWithSameTimestampAndDifferentVersion() throws IOException {
        ArrayList<TsFileResource> seqResources = new ArrayList<TsFileResource>();
        seqResources.add(new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)1L, (long)1L, (int)0, (int)0))));
        seqResources.add(new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)1L, (long)5L, (int)0, (int)0))));
        seqResources.add(new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)1L, (long)6L, (int)0, (int)0))));
        seqResources.add(new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)2L, (long)4L, (int)0, (int)0))));
        seqResources.add(new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)3L, (long)3L, (int)0, (int)0))));
        seqResources.add(new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)4L, (long)7L, (int)0, (int)0))));
        seqResources.add(new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)4L, (long)9L, (int)0, (int)0))));
        seqResources.add(new TsFileResource(new File(TsFileNameGenerator.generateNewTsFilePath((String)TestConstant.BASE_OUTPUT_PATH, (long)5L, (long)8L, (int)0, (int)0))));
        TsFileResourceList tsFileResourceList = new TsFileResourceList();
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(4));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(3));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(5));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(1));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(0));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(2));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(6));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(7));
        Assert.assertEquals(seqResources, (Object)tsFileResourceList.getArrayList());
        for (TsFileResource resource : seqResources) {
            tsFileResourceList.remove((Object)resource);
        }
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(0));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(4));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(5));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(7));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(2));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(1));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(3));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(6));
        Assert.assertEquals(seqResources, (Object)tsFileResourceList.getArrayList());
        for (TsFileResource resource : seqResources) {
            tsFileResourceList.remove((Object)resource);
        }
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(7));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(1));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(5));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(6));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(2));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(4));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(3));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(0));
        Assert.assertEquals(seqResources, (Object)tsFileResourceList.getArrayList());
        for (TsFileResource resource : seqResources) {
            tsFileResourceList.remove((Object)resource);
        }
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(0));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(1));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(2));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(3));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(4));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(5));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(6));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(7));
        Assert.assertEquals(seqResources, (Object)tsFileResourceList.getArrayList());
        for (TsFileResource resource : seqResources) {
            tsFileResourceList.remove((Object)resource);
        }
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(7));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(6));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(5));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(4));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(3));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(2));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(1));
        tsFileResourceList.keepOrderInsert((TsFileResource)seqResources.get(0));
        Assert.assertEquals(seqResources, (Object)tsFileResourceList.getArrayList());
    }
}

