/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile;

import java.io.File;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;

public class FakedTsFileResource
extends TsFileResource {
    public ITimeIndex timeIndex = new FileTimeIndex();
    public long timePartition;
    private long tsFileSize;
    private String fakeTsfileName;

    public FakedTsFileResource(long tsFileSize, String name) {
        super(new File(name));
        this.tsFileSize = tsFileSize;
        this.fakeTsfileName = name;
        this.setStatusForTest(TsFileResourceStatus.NORMAL);
    }

    public void setTsFileSize(long tsFileSize) {
        this.tsFileSize = tsFileSize;
    }

    public long getTsFileSize() {
        return this.tsFileSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.tsFileSize).append(",");
        builder.append(this.getStatus());
        return builder.toString();
    }

    public File getTsFile() {
        return new File(this.fakeTsfileName);
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof FakedTsFileResource) {
            FakedTsFileResource otherResource = (FakedTsFileResource)((Object)otherObject);
            return this.fakeTsfileName.equals(otherResource.fakeTsfileName) && this.tsFileSize == otherResource.tsFileSize;
        }
        return false;
    }

    public long getTimePartition() {
        return this.timePartition;
    }
}

