/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.DirectoryNotLegalException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.snapshot.SnapshotLoader;
import org.apache.iotdb.db.storageengine.dataregion.snapshot.SnapshotLogAnalyzer;
import org.apache.iotdb.db.storageengine.dataregion.snapshot.SnapshotTaker;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.utils.TsFileGeneratorUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class IoTDBSnapshotTest {
    private String[][] testDataDirs = new String[][]{{"target/data/data1", "target/data/data2", "target/data/data3"}};
    private String testSgName = "root.testsg";

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        FileUtils.recursivelyDeleteFolder((String)("target" + File.separator + "data"));
        EnvironmentUtils.cleanEnv();
        FileUtils.recursivelyDeleteFolder((String)("target" + File.separator + "tmp"));
    }

    private List<TsFileResource> writeTsFiles() throws IOException, WriteProcessException {
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (int i = 0; i < 100; ++i) {
            String filePath = this.testDataDirs[0][i % 3] + File.separator + "sequence" + File.separator + this.testSgName + File.separator + "0" + File.separator + "0" + File.separator + String.format("%d-%d-0-0.tsfile", i + 1, i + 1);
            File newFile = new File(filePath);
            Assert.assertTrue((newFile.getParentFile().exists() || newFile.getParentFile().mkdirs() ? 1 : 0) != 0);
            TsFileGeneratorUtils.generateMixTsFile((String)filePath, (int)5, (int)5, (int)10, (int)(i * 100), (int)((i + 1) * 100), (int)10, (int)10);
            TsFileResource resource = new TsFileResource(new File(filePath));
            Assert.assertTrue((boolean)new File(filePath).exists());
            resources.add(resource);
            for (int idx = 0; idx < 5; ++idx) {
                resource.updateStartTime((IDeviceID)new PlainDeviceID(this.testSgName + "." + "d" + i), (long)(i * 100));
                resource.updateEndTime((IDeviceID)new PlainDeviceID(this.testSgName + "." + "d" + i), (long)((i + 1) * 100));
            }
            resource.updatePlanIndexes((long)i);
            resource.setStatusForTest(TsFileResourceStatus.NORMAL);
            resource.serialize();
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSnapshot() throws IOException, WriteProcessException, DataRegionException, DirectoryNotLegalException {
        String[][] originDataDirs = IoTDBDescriptor.getInstance().getConfig().getTierDataDirs();
        IoTDBDescriptor.getInstance().getConfig().setTierDataDirs(this.testDataDirs);
        TierManager.getInstance().resetFolders();
        try {
            List<TsFileResource> resources = this.writeTsFiles();
            DataRegion region = new DataRegion(this.testSgName, "0");
            region.getTsFileManager().addAll(resources, true);
            File snapshotDir = new File("target" + File.separator + "snapshot");
            Assert.assertTrue((snapshotDir.exists() || snapshotDir.mkdirs() ? 1 : 0) != 0);
            try {
                new SnapshotTaker(region).takeFullSnapshot(snapshotDir.getAbsolutePath(), true);
                File[] files = snapshotDir.listFiles((dir, name) -> name.equals("snapshot.log"));
                Assert.assertEquals((long)1L, (long)files.length);
                SnapshotLogAnalyzer analyzer = new SnapshotLogAnalyzer(files[0]);
                Assert.assertTrue((boolean)analyzer.isSnapshotComplete());
                int cnt = analyzer.getTotalFileCountInSnapshot();
                analyzer.close();
                Assert.assertEquals((long)200L, (long)cnt);
                for (TsFileResource resource : resources) {
                    Assert.assertTrue((boolean)resource.tryWriteLock());
                }
            }
            finally {
                FileUtils.recursivelyDeleteFolder((String)snapshotDir.getAbsolutePath());
            }
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTierDataDirs(originDataDirs);
            TierManager.getInstance().resetFolders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSnapshotWithUnclosedTsFile() throws IOException, WriteProcessException, DirectoryNotLegalException {
        String[][] originDataDirs = IoTDBDescriptor.getInstance().getConfig().getTierDataDirs();
        IoTDBDescriptor.getInstance().getConfig().setTierDataDirs(this.testDataDirs);
        TierManager.getInstance().resetFolders();
        try {
            List<TsFileResource> resources = this.writeTsFiles();
            resources.subList(50, 100).forEach(x -> x.setStatusForTest(TsFileResourceStatus.UNCLOSED));
            DataRegion region = new DataRegion(this.testSgName, "0");
            region.setAllowCompaction(false);
            region.getTsFileManager().addAll(resources, true);
            File snapshotDir = new File("target" + File.separator + "snapshot");
            Assert.assertTrue((snapshotDir.exists() || snapshotDir.mkdirs() ? 1 : 0) != 0);
            try {
                new SnapshotTaker(region).takeFullSnapshot(snapshotDir.getAbsolutePath(), true);
                File[] files = snapshotDir.listFiles((dir, name) -> name.equals("snapshot.log"));
                Assert.assertEquals((long)1L, (long)files.length);
                SnapshotLogAnalyzer analyzer = new SnapshotLogAnalyzer(files[0]);
                int cnt = 0;
                Assert.assertTrue((boolean)analyzer.isSnapshotComplete());
                cnt = analyzer.getTotalFileCountInSnapshot();
                analyzer.close();
                Assert.assertEquals((long)100L, (long)cnt);
                for (TsFileResource resource : resources) {
                    Assert.assertTrue((boolean)resource.tryWriteLock());
                }
            }
            finally {
                FileUtils.recursivelyDeleteFolder((String)snapshotDir.getAbsolutePath());
            }
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTierDataDirs(originDataDirs);
            TierManager.getInstance().resetFolders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadSnapshot() throws IOException, WriteProcessException, DataRegionException, DirectoryNotLegalException {
        String[][] originDataDirs = IoTDBDescriptor.getInstance().getConfig().getTierDataDirs();
        IoTDBDescriptor.getInstance().getConfig().setTierDataDirs(this.testDataDirs);
        TierManager.getInstance().resetFolders();
        try {
            List<TsFileResource> resources = this.writeTsFiles();
            DataRegion region = new DataRegion(this.testSgName, "0");
            region.getTsFileManager().addAll(resources, true);
            File snapshotDir = new File("target" + File.separator + "snapshot");
            Assert.assertTrue((snapshotDir.exists() || snapshotDir.mkdirs() ? 1 : 0) != 0);
            try {
                Assert.assertTrue((boolean)new SnapshotTaker(region).takeFullSnapshot(snapshotDir.getAbsolutePath(), true));
                DataRegion dataRegion = new SnapshotLoader(snapshotDir.getAbsolutePath(), this.testSgName, "0").loadSnapshotForStateMachine();
                Assert.assertNotNull((Object)dataRegion);
                List resource = dataRegion.getTsFileManager().getTsFileList(true);
                Assert.assertEquals((long)100L, (long)resource.size());
            }
            finally {
                FileUtils.recursivelyDeleteFolder((String)snapshotDir.getAbsolutePath());
            }
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setTierDataDirs(originDataDirs);
            TierManager.getInstance().resetFolders();
        }
    }

    @Test
    public void testGetSnapshotFile() throws IOException {
        File tsFile = new File(IoTDBDescriptor.getInstance().getConfig().getLocalDataDirs()[0] + File.separator + "sequence" + File.separator + "root.test" + File.separator + "0" + File.separator + "0" + File.separator + "1-1-0-0.tsfile");
        DataRegion region = (DataRegion)Mockito.mock(DataRegion.class);
        Mockito.when((Object)region.getDatabaseName()).thenReturn((Object)"root.test");
        Mockito.when((Object)region.getDataRegionId()).thenReturn((Object)"0");
        File snapshotFile = new SnapshotTaker(region).getSnapshotFilePathForTsFile(tsFile, "test-snapshotId");
        Assert.assertEquals((Object)new File(IoTDBDescriptor.getInstance().getConfig().getLocalDataDirs()[0] + File.separator + "snapshot" + File.separator + "root.test-0" + File.separator + "test-snapshotId" + File.separator + "sequence" + File.separator + "root.test" + File.separator + "0" + File.separator + "0" + File.separator + "1-1-0-0.tsfile").getAbsolutePath(), (Object)snapshotFile.getAbsolutePath());
        Assert.assertTrue((boolean)snapshotFile.getParentFile().exists());
    }
}

