/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.series;

import java.io.IOException;
import java.util.Collections;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.AbstractSeriesScanTest;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.TimeFilterApi;
import org.apache.iotdb.tsfile.read.filter.factory.ValueFilterApi;
import org.junit.Assert;
import org.junit.Test;

public class SeriesScanPredicatePushDownTest
extends AbstractSeriesScanTest {
    private SeriesScanUtil getSeriesScanUtil(Filter globalTimeFilter, Filter pushDownFilter) throws IllegalPathException {
        MeasurementPath scanPath = new MeasurementPath(TEST_PATH, TSDataType.INT32);
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(Collections.singleton(scanPath.getMeasurement()));
        scanOptionsBuilder.withGlobalTimeFilter(globalTimeFilter);
        scanOptionsBuilder.withPushDownFilter(pushDownFilter);
        SeriesScanUtil seriesScanUtil = new SeriesScanUtil((PartialPath)scanPath, Ordering.ASC, scanOptionsBuilder.build(), EnvironmentUtils.TEST_QUERY_FI_CONTEXT);
        seriesScanUtil.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
        return seriesScanUtil;
    }

    @Test
    public void testNoFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil(null, null);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }

    @Test
    public void testSkipFileByGlobalTimeFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil((Filter)TimeFilterApi.gtEq((long)10L), null);
        this.checkFile1Skipped(seriesScanUtil);
    }

    @Test
    public void testSkipFileByPushDownFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil((Filter)TimeFilterApi.gt((long)0L), (Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(10)));
        this.checkFile1Skipped(seriesScanUtil);
    }

    private void checkFile1Skipped(SeriesScanUtil seriesScanUtil) throws IOException {
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)10L, (long)tsBlock.getTimeByIndex(0));
    }

    @Test
    public void testSkipChunkByGlobalTimeFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil((Filter)TimeFilterApi.gtEq((long)20L), null);
        this.checkFile2Chunk1Skipped(seriesScanUtil);
    }

    @Test
    public void testSkipChunkByPushDownFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil((Filter)TimeFilterApi.gt((long)0L), (Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(20)));
        this.checkFile2Chunk1Skipped(seriesScanUtil);
    }

    private void checkFile2Chunk1Skipped(SeriesScanUtil seriesScanUtil) throws IOException {
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)20L, (long)tsBlock.getTimeByIndex(0));
    }

    @Test
    public void testSkipPageByGlobalTimeFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil((Filter)TimeFilterApi.gtEq((long)40L), null);
        this.checkFile1AndFile2Skipped(seriesScanUtil);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)40L, (long)tsBlock.getTimeByIndex(0));
    }

    @Test
    public void testSkipPageByPushDownFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil((Filter)TimeFilterApi.gt((long)0L), (Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(40)));
        this.checkFile1AndFile2Skipped(seriesScanUtil);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertNull((Object)tsBlock);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)40L, (long)tsBlock.getTimeByIndex(0));
    }

    private void checkFile1AndFile2Skipped(SeriesScanUtil seriesScanUtil) throws IOException {
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
    }

    @Test
    public void testSkipMergeReaderPointByGlobalTimeFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil((Filter)TimeFilterApi.gtEq((long)55L), null);
        this.checkFile1AndFile2AndMergeReaderPointSkipped(seriesScanUtil);
    }

    @Test
    public void testSkipMergeReaderPointByPushDownFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil((Filter)TimeFilterApi.gt((long)0L), (Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(55)));
        this.checkFile1AndFile2AndMergeReaderPointSkipped(seriesScanUtil);
    }

    private void checkFile1AndFile2AndFile3Chunk1Skipped(SeriesScanUtil seriesScanUtil) throws IOException {
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentFileStatistics());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentChunkStatistics());
    }

    private void checkFile1AndFile2AndMergeReaderPointSkipped(SeriesScanUtil seriesScanUtil) throws IOException {
        this.checkFile1AndFile2AndFile3Chunk1Skipped(seriesScanUtil);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)55L, (long)tsBlock.getTimeByIndex(0));
    }

    @Test
    public void testSkipMergeReaderByGlobalTimeFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil((Filter)TimeFilterApi.gtEq((long)60L), null);
        this.checkFile1AndFile2AndFile3Chunk1Skipped(seriesScanUtil);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)60L, (long)tsBlock.getTimeByIndex(0));
    }

    @Test
    public void testSkipMergeReaderByPushDownFilter() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil((Filter)TimeFilterApi.gt((long)0L), (Filter)ValueFilterApi.gtEq((Comparable)Integer.valueOf(60)));
        this.checkFile1AndFile2AndFile3Chunk1Skipped(seriesScanUtil);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertTrue((tsBlock == null || tsBlock.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.canUseCurrentPageStatistics());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
        Assert.assertEquals((long)60L, (long)tsBlock.getTimeByIndex(0));
    }
}

