/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.series;

import java.io.IOException;
import java.util.Collections;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.series.AbstractSeriesScanTest;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.junit.Assert;
import org.junit.Test;

public class SeriesScanLimitOffsetPushDownTest
extends AbstractSeriesScanTest {
    private SeriesScanUtil getSeriesScanUtil(long limit, long offset, Ordering scanOrder) throws IllegalPathException {
        MeasurementPath scanPath = new MeasurementPath(TEST_PATH, TSDataType.INT32);
        SeriesScanOptions.Builder scanOptionsBuilder = new SeriesScanOptions.Builder();
        scanOptionsBuilder.withAllSensors(Collections.singleton(scanPath.getMeasurement()));
        scanOptionsBuilder.withPushDownLimit(limit);
        scanOptionsBuilder.withPushDownOffset(offset);
        SeriesScanUtil seriesScanUtil = new SeriesScanUtil((PartialPath)scanPath, scanOrder, scanOptionsBuilder.build(), EnvironmentUtils.TEST_QUERY_FI_CONTEXT);
        seriesScanUtil.initQueryDataSource(new QueryDataSource(seqResources, unSeqResources));
        return seriesScanUtil;
    }

    @Test
    public void testSkipFile() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil(5L, 10L, Ordering.ASC);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 10L;
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }

    @Test
    public void testSkipChunk() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil(5L, 20L, Ordering.ASC);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 20L;
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }

    @Test
    public void testSkipPage() throws IllegalPathException, IOException {
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil(5L, 30L, Ordering.ASC);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 30L;
        int size = tsBlock.getPositionCount();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }

    @Test
    public void testSkipPoint1() throws IllegalPathException, IOException {
        int i;
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil(10L, 45L, Ordering.ASC);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertTrue((tsBlock == null || tsBlock.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 45L;
        int size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }

    @Test
    public void testSkipPoint2() throws IllegalPathException, IOException {
        int i;
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil(10L, 55L, Ordering.ASC);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 55L;
        int size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime++, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }

    @Test
    public void testSkipPointDesc1() throws IllegalPathException, IOException {
        int i;
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil(10L, 5L, Ordering.DESC);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 64L;
        int size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime--, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        expectedTime = 59L;
        size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime--, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }

    @Test
    public void testSkipPointDesc2() throws IllegalPathException, IOException {
        int i;
        SeriesScanUtil seriesScanUtil = this.getSeriesScanUtil(10L, 25L, Ordering.DESC);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextFile());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        TsBlock tsBlock = seriesScanUtil.nextPage();
        Assert.assertTrue((tsBlock == null || tsBlock.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertTrue((tsBlock == null || tsBlock.isEmpty() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        long expectedTime = 44L;
        int size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime--, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertTrue((boolean)seriesScanUtil.hasNextPage());
        tsBlock = seriesScanUtil.nextPage();
        Assert.assertEquals((long)5L, (long)tsBlock.getPositionCount());
        expectedTime = 39L;
        size = tsBlock.getPositionCount();
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)expectedTime--, (long)tsBlock.getTimeByIndex(i));
        }
        Assert.assertFalse((boolean)seriesScanUtil.hasNextPage());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextChunk());
        Assert.assertFalse((boolean)seriesScanUtil.hasNextFile());
    }
}

